/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.debug;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.matlab.MatlabActionAstNode;
import eu.cqse.check.matlab.MatlabActionParser;
import eu.cqse.check.matlab.MatlabActionParserException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/tokens/debug/matlab-action-parser/{uniformPath}")
public class DebugMatlabActionParserService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get debug output of matlab parser.", description="Returns the debug output of the (cup) matlab parser.", tags={"Debugging"})
    public String getMatlabParserDebugContent(@PathParam(value="uniformPath") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @QueryParam(value="representation") @DefaultValue(value="PARSER_OUTPUT") EMatlabRepresentation representation) throws StorageException {
        TokenElementIndex index = TokenElementIndex.open((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)this.determineHistoryOption(commit));
        TokenElementInfo tokenElement = index.getTokenElement(uniformPath.toString());
        if (tokenElement == null) {
            throw new NotFoundException("No element of name " + String.valueOf(uniformPath) + " found!");
        }
        return DebugMatlabActionParserService.buildRepresentation((List<IToken>)tokenElement.getTokens(), representation);
    }

    public static String buildRepresentation(List<IToken> tokens, EMatlabRepresentation representation) {
        switch (representation.ordinal()) {
            case 0: {
                return tokens.stream().map(IToken::getText).collect(Collectors.joining());
            }
            case 1: {
                return StringUtils.concat(tokens, (String)"\n");
            }
            case 2: {
                return ((MatlabActionAstNode)DebugMatlabActionParserService.getDebugParsingResult(tokens).getFirst()).toString();
            }
            case 3: {
                return (String)DebugMatlabActionParserService.getDebugParsingResult(tokens).getSecond();
            }
        }
        throw new IllegalArgumentException("Unknown representation: " + String.valueOf((Object)representation));
    }

    private static Pair<MatlabActionAstNode, String> getDebugParsingResult(List<IToken> tokens) {
        try {
            return MatlabActionParser.debugParse(tokens);
        }
        catch (MatlabActionParserException e) {
            return Pair.createPair(null, (Object)e.getMessage());
        }
    }

    public static enum EMatlabRepresentation {
        TEXT,
        TOKEN,
        AST,
        PARSER_OUTPUT;

    }
}

