/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.method_history;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.AssociatedMethodTestInfo;
import com.teamscale.index.testgap.ExecutedMethodIndex;
import com.teamscale.index.testgap.MergedTestInfoIndex;
import com.teamscale.index.testgap.MethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.testgap.method_history.EMethodChangeType;
import com.teamscale.service.testgap.method_history.MethodHistoryEntry;
import com.teamscale.service.testgap.method_history.UserResolvedMethodHistoryEntry;
import com.teamscale.service.testgap.method_history.UserResolvedMethodHistoryEntryBuilder;
import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.region.SimpleRegion;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.LineOffsetUtils;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public abstract class MethodHistoryServiceBase
extends ApiBase {
    protected List<PublicProjectId> crossAnnotationExecutionProjects;
    private PairList<PublicProjectId, ExecutedMethodIndex> projectToCrossAnnotationIndex;
    private CrossAnnotator crossAnnotator;
    protected Set<String> partitions;
    protected RepositoryLogIndex repositoryLogIndex;
    protected UserAliasLookup userAliasLookup;
    private static final Logger LOGGER = LogManager.getLogger();

    protected void initializeCrossAnnotator(List<PublicProjectId> crossAnnotationProjects) throws StorageException {
        this.projectToCrossAnnotationIndex = TgaRequestUtils.getCrossAnnotationIndexes(crossAnnotationProjects, ExecutedMethodIndex.class, (IndexLayer)this.getIndexLayer());
        List crossAnnotationIndexes = this.projectToCrossAnnotationIndex.extractSecondList();
        this.crossAnnotator = CrossAnnotator.createForNonIssueRequest((List)crossAnnotationIndexes, (ProjectStorageSystem)this.getProjectStorageSystem());
        this.crossAnnotationExecutionProjects = this.projectToCrossAnnotationIndex.extractFirstList();
    }

    protected SortedSet<UserResolvedMethodHistoryEntry> collectMethodHistoryEntries(String uniformPath, CommitDescriptor commit, OffsetBasedRegion region, long baselineTimestamp) throws StorageException {
        AssociatedMethodInfo methodInfo = this.getMethodInfoAtCommit(uniformPath = UniformPathCompatibilityUtil.resolveToCodePath((String)uniformPath), region, commit);
        if (methodInfo == null) {
            throw new BadRequestException("No method found for given region.");
        }
        NavigableSet<UserResolvedMethodHistoryEntry> entries = new TreeSet().descendingSet();
        HashSet crossAnnotationIndexes = new HashSet(this.crossAnnotator.getCrossAnnotationExecutedIndexesFor(methodInfo));
        this.crossAnnotationExecutionProjects = this.projectToCrossAnnotationIndex.filter((name, index) -> crossAnnotationIndexes.contains(index)).extractFirstList();
        this.addMethodHistoryEntries(methodInfo, commit.getBranchName(), commit.getTimestamp(), -1L, entries, false, baselineTimestamp);
        MethodHistoryServiceBase.removeAllButNewestTestEntryPerPartitionBetweenChanges(entries);
        return entries;
    }

    protected SortedSet<UserResolvedMethodHistoryEntry> getMethodHistoryEntriesForMethodLocations(CommitDescriptor startCommit, CommitDescriptor endCommit, List<MethodLocation> methods) throws StorageException {
        MethodInfoIndex methodInfoIndex = this.openProjectIndex(MethodInfoIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)endCommit));
        Set methodInfos = methodInfoIndex.getAssociatedMethodInfosForExactPathsAndRegions(methods, true);
        return methodInfos.stream().map(entry -> {
            try {
                return this.getMethodHistoryEntriesForMethodInfo((AssociatedMethodInfo)entry, endCommit.getBranchName(), startCommit.getTimestamp());
            }
            catch (StorageException e) {
                return null;
            }
        }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toCollection(TreeSet::new)).descendingSet();
    }

    private static void removeAllButNewestTestEntryPerPartitionBetweenChanges(SortedSet<UserResolvedMethodHistoryEntry> entries) {
        ListMap currentMethodVersionTestedByPartition = new ListMap();
        NavigableSet<UserResolvedMethodHistoryEntry> entriesOrderedFromOldToNew = new TreeSet<UserResolvedMethodHistoryEntry>(entries).descendingSet();
        for (UserResolvedMethodHistoryEntry entry : entriesOrderedFromOldToNew) {
            if (entry.isEntryAddressingChange()) {
                MethodHistoryServiceBase.removeSuperfluousTestEntries(entries, (ListMap<String, UserResolvedMethodHistoryEntry>)currentMethodVersionTestedByPartition);
            }
            if (entry.getMethodChangeType() != EMethodChangeType.TESTED) continue;
            currentMethodVersionTestedByPartition.add((Object)entry.testPartition, (Object)entry);
        }
        MethodHistoryServiceBase.removeSuperfluousTestEntries(entries, (ListMap<String, UserResolvedMethodHistoryEntry>)currentMethodVersionTestedByPartition);
    }

    private static void removeSuperfluousTestEntries(SortedSet<UserResolvedMethodHistoryEntry> entries, ListMap<String, UserResolvedMethodHistoryEntry> currentMethodVersionTestedByPartition) {
        currentMethodVersionTestedByPartition.forEach(partitionAndTestEntries -> {
            List allTestEntriesForPartition = (List)partitionAndTestEntries.getValue();
            List testEntriesWithoutLatest = allTestEntriesForPartition.subList(0, allTestEntriesForPartition.size() - 1);
            testEntriesWithoutLatest.forEach(entries::remove);
        });
        currentMethodVersionTestedByPartition.clear();
    }

    private void addMethodHistoryEntries(AssociatedMethodInfo methodInfo, String branchName, long lookForTestsUntil, long lookForHistoryUntil, Collection<UserResolvedMethodHistoryEntry> entries, boolean onlyChanges, long baselineTimestamp) throws StorageException {
        if (methodInfo.getLastInfoUpdateCommit().getTimestamp() < lookForHistoryUntil) {
            return;
        }
        List predecessors = methodInfo.calculatePredecessors((ProjectStorageSystem)this.getProjectStorageSystem());
        EMethodChangeType methodChangeType = this.getMethodChangeType(methodInfo, predecessors, branchName);
        boolean wasRenamedOrMoved = MethodHistoryServiceBase.methodRenamedOrMoved(methodInfo, predecessors);
        if (methodChangeType != EMethodChangeType.UNCHANGED || wasRenamedOrMoved && !onlyChanges) {
            entries.add(this.createMethodHistoryEntry(methodInfo, predecessors, methodChangeType, wasRenamedOrMoved));
        }
        if (!onlyChanges) {
            entries.addAll(this.getMethodTestInfoEntries(lookForTestsUntil, branchName, methodInfo));
        }
        if (predecessors.isEmpty()) {
            return;
        }
        if (methodInfo.getLastInfoUpdateCommit().getTimestamp() >= baselineTimestamp) {
            this.continueHistory(branchName, methodInfo.getLastInfoUpdateCommit().getTimestamp(), lookForHistoryUntil, entries, onlyChanges, baselineTimestamp, (AssociatedMethodInfo)predecessors.get(0));
        } else if (!onlyChanges) {
            this.addBranchExternMethodHistory(predecessors, entries);
        }
    }

    private void continueHistory(String branchName, long lookForTestsUntil, long lookForHistoryUntil, Collection<UserResolvedMethodHistoryEntry> entries, boolean onlyChanges, long baselineTimestamp, AssociatedMethodInfo predecessor) throws StorageException {
        boolean branchSwitch;
        String predecessorBranchName = predecessor.getLastInfoUpdateCommit().getBranchName();
        boolean bl = branchSwitch = !branchName.equals(predecessorBranchName);
        if (branchSwitch) {
            lookForTestsUntil = predecessor.getLastInfoUpdateCommit().getTimestamp() + 500L + 1L;
        }
        this.addMethodHistoryEntries(predecessor, predecessorBranchName, lookForTestsUntil, lookForHistoryUntil, entries, onlyChanges, baselineTimestamp);
    }

    private SortedSet<UserResolvedMethodHistoryEntry> getMethodHistoryEntriesForMethodInfo(AssociatedMethodInfo methodInfo, String branchName, long lookUntil) throws StorageException {
        NavigableSet<UserResolvedMethodHistoryEntry> entries = new TreeSet().descendingSet();
        this.addMethodHistoryEntries(methodInfo, branchName, lookUntil, lookUntil, entries, true, lookUntil);
        return entries;
    }

    private void addBranchExternMethodHistory(List<AssociatedMethodInfo> predecessorsFromOtherBranch, Collection<UserResolvedMethodHistoryEntry> entries) throws StorageException {
        for (AssociatedMethodInfo predecessorFromOtherBranch : predecessorsFromOtherBranch) {
            entries.add(this.createMethodHistoryEntry(predecessorFromOtherBranch, (List<AssociatedMethodInfo>)CollectionUtils.emptyList(), EMethodChangeType.HISTORY_ON_BRANCH, false));
        }
    }

    private UserResolvedMethodHistoryEntry createMethodHistoryEntry(AssociatedMethodInfo methodInfo, @NonNull List<AssociatedMethodInfo> predecessors, EMethodChangeType methodChangeType, boolean wasRenamedOrMoved) throws StorageException {
        String uniformPath = methodInfo.getUniformPath();
        OffsetBasedRegion region = methodInfo.getAssociatedRegion();
        CommitDescriptor lastInfoUpdateCommit = methodInfo.getLastInfoUpdateCommit();
        LineBasedRegion lineBasedRegion = this.getLineBasedRegion(uniformPath, region, lastInfoUpdateCommit);
        ParentedCommitDescriptor commit = new ParentedCommitDescriptor(lastInfoUpdateCommit, CollectionUtils.filter((Collection)methodInfo.extractPredecessorCommits(), parentCommit -> !MethodInfo.isDummyCommit((CommitDescriptor)parentCommit)));
        RepositoryLogEntryAggregate commitDetails = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(lastInfoUpdateCommit);
        UserResolvedMethodHistoryEntryBuilder entryBuilder = new UserResolvedMethodHistoryEntryBuilder((CommitDescriptor)commit, uniformPath, region, lineBasedRegion, methodInfo.getMethodName(), commitDetails.toAggregateLogEntryWithPrimaryRepository(), methodChangeType);
        if (wasRenamedOrMoved) {
            MethodHistoryServiceBase.addOriginInfo(methodInfo, entryBuilder, predecessors);
        }
        if (commit.isMergeCommit()) {
            this.addExternalBranchHistoryReferences(methodInfo, entryBuilder, predecessors);
        }
        return entryBuilder.build(this.userAliasLookup);
    }

    private static void addOriginInfo(AssociatedMethodInfo methodInfo, UserResolvedMethodHistoryEntryBuilder entryBuilder, @NonNull List<AssociatedMethodInfo> predecessors) {
        if (predecessors.isEmpty()) {
            LOGGER.error("No predecessor given for " + String.valueOf(methodInfo) + ", but it was renamed or moved, so a predecessor is required.");
            return;
        }
        AssociatedMethodInfo firstPredecessor = predecessors.get(0);
        entryBuilder.setOriginPath(firstPredecessor.getUniformPath()).setOriginMethodName(firstPredecessor.getMethodName());
    }

    private void addExternalBranchHistoryReferences(AssociatedMethodInfo methodInfo, UserResolvedMethodHistoryEntryBuilder entryBuilder, @NonNull List<AssociatedMethodInfo> predecessors) throws StorageException {
        if (predecessors.size() < 2) {
            LOGGER.error("Only " + predecessors.size() + " predecessor given for " + String.valueOf(methodInfo) + ", but it is a merge commit, so at least two predecessors are required.");
            return;
        }
        for (AssociatedMethodInfo predecessor : predecessors.subList(1, predecessors.size())) {
            entryBuilder.addExternBranchMethodHistoryEntry(this.createMethodHistoryEntry(predecessor, (List<AssociatedMethodInfo>)CollectionUtils.emptyList(), EMethodChangeType.HISTORY_ON_BRANCH, false));
        }
    }

    private static boolean methodRenamedOrMoved(AssociatedMethodInfo methodInfo, List<AssociatedMethodInfo> predecessors) {
        if (predecessors.isEmpty()) {
            return false;
        }
        AssociatedMethodInfo firstPredecessor = predecessors.get(0);
        boolean methodWasRenamed = !firstPredecessor.getMethodName().equals(methodInfo.getMethodName());
        boolean methodWasMoved = !firstPredecessor.getUniformPath().equals(methodInfo.getUniformPath());
        return methodWasRenamed || methodWasMoved;
    }

    private EMethodChangeType getMethodChangeType(AssociatedMethodInfo methodInfo, List<AssociatedMethodInfo> predecessors, String branchName) throws StorageException {
        AssociatedMethodInfo predecessor;
        if (methodInfo.hasNoPredecessorOnCurrentBranch()) {
            return EMethodChangeType.ADDED;
        }
        Pair predecessorCommitOnBranchWithKey = methodInfo.extractPredecessorInBranch(branchName);
        if (predecessorCommitOnBranchWithKey != null) {
            predecessor = this.getMethodInfoAtCommit((Pair<CommitDescriptor, String>)predecessorCommitOnBranchWithKey);
        } else {
            List<AssociatedMethodInfo> predecessorsOnOtherBranches = predecessors.stream().filter(predecessorOnOtherBranch -> !predecessorOnOtherBranch.getLastInfoUpdateCommit().getBranchName().equals(branchName)).toList();
            if (predecessorsOnOtherBranches.isEmpty()) {
                LOGGER.error("No predecessors found for " + String.valueOf(methodInfo) + ". Every method is expected to have at least one (dummy) predecessor.");
                return EMethodChangeType.UNKNOWN;
            }
            predecessor = predecessorsOnOtherBranches.get(0);
        }
        if (predecessor.getLastChangedTimestamp() != methodInfo.getLastChangedTimestamp()) {
            return EMethodChangeType.MODIFIED;
        }
        return EMethodChangeType.UNCHANGED;
    }

    private AssociatedMethodInfo getMethodInfoAtCommit(Pair<CommitDescriptor, String> commitWithKey) throws StorageException {
        String key = (String)commitWithKey.getSecond();
        return this.getMethodInfoAtCommit(MethodInfoIndex.getUniformPathFromKey((String)key), MethodInfoIndex.getRegion((String)key), (CommitDescriptor)commitWithKey.getFirst());
    }

    private AssociatedMethodInfo getMethodInfoAtCommit(String uniformPath, OffsetBasedRegion region, CommitDescriptor commit) throws StorageException {
        MethodInfoIndex methodInfoIndex = this.openProjectIndex(MethodInfoIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
        return methodInfoIndex.getAssociatedMethodInfoWithCrossAnnotationInfoLoaded(uniformPath, region);
    }

    private List<UserResolvedMethodHistoryEntry> getMethodTestInfoEntries(long endTimestamp, String branchName, AssociatedMethodInfo methodInfo) throws StorageException {
        long startTimestamp = methodInfo.getLastInfoUpdateCommit().getTimestamp();
        ArrayList<UserResolvedMethodHistoryEntry> result = new ArrayList<UserResolvedMethodHistoryEntry>();
        List<String> partitions = this.getAllPartitions(branchName);
        HistoryAccessOption historyAccess = HistoryAccessOption.readTimestamp((String)branchName, (long)(endTimestamp - 1L));
        MethodLastTestedIndex methodLastTestedIndex = this.openProjectIndex(MethodLastTestedIndex.class, historyAccess);
        List testInfos = methodLastTestedIndex.getTestInfosForPartitionsAndExactPath(partitions, methodInfo.getUniformPath());
        OffsetBasedRegion region = methodInfo.getAssociatedRegion();
        List<AssociatedMethodTestInfo> executedMethods = testInfos.stream().filter(info -> info.getAssociatedRegion().equalsStartEnd((SimpleRegion)region) && info.getTimestamp() >= startTimestamp).sorted((e1, e2) -> Long.compare(e2.getTimestamp(), e1.getTimestamp())).toList();
        String methodKey = MethodInfoIndex.makeKeyFromPathAndRegion((String)methodInfo.getUniformPath(), (OffsetBasedRegion)methodInfo.getAssociatedRegion());
        for (String partition : partitions) {
            RepositoryLogEntry entry;
            AssociatedMethodTestInfo executedMethod = executedMethods.stream().filter(e -> e.getPartition().equals(partition)).findFirst().orElse(null);
            if (executedMethod == null) continue;
            CommitDescriptor testCommit = executedMethod.getCommit();
            MergedTestInfoIndex mergedTestInfoIndex = this.openProjectIndex(MergedTestInfoIndex.class, null);
            CommitDescriptor testOriginCommit = mergedTestInfoIndex.getTestOriginForCommit(testCommit, methodKey);
            EMethodChangeType changeType = EMethodChangeType.TESTED;
            if (testOriginCommit != null) {
                entry = this.getRepositoryLogEntry(testOriginCommit);
                if (entry == null) {
                    LOGGER.error("Could not resolve the test origin commit for " + String.valueOf(testCommit) + ". The test origin commit " + String.valueOf(testOriginCommit) + " does not exist in the repository log index.");
                    entry = RepositoryLogEntry.createDummyCodeCommitEntry((CommitDescriptor)testOriginCommit);
                    changeType = EMethodChangeType.UNKNOWN;
                }
            } else {
                entry = this.getRepositoryLogEntry(testCommit);
                if (entry == null) {
                    LOGGER.error("Could not find entry for test upload in the repository log for timestamp " + executedMethod.getTimestamp() + ".");
                    entry = RepositoryLogEntry.createDummyCodeCommitEntry((CommitDescriptor)testCommit);
                    changeType = EMethodChangeType.UNKNOWN;
                }
            }
            LineBasedRegion lineBasedRegion = this.getLineBasedRegion(executedMethod.getUniformPath(), region, testCommit);
            result.add(new UserResolvedMethodHistoryEntryBuilder(testCommit, executedMethod.getUniformPath(), region, lineBasedRegion, methodInfo.getMethodName(), entry, changeType).setTestPartition(executedMethod.getPartition()).setTestOriginCommit(testOriginCommit).build(this.userAliasLookup));
        }
        return result;
    }

    private RepositoryLogEntry getRepositoryLogEntry(CommitDescriptor commit) throws StorageException {
        RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(commit);
        if (logEntry == null) {
            return null;
        }
        return logEntry.toAggregateLogEntryWithPrimaryRepository();
    }

    protected List<String> getAllPartitions(String branchName) throws StorageException {
        MethodLastTestedIndex index = this.openProjectIndex(MethodLastTestedIndex.class, HistoryAccessOption.readHead((String)branchName));
        List allPartitions = index.getPartitions();
        if (this.partitions == null || this.partitions.isEmpty()) {
            return allPartitions;
        }
        return allPartitions.stream().filter(this.partitions::contains).collect(Collectors.toList());
    }

    private LineBasedRegion getLineBasedRegion(String uniformPath, OffsetBasedRegion region, CommitDescriptor commit) throws StorageException {
        TokenElementLineInfoIndex tokenElementLineInfoIndex = this.openProjectIndex(TokenElementLineInfoIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
        TokenElementLineInfo lineInfo = tokenElementLineInfoIndex.getLineInfo(uniformPath);
        CCSMAssert.isNotNull((Object)lineInfo, (String)("Could not find line info for " + uniformPath));
        LineOffsetConverter lineOffsetConverter = lineInfo.getRawLineOffsetConverter();
        return LineOffsetUtils.convertToLineRegion((OffsetBasedRegion)region, (LineOffsetConverter)lineOffsetConverter);
    }

    protected static long getLastTestedTimestamp(SortedSet<UserResolvedMethodHistoryEntry> entries) {
        Optional<UserResolvedMethodHistoryEntry> latestTestEntry = entries.stream().filter(entry -> entry.getMethodChangeType() == EMethodChangeType.TESTED).findFirst();
        return latestTestEntry.map(MethodHistoryEntry::getCommit).map(CommitDescriptor::getTimestamp).orElse(0L);
    }
}

