/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.table;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaPathRequest;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.metrics.table.MetricTableServiceUtils;
import com.teamscale.service.metrics.table.RootedList;
import com.teamscale.service.metrics.table.SinglePathDescriptor;
import com.teamscale.service.testgap.CrossAnnotationServiceBase;
import com.teamscale.service.testgap.table.ETgaFigure;
import com.teamscale.service.testgap.table.TgaAssessment;
import com.teamscale.service.testgap.table.TgaNumericValue;
import com.teamscale.service.testgap.table.TgaTableEntry;
import com.teamscale.service.testgap.table.TgaValueEntry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Path(value="api/projects/{project}/test-gaps/metrics")
public class TgaTableService
extends CrossAnnotationServiceBase {
    @GET
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get metric table entries", description="Retrieves various test gap metrics (e.g., test gap state, number of test gaps, execution state and churn) and returns them in tabular form.", tags={"Test Gap Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<TgaTableEntry> getTgaTable(@BeanParam CoverageSourceQueryParameters coverageSourceParameters, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalParameters, @BeanParam TgaRequestQueryOptions tgaRequestParameters, @Parameter(description="Parameter determining if only changed methods should be returned") @QueryParam(value="exclude-unchanged-methods") boolean excludeUnchangedMethods) throws StorageException {
        this.checkCrossAnnotationPermissions((CoverageSourceParameterBase)coverageSourceParameters);
        ETgaAssessmentType assessmentType = ETgaAssessmentType.EXECUTION_ONLY;
        TgaPathRequest request = TgaPathRequest.createRequest((CoverageSourceParameterBase)coverageSourceParameters, (TimeIntervalBasedServiceQueryOptions)timeIntervalParameters, (TgaRequestQueryOptions)tgaRequestParameters, (ETgaAssessmentType)assessmentType, (IndexLayer)this.serviceInfo.getIndexLayer(), (IProjectId)this.serviceInfo.getPrimaryPublicId());
        HistoryAccessOption indexAccess = HistoryAccessOption.readTimestamp((String)request.getIndexAccessCommit().getBranchName(), (long)request.getIndexAccessCommit().getTimestamp());
        RootedList<SinglePathDescriptor> pathDescriptors = MetricTableServiceUtils.collectAllSubPaths(UniformPathCompatibilityUtil.convert((String)request.getPathPrefix()), indexAccess, (ProjectStorageSystem)this.getProjectStorageSystem());
        AssessedTgaData data = request.fetchAndAssessData();
        RootedList.RootedData testCodeClassification = pathDescriptors.bulkMap(entries -> MetricTableServiceUtils.areTestCode(Lists.newArrayList(entries.iterator()), (ExtendedResourceTypeIndex)this.getProjectStorageSystem().openProjectIndex(ExtendedResourceTypeIndex.class, indexAccess)));
        ArrayList<TgaTableEntry> tgaTableEntries = new ArrayList<TgaTableEntry>();
        List methods = data.getFilteredUnchangedMethods(excludeUnchangedMethods, false);
        for (Map.Entry entry : testCodeClassification.rootAndChildEntries().toList()) {
            List<AssessedTgaData.AssessedMethodData> assessedMethods = TgaTableService.getMethodsUnderSubpath(entry.getKey(), request, methods);
            TgaNumericValue numberOfTestGaps = new TgaNumericValue(null);
            if (!assessedMethods.isEmpty()) {
                numberOfTestGaps = new TgaNumericValue(TgaAggregationUtils.countTestGaps(assessedMethods));
            }
            List<TgaValueEntry> values = List.of(new TgaValueEntry(ETgaFigure.TEST_GAP_STATES, TgaAssessment.create(ETgaAssessmentType.TEST_GAP, assessedMethods)), new TgaValueEntry(ETgaFigure.NUMBER_OF_TEST_GAPS, numberOfTestGaps), new TgaValueEntry(ETgaFigure.EXECUTION_STATES, TgaAssessment.create(ETgaAssessmentType.EXECUTION_ONLY, assessedMethods)), new TgaValueEntry(ETgaFigure.TEST_GAP_CHURN, TgaAssessment.create(ETgaAssessmentType.CHURN, assessedMethods)));
            tgaTableEntries.add(new TgaTableEntry(entry.getKey(), values, (Boolean)entry.getValue()));
        }
        return tgaTableEntries;
    }

    private static List<AssessedTgaData.AssessedMethodData> getMethodsUnderSubpath(SinglePathDescriptor path, TgaPathRequest request, List<AssessedTgaData.AssessedMethodData> methods) {
        if (path.getUniformPath().equals(request.getPathPrefix())) {
            return methods;
        }
        return CollectionUtils.filter(methods, method -> TgaTableService.isInSubPath(method.getLocation().getUniformPath(), path.getUniformPath()));
    }

    static boolean isInSubPath(String uniformPath, String filterPath) {
        return filterPath.isEmpty() || uniformPath.equals(filterPath) || uniformPath.startsWith(filterPath + UniformPathUtils.SEPARATOR);
    }
}

