/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.upload;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.plsql.HProfMethodMappingIndex;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.BodyPartWrapper;
import com.teamscale.service.testgap.upload.SourceLocationBasedUploadServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/projects/{project}/external-upload/session/{sessionId}/plsql-hprof")
public class HProfCoverageUploadService
extends SourceLocationBasedUploadServiceBase<String, SessionBasedExternalAnalysisServiceQueryOptions> {
    private static final String PROCEDURE_CALL = "P#C";
    private static final Pattern PROCEDURE_CALL_PATTERN = Pattern.compile("P#C .*\"(.*)\"\\.\"(.*)\"::\\d*.\"(.*)\"#.*");

    @POST
    @Operation(summary="Upload PL/SQL coverage", description="Adds coverage information from the PL/SQL Hierarchical Profiler profiler to the session. For performance reasons, it is recommended to batch calls to this service, i.e. not commit all files using single calls.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="404", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="404", description="No session with provided id found."), @ApiResponse(responseCode="400", description="Provided partition name is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Provided upload message is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Session has been committed or deleted."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="No reports provided via the report multi-part form data parameter"), @ApiResponse(responseCode="400", description="Upload failed. PL/SQL Hierarchical Profiler analysis is not enabled.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Consumes(value={"multipart/form-data"})
    public void uploadHProfCoverage(@Parameter(description="If session ID is provided, the results will be appended to the given session instead of creating a new session. Use \"auto-create\" in place of session ID to create a new session, perform upload and commit session in one step.") @PathParam(value="sessionId") String sessionId, @BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters, @Parameter(required=true, array=@ArraySchema(schema=@Schema(type="string", format="binary"))) @FormDataParam(value="report") List<FormDataBodyPart> reports) throws StorageException, IOException {
        List<BodyPartWrapper> bodyParts = HProfCoverageUploadService.readFormDataBodyParts(reports);
        this.logManager.logReports(bodyParts);
        this.process(EHttpMethod.POST, new ArrayList<BodyPartWrapper>(bodyParts), parameters, sessionId);
    }

    private void checkIfHProfIsEnabled() throws StorageException {
        Set configuredTools = AnalysisProfileUtils.getConfiguredTools((MetaIndex)this.openProjectIndex(MetaIndex.class, null));
        if (!configuredTools.contains(EAnalysisTool.PLSQL_HPROF)) {
            throw new BadRequestException("Upload failed. " + EAnalysisTool.PLSQL_HPROF.getReadableName() + " analysis is not enabled in the analysis configuration for project: " + String.valueOf(this.serviceInfo.getPrimaryPublicId()) + ".");
        }
    }

    @Override
    protected ExternalAnalysisImportInfos doMappingAndCreateImportInfos(HistoryAccessOption historyAccessOption, Set<String> procedures, SessionBasedExternalAnalysisServiceQueryOptions parameters) throws StorageException {
        this.checkIfHProfIsEnabled();
        HProfMethodMappingIndex mappingIndex = this.openProjectIndex(HProfMethodMappingIndex.class, historyAccessOption);
        return HProfCoverageUploadService.createImportInfos(new ArrayList<String>(procedures), mappingIndex, historyAccessOption.getTimestamp());
    }

    @Override
    protected Set<String> parseReport(BodyPartWrapper bodyPartWrapper) {
        HashSet<String> procedureKeys = new HashSet<String>();
        for (String line : StringUtils.splitLines((String)bodyPartWrapper.getBodyPart())) {
            Matcher matcher;
            if (!line.startsWith(PROCEDURE_CALL) || !(matcher = PROCEDURE_CALL_PATTERN.matcher(line)).matches()) continue;
            String schema = matcher.group(1);
            String packageName = matcher.group(2);
            String procedure = matcher.group(3);
            procedureKeys.add(schema + "." + packageName + "." + procedure);
        }
        return procedureKeys;
    }

    private static ExternalAnalysisImportInfos createImportInfos(List<String> procedures, HProfMethodMappingIndex mappingIndex, long timestamp) throws StorageException {
        PairList mappings = mappingIndex.getSourceLocationsForKeyPrefixes(procedures);
        HashSet unmappedProcedures = CollectionUtils.differenceSet(procedures, (Collection[])new Collection[]{mappings.extractFirstList()});
        String warningMessage = unmappedProcedures.stream().sorted().collect(Collectors.joining(StringUtils.LINE_SEPARATOR));
        if (!warningMessage.isEmpty()) {
            LOGGER.warn("Could not map procedures:\n" + warningMessage);
        }
        List locations = mappings.extractSecondList();
        Map<String, List<SourceLocation>> groupedLocations = locations.stream().collect(Collectors.groupingBy(SourceLocation::getUniformPath));
        return new ExternalAnalysisImportInfos(CollectionUtils.map(groupedLocations.entrySet(), entry -> HProfCoverageUploadService.createImportInfo(timestamp, (String)entry.getKey(), (List)entry.getValue())));
    }
}

