/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization.strategies;

import com.teamscale.index.testimpact.MethodId;
import com.teamscale.service.testimpact.MinimizationProgressCallback;
import com.teamscale.service.testimpact.prioritization.ETestSelectionReason;
import com.teamscale.service.testimpact.prioritization.IPrioritizableTests;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.PrioritizeUnderBudgetCallback;
import com.teamscale.service.testimpact.prioritization.preprocessing.LoadAllCoveredMethodsStep;
import com.teamscale.service.testimpact.prioritization.preprocessing.LoadTestDurationStep;
import com.teamscale.service.testimpact.prioritization.preprocessing.PreprocessingStepManager;
import com.teamscale.service.testimpact.prioritization.strategies.ERoundState;
import com.teamscale.service.testimpact.prioritization.strategies.RoundBasedTestPrioritizationStrategyBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class CoverageRoundBasedTestPrioritizationStrategyBase
extends RoundBasedTestPrioritizationStrategyBase {
    private Set<MethodId> methodsCoveredInRound;
    private final Set<MethodId> methodsCoveredInTotal = new HashSet<MethodId>();

    public CoverageRoundBasedTestPrioritizationStrategyBase(MinimizationProgressCallback progressCallback) {
        super(progressCallback);
    }

    @Override
    public void loadFurtherData(PreprocessingStepManager preprocessingStepManager, Set<PrioritizableTest> tests) throws StorageException {
        preprocessingStepManager.getStep(LoadAllCoveredMethodsStep.class).execute(tests);
        preprocessingStepManager.getStep(LoadTestDurationStep.class).execute(tests);
    }

    @Override
    public <T extends IPrioritizableTests> List<T> orderMultipleTests(Collection<T> relevantTests, Set<MethodId> methodsToTest, @Nullable Long maxTestSuiteRuntimeMs, PrioritizeUnderBudgetCallback<T> budgetCallback) throws InterruptedException, StorageException {
        relevantTests.forEach(test -> test.initAdditionallyCoveredMethods(methodsToTest));
        return super.orderMultipleTests(relevantTests, methodsToTest, maxTestSuiteRuntimeMs, budgetCallback);
    }

    @Override
    protected <T extends IPrioritizableTests> Set<T> filterAvailableTests(Set<T> availableTests, ERoundState roundState) {
        Set filteredTests = CollectionUtils.filterToSet(availableTests, (Predicate)ETestSelectionReason.containsAnyFilter((ETestSelectionReason)roundState.getRelevantTestSelectionReason()), LinkedHashSet::new);
        if (filteredTests.isEmpty() && roundState.isEndState()) {
            return availableTests;
        }
        return filteredTests;
    }

    @Override
    protected <T extends IPrioritizableTests> void updateTestInfosBeforePrioritizationRound(Set<T> availableTests, ERoundState roundState) {
        boolean testsCoveringChangesRemain;
        this.methodsCoveredInRound = new HashSet<MethodId>();
        if (roundState.isCoverageBasedPrioritizationRound() && (testsCoveringChangesRemain = availableTests.stream().anyMatch(ETestSelectionReason.containsAnyFilter((ETestSelectionReason)ETestSelectionReason.COVERS_CHANGES)))) {
            availableTests.forEach(IPrioritizableTests::resetCurrentAdditionallyCoveredMethods);
        }
        super.updateTestInfosBeforePrioritizationRound(availableTests, roundState);
    }

    @Override
    protected <T extends IPrioritizableTests> void updateTestInfosAfterTestSelection(Set<T> availableTests, T selectedTest, ERoundState roundState) {
        ArrayList<MethodId> newlyCoveredMethods = new ArrayList<MethodId>();
        for (MethodId coveredMethod : selectedTest.getCoveredChangedMethods()) {
            if (this.methodsCoveredInRound.add(coveredMethod)) {
                newlyCoveredMethods.add(coveredMethod);
            }
            if (!this.methodsCoveredInTotal.add(coveredMethod)) continue;
            selectedTest.incrementNumberOfAdditionallyCoveredMethods();
        }
        for (IPrioritizableTests test : availableTests) {
            test.removeFromCurrentAdditionallyCoveredMethods(newlyCoveredMethods);
        }
        super.updateTestInfosAfterTestSelection(availableTests, selectedTest, roundState);
    }

    @Override
    protected <T extends IPrioritizableTests> boolean shouldAbortPrioritizationRound(Set<T> availableTests, ERoundState roundState) {
        if (!roundState.isCoverageBasedPrioritizationRound()) {
            return false;
        }
        boolean anyAdditionallyCoverable = availableTests.stream().anyMatch(t -> t.getNumberOfCurrentAdditionallyCoveredMethods() > 0L);
        if (!anyAdditionallyCoverable && roundState == ERoundState.ROUND_COVER_CHANGES_TO_EXHAUSTION) {
            availableTests.forEach(IPrioritizableTests::resetCurrentAdditionallyCoveredMethods);
        }
        return !anyAdditionallyCoverable && roundState == ERoundState.ROUND_COVER_CHANGES_ONCE;
    }
}

