/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.index.repository.git.gitea.GiteaChangeRetriever;
import com.teamscale.index.repository.git.gitea.GiteaMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.gitea.data.GiteaPullRequest;
import com.teamscale.index.repository.git.gitea.data.GiteaRepository;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.webhook.GitManagementPlatformWebhookServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/gitea/web-hook")
public class GiteaWebhookService
extends GitManagementPlatformWebhookServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String GITEA_EVENT_HEADER_NAME = "X-Gitea-Event";

    public GiteaWebhookService() {
        super(GiteaChangeRetriever.class);
    }

    @POST
    @Operation(summary="Handles incoming requests from Gitea.", description="Handles the incoming requests from Gitea and processes the request body depending on the event. The events which are handled by the service are 'push' and 'pull_request'.", tags={"Voting Connectors"})
    @Consumes(value={"application/json"})
    @RequiresNoLogin
    public Response processWebhook(@HeaderParam(value="X-Gitea-Event") String event, @RequestBody byte[] requestBody) throws StorageException {
        String content = StringUtils.bytesToString((byte[])requestBody);
        LOGGER.debug("Received a web hook request from Gitea with event \"{}\" and payload: {}", (Object)event, (Object)content);
        if (StringUtils.isEmpty((String)event)) {
            throw new BadRequestException("Missing X-Gitea-Event header!");
        }
        switch (event) {
            case "push": {
                this.handlePushEvent(content);
                break;
            }
            case "pull_request": {
                this.handlePullRequestEvent(content);
                break;
            }
        }
        return Response.ok().build();
    }

    private void handlePushEvent(String content) throws StorageException, BadRequestException {
        GiteaPushEvent pushEvent;
        try {
            pushEvent = (GiteaPushEvent)JsonUtils.deserializeFromJsonWithNullCheck((String)content, GiteaPushEvent.class);
        }
        catch (JsonSerializationException e) {
            throw new BadRequestException("Invalid payload: " + e.getMessage(), (Throwable)e);
        }
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)pushEvent.repository.fullName(), (IndexLayer)this.getIndexLayer(), null);
    }

    private void handlePullRequestEvent(String content) throws StorageException, BadRequestException {
        GiteaPullRequestEvent pullRequestEvent;
        try {
            pullRequestEvent = (GiteaPullRequestEvent)JsonUtils.deserializeFromJsonWithNullCheck((String)content, GiteaPullRequestEvent.class);
        }
        catch (JsonSerializationException e) {
            throw new BadRequestException("Invalid payload: " + e.getMessage(), (Throwable)e);
        }
        if (pullRequestEvent.changes != null && pullRequestEvent.changes.bodyDiff() != null) {
            return;
        }
        if (pullRequestEvent.action.equals("closed")) {
            this.deleteMergeRequestsFromIndex(new MergeRequestIdentifier(pullRequestEvent.repository.fullName(), pullRequestEvent.pullRequest.number()));
        } else {
            this.scheduleMergeRequestUpdateTriggers(pullRequestEvent.repository.fullName(), pullRequestEvent.pullRequest.number(), GiteaMergeRequestUpdateTrigger.class, null);
        }
    }

    private record GiteaPushEvent(@JsonProperty(value="repository") GiteaRepository repository) {
    }

    private record GiteaPullRequestEvent(@JsonProperty(value="action") String action, @JsonProperty(value="changes") @Nullable GiteaPullRequestChanges changes, @JsonProperty(value="pull_request") GiteaPullRequest pullRequest, @JsonProperty(value="repository") GiteaRepository repository) {
    }

    private record GiteaPullRequestChanges(@JsonProperty(value="body") @Nullable GiteaPullRequestChangesDiff bodyDiff) {
    }

    private record GiteaPullRequestChangesDiff(@JsonProperty(value="from") String from) {
    }
}

