/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.comparison;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.admin.instance_comparison.EInstanceComparisonStatus;
import com.teamscale.index.admin.instance_comparison.comparison.EInstanceComparisonSummary;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationOptions;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonResultBase;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.version.Version;

@IndexValueClass
public class InstanceComparisonComputationMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ID_PROPERTY = "id";
    private static final String OPTIONS_PROPERTY = "options";
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="status")
    private EInstanceComparisonStatus status = EInstanceComparisonStatus.IN_PROGRESS;
    @JsonProperty(value="options")
    private final InstanceComparisonComputationOptions options;
    @JsonProperty(value="remoteInstanceName")
    private String remoteInstanceName = "";
    @JsonProperty(value="processedProjects")
    private final Set<String> processedProjects = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    @JsonProperty(value="contributorsByProject")
    private final ConcurrentMap<String, Set<String>> contributorsByProject = new ConcurrentHashMap<String, Set<String>>();
    @JsonProperty(value="createdOn")
    private final long createdOn;
    @JsonProperty(value="error")
    private @Nullable String error = null;
    @JsonProperty(value="remoteInstanceTeamscaleVersion")
    private @Nullable Version remoteInstanceTeamscaleVersion;
    @JsonProperty(value="summary")
    private AtomicReference<EInstanceComparisonSummary> summary = new AtomicReference<EInstanceComparisonSummary>(EInstanceComparisonSummary.NO_DIFFERENCES);

    @JsonCreator
    public InstanceComparisonComputationMetadata(@JsonProperty(value="id") String id, @JsonProperty(value="options") InstanceComparisonComputationOptions options) {
        this.id = id;
        this.options = options;
        this.createdOn = System.currentTimeMillis();
    }

    public InstanceComparisonComputationOptions getOptions() {
        return this.options;
    }

    public EInstanceComparisonStatus getStatus() {
        return this.status;
    }

    public long getCreatedOn() {
        return this.createdOn;
    }

    public @Nullable String getError() {
        return this.error;
    }

    public String getId() {
        return this.id;
    }

    public String getRemoteInstanceName() {
        return this.remoteInstanceName;
    }

    public @Nullable Version getRemoteInstanceTeamscaleVersion() {
        return this.remoteInstanceTeamscaleVersion;
    }

    void setRemoteInstanceName(String remoteInstanceName) {
        this.remoteInstanceName = remoteInstanceName;
    }

    void setRemoteInstanceTeamscaleVersion(@Nullable Version remoteInstanceTeamscaleVersion) {
        this.remoteInstanceTeamscaleVersion = remoteInstanceTeamscaleVersion;
    }

    public UnmodifiableSet<String> getProcessedProjects() {
        return CollectionUtils.asUnmodifiable(this.processedProjects);
    }

    public EInstanceComparisonSummary getSummary() {
        return this.summary.get();
    }

    void addProcessedProjects(Set<String> projects) {
        this.processedProjects.addAll(projects);
    }

    public UnmodifiableMap<String, UnmodifiableSet<String>> getContributorsByProject() {
        return CollectionUtils.asUnmodifiable(this.contributorsByProject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CollectionUtils.asUnmodifiable((Set)((Set)e.getValue())))));
    }

    void registerResult(InstanceComparisonResultBase result) {
        this.contributorsByProject.computeIfAbsent(result.getProject(), ignored -> Collections.newSetFromMap(new ConcurrentHashMap())).add(result.getContributor());
        this.summary.getAndUpdate(s -> EInstanceComparisonSummary.max(s, result.getSummary()));
    }

    void setFailed(Throwable error) {
        LOGGER.error("Failure during comparison computation", error);
        this.error = error.getMessage();
        this.status = EInstanceComparisonStatus.FAILURE;
    }

    void setCompleted() {
        this.status = EInstanceComparisonStatus.SUCCESS;
    }
}

