/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.MethodLocation;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class DetailedInstanceComparisonValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ID_PROPERTY = "id";
    private static final String HUMAN_READABLE_PROPERTY = "humanReadable";
    private static final String TYPE_PROPERTY = "type";
    @JsonProperty(value="id")
    private final @NonNull String id;
    @JsonProperty(value="humanReadable")
    private final @NonNull String humanReadable;
    @JsonProperty(value="type")
    private final @NonNull EInstanceComparisonType type;

    @JsonCreator
    DetailedInstanceComparisonValue(@JsonProperty(value="id") @NonNull String id, @JsonProperty(value="humanReadable") @NonNull String humanReadable, @JsonProperty(value="type") @NonNull EInstanceComparisonType type) {
        CCSMAssert.isNotNull((Object)id, () -> "Expected \"id\" to be not null");
        CCSMAssert.isNotNull((Object)humanReadable, () -> "Expected \"humanReadable\" to be not null");
        CCSMAssert.isNotNull((Object)((Object)type), () -> "Expected \"type\" to be not null");
        this.id = id;
        this.humanReadable = humanReadable;
        this.type = type;
    }

    public static DetailedInstanceComparisonValue ofFinding(@NonNull String findingId, @NonNull String location, @Nullable EFindingBlacklistType blacklistType) {
        Object humanReadable = location;
        if (blacklistType != null) {
            humanReadable = (String)humanReadable + " (" + blacklistType.getReadableName() + ")";
        }
        return new DetailedInstanceComparisonValue(findingId, (String)humanReadable, EInstanceComparisonType.FINDING);
    }

    public static DetailedInstanceComparisonValue ofParserLogError(@NonNull ParserLogId logId) {
        return new DetailedInstanceComparisonValue(JsonUtils.serializeToJSON((Object)logId), logId.getUniformPath() + ":" + logId.getLineNumber() + "@" + String.valueOf(logId.getCommit()), EInstanceComparisonType.PARSE_LOG_ERROR);
    }

    public static DetailedInstanceComparisonValue ofWorkerLogError(@NonNull WorkerLogId logId) {
        return new DetailedInstanceComparisonValue(JsonUtils.serializeToJSON((Object)logId), logId.getTrigger() + ": " + String.valueOf(logId.getAnalyzedCommit()), EInstanceComparisonType.WORKER_LOG_ERROR);
    }

    public static DetailedInstanceComparisonValue ofMaintenanceLogError(@NonNull String triggerName, long logTimestamp) {
        WorkerLogId logId = new WorkerLogId(triggerName, null, logTimestamp);
        return new DetailedInstanceComparisonValue(JsonUtils.serializeToJSON((Object)logId), String.valueOf(logId.getTimestamp()), EInstanceComparisonType.MAINTENANCE_LOG_ERROR);
    }

    public static DetailedInstanceComparisonValue ofMethodExecution(@NonNull MethodLocation location, @NonNull String methodName, @NonNull CommitDescriptor commit, @NonNull ETestGapState executionState) {
        MethodReference methodReference = new MethodReference(location, commit);
        String humanReadable = executionState.getShortDescription() + ": " + location.getUniformPath() + "#" + methodName;
        return new DetailedInstanceComparisonValue(JsonUtils.serializeToJSON((Object)methodReference), humanReadable, EInstanceComparisonType.METHOD_COVERAGE);
    }

    public static DetailedInstanceComparisonValue ofUser(String userName) {
        return new DetailedInstanceComparisonValue(userName, userName, EInstanceComparisonType.USER);
    }

    public static DetailedInstanceComparisonValue ofGroup(String groupName) {
        return new DetailedInstanceComparisonValue(groupName, groupName, EInstanceComparisonType.GROUP);
    }

    public String getHumanReadable() {
        return this.humanReadable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetailedInstanceComparisonValue that = (DetailedInstanceComparisonValue)o;
        return this.id.equals(that.id) && this.humanReadable.equals(that.humanReadable) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.humanReadable, this.type});
    }

    public String toString() {
        return "DetailedInstanceComparisonValue{id='" + this.id + "', humanReadable='" + this.humanReadable + "', type=" + String.valueOf((Object)this.type) + "}";
    }

    @ExportToTypeScript
    @IndexValueClass
    public static enum EInstanceComparisonType {
        FINDING("finding"),
        PARSE_LOG_ERROR("parse log error"),
        WORKER_LOG_ERROR("worker log error"),
        MAINTENANCE_LOG_ERROR("maintenance log error"),
        METHOD_COVERAGE("method"),
        USER("user"),
        GROUP("group"),
        FINDING_LIST("finding list");

        private final String humanReadable;

        private EInstanceComparisonType(String humanReadable) {
            this.humanReadable = humanReadable;
        }

        public String getHumanReadable() {
            return this.humanReadable;
        }
    }

    public static class ParserLogId {
        private static final String UNIFORM_PATH_PROPERTY = "path";
        private static final String COMMIT_PROPERTY = "commit";
        private static final String LINE_NUMBER_PROPERTY = "lineNumber";
        @JsonProperty(value="path")
        private final @NonNull String uniformPath;
        @JsonProperty(value="lineNumber")
        private final int lineNumber;
        @JsonProperty(value="commit")
        private final @NonNull CommitDescriptor commit;

        @JsonCreator
        public ParserLogId(@JsonProperty(value="path") @NonNull String uniformPath, @JsonProperty(value="lineNumber") int lineNumber, @JsonProperty(value="commit") @NonNull CommitDescriptor commit) {
            CCSMAssert.isNotNull((Object)uniformPath, () -> String.format("Expected \"%s\" to be not null", UNIFORM_PATH_PROPERTY));
            CCSMAssert.isNotNull((Object)commit, () -> String.format("Expected \"%s\" to be not null", COMMIT_PROPERTY));
            this.uniformPath = uniformPath;
            this.lineNumber = lineNumber;
            this.commit = commit;
        }

        public @NonNull String getUniformPath() {
            return this.uniformPath;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public @NonNull CommitDescriptor getCommit() {
            return this.commit;
        }
    }

    public static class WorkerLogId {
        private static final String TRIGGER_PROPERTY = "trigger";
        private static final String ANALYZED_COMMIT_PROPERTY = "commit";
        private static final String TIMESTAMP_PROPERTY = "timestamp";
        @JsonProperty(value="trigger")
        private final @NonNull String trigger;
        @JsonProperty(value="commit")
        private final @Nullable CommitDescriptor analyzedCommit;
        @JsonProperty(value="timestamp")
        private final long timestamp;

        @JsonCreator
        public WorkerLogId(@JsonProperty(value="trigger") @NonNull String trigger, @JsonProperty(value="commit") @Nullable CommitDescriptor analyzedCommit, @JsonProperty(value="timestamp") long timestamp) {
            CCSMAssert.isNotNull((Object)trigger, () -> "Expected \"trigger\" to be not null");
            this.trigger = trigger;
            this.analyzedCommit = analyzedCommit;
            this.timestamp = timestamp;
        }

        public @NonNull String getTrigger() {
            return this.trigger;
        }

        public @Nullable CommitDescriptor getAnalyzedCommit() {
            return this.analyzedCommit;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class MethodReference {
        private static final String METHOD_LOCATION_PROPERTY = "methodLocation";
        private static final String COMMIT_PROPERTY = "commit";
        @JsonProperty(value="methodLocation")
        private final @NonNull MethodLocation methodLocation;
        @JsonProperty(value="commit")
        private final @NonNull CommitDescriptor commit;

        @JsonCreator
        public MethodReference(@JsonProperty(value="methodLocation") @NonNull MethodLocation methodLocation, @JsonProperty(value="commit") @NonNull CommitDescriptor commit) {
            CCSMAssert.isNotNull((Object)methodLocation, () -> String.format("Expected \"%s\" to be not null", METHOD_LOCATION_PROPERTY));
            CCSMAssert.isNotNull((Object)commit, () -> String.format("Expected \"%s\" to be not null", COMMIT_PROPERTY));
            this.methodLocation = methodLocation;
            this.commit = commit;
        }

        public @NonNull MethodLocation getMethodLocation() {
            return this.methodLocation;
        }

        public @NonNull CommitDescriptor getCommit() {
            return this.commit;
        }
    }
}

