/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.CounterSetInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.KeyValueInstanceComparisonValueBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.NumberInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga.TestGapAnalysisComparisonDetailContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga.TgaTrend;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga.TgaTrendInstanceComparisonValue;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class TestGapAnalysisComparisonContribution
extends ProjectComparisonContributionBase {
    private static final long serialVersionUID = 1L;
    static final List<ETestGapState> EXPECTED_TEST_GAP_COUNT_STATES = ETgaAssessmentType.TEST_GAP.getTestGapStates();
    private static final String TEST_GAP_COUNT_PROPERTY = "testGapCount";
    private static final String TOTAL_METHOD_EXECUTION_PROPERTY = "totalMethodExecution";
    private static final String DETAIL_PROPERTY = "detail";
    private static final String TEST_GAP_TREND_PROPERTY = "testGapTrend";
    public static final String TGA_KEY = "30 days TGA";
    public static final String TGA_TREND_KEY = "Biggest deviation in 30 day TGA trend";
    public static final String EXECUTED_METHODS_KEY = "Executed methods";
    @JsonProperty(value="testGapCount")
    private final CounterSet<ETestGapState> testGapCount;
    @JsonProperty(value="totalMethodExecution")
    private final double totalMethodExecutionPercentage;
    @JsonProperty(value="testGapTrend")
    private final TgaTrend testGapTrend;
    @JsonProperty(value="detail")
    private final @Nullable TestGapAnalysisComparisonDetailContribution detailContribution;

    @JsonCreator
    TestGapAnalysisComparisonContribution(@JsonProperty(value="contributor") String contributor, @JsonProperty(value="project") String project, @JsonProperty(value="testGapCount") CounterSet<ETestGapState> testGapCount, @JsonProperty(value="totalMethodExecution") double totalMethodExecutionPercentage, @JsonProperty(value="testGapTrend") TgaTrend testGapTrend, @JsonProperty(value="detail") @Nullable TestGapAnalysisComparisonDetailContribution detailContribution) {
        super(contributor, project);
        this.testGapCount = testGapCount;
        this.totalMethodExecutionPercentage = totalMethodExecutionPercentage;
        this.testGapTrend = testGapTrend;
        this.detailContribution = detailContribution;
    }

    @Override
    public Map<String, ? extends IInstanceComparisonValue> getValues(InstanceComparisonContributionBase.ComparisonContext context) {
        return Map.ofEntries(this.getTestGapCountEntry(), this.getMethodExecutionPercentageEntry(), this.getTestGapTrendEntry());
    }

    private Map.Entry<String, IInstanceComparisonValue> getTestGapCountEntry() {
        return Map.entry(TGA_KEY, new CounterSetInstanceComparisonValue<ETestGapState>(TGA_KEY, this.testGapCount, (IDetailedInstanceComparisonContribution)this.detailContribution, KeyValueInstanceComparisonValueBase.noImprovement(), TestGapAnalysisComparisonContribution::getTestGapStateDescription));
    }

    private Map.Entry<String, IInstanceComparisonValue> getMethodExecutionPercentageEntry() {
        return Map.entry(EXECUTED_METHODS_KEY, new NumberInstanceComparisonValue(EXECUTED_METHODS_KEY, this.totalMethodExecutionPercentage, this.detailContribution, KeyValueInstanceComparisonValueBase.noImprovement(), null, n -> String.format(Locale.ENGLISH, "%.1f%%", n.doubleValue())));
    }

    private Map.Entry<String, TgaTrendInstanceComparisonValue> getTestGapTrendEntry() {
        return Map.entry(TGA_TREND_KEY, new TgaTrendInstanceComparisonValue(TGA_TREND_KEY, this.testGapTrend));
    }

    static String getTestGapStateDescription(ETestGapState testGapState) {
        return testGapState.getShortDescription().toLowerCase(Locale.ENGLISH);
    }

    public static Builder builder(boolean detailed, CommitDescriptor endCommit) {
        return new Builder(detailed, endCommit);
    }

    private static void assertOnlyExpectedStates(AssessedTgaData tgaData, Collection<ETestGapState> expectedStates) {
        EnumSet actualStates = tgaData.getMethods().stream().map(AssessedTgaData.AssessedMethodData::getTestGapState).collect(Collectors.toCollection(() -> EnumSet.noneOf(ETestGapState.class)));
        TestGapAnalysisComparisonContribution.assertOnlyExpectedStates(actualStates, expectedStates);
    }

    static void assertOnlyExpectedStates(Collection<ETestGapState> actualStates, Collection<ETestGapState> expectedStates) {
        CCSMAssert.isTrue((boolean)expectedStates.containsAll(actualStates), () -> String.format("Expected tga states to only contain %s, but was: %s", expectedStates, actualStates));
    }

    public static class Builder {
        private final CounterSet<ETestGapState> testGapCount = CounterSet.forEnum(ETestGapState.class);
        private final CounterSet<ETestGapState> methodExecutionCount = CounterSet.forEnum(ETestGapState.class);
        private TgaTrend tgaTrend;
        private final TestGapAnalysisComparisonDetailContribution detailContribution;

        private Builder(boolean detailed, CommitDescriptor endCommit) {
            if (detailed) {
                CCSMAssert.isNotNull((Object)endCommit, () -> String.format("Expected \"%s\" to be not null", "endCommit"));
                this.detailContribution = new TestGapAnalysisComparisonDetailContribution(endCommit);
            } else {
                this.detailContribution = null;
            }
        }

        public Builder addTgaAssessment(@NonNull AssessedTgaData tgaData) {
            CCSMAssert.isNotNull((Object)tgaData, () -> String.format("Expected \"%s\" to be not null", "tgaData"));
            TestGapAnalysisComparisonContribution.assertOnlyExpectedStates(tgaData, EXPECTED_TEST_GAP_COUNT_STATES);
            this.testGapCount.add(TgaAggregationUtils.countStates(tgaData));
            if (this.detailContribution != null) {
                this.detailContribution.addTgaAssessment(tgaData);
            }
            return this;
        }

        public Builder addExecutionAssessment(@NonNull AssessedTgaData executionData) {
            CCSMAssert.isNotNull((Object)executionData, () -> String.format("Expected \"%s\" to be not null", "executionData"));
            TestGapAnalysisComparisonContribution.assertOnlyExpectedStates(executionData, List.of(ETestGapState.EXECUTED, ETestGapState.NOT_EXECUTED));
            this.methodExecutionCount.add(TgaAggregationUtils.countStates(executionData));
            if (this.detailContribution != null) {
                this.detailContribution.addExecutionAssessment(executionData);
            }
            return this;
        }

        public Builder setTgaTrend(@NonNull TgaTrend tgaTrend) {
            CCSMAssert.isNotNull((Object)tgaTrend, () -> String.format("Expected \"%s\" to be not null", "tgaTrend"));
            this.tgaTrend = tgaTrend;
            return this;
        }

        public TestGapAnalysisComparisonContribution build(@NonNull String contributor, @NonNull String project) {
            CounterSet testGapCountCopy = CounterSet.forEnum(ETestGapState.class);
            testGapCountCopy.add(this.testGapCount);
            return new TestGapAnalysisComparisonContribution(contributor, project, (CounterSet<ETestGapState>)testGapCountCopy, Builder.computeMethodExecutionPercentage(this.methodExecutionCount), this.tgaTrend, this.detailContribution);
        }

        private static double computeMethodExecutionPercentage(CounterSet<ETestGapState> methodExecutionCount) {
            double methodExecutionRatio = TgaAggregationUtils.calculateRatio(ETgaAssessmentType.EXECUTION_ONLY, methodExecutionCount);
            return (float)Math.round(methodExecutionRatio * 1000.0) / 10.0f;
        }
    }
}

