/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.assessment;

import com.teamscale.index.architecture.scope.ComponentNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.lib.commons.assertion.CCSMAssert;

class QuickCheckPattern {
    private static final int STEP_SIZE = 7;
    private final String pattern;
    private final ComponentNode component;
    private static final Set<Character> REGEX_CHARS_EXCEPT_OR_SIGN = new HashSet<Character>(Arrays.asList(Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('?'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('^'), Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')')));
    private final Set<String> extractedPlainTypes = new HashSet<String>();

    QuickCheckPattern(String includePattern, ComponentNode component) {
        this.pattern = includePattern;
        this.component = component;
        this.extractedPlainTypes.addAll(QuickCheckPattern.extractTypesIfSimplePattern(includePattern));
    }

    public static Set<String> extractTypesIfSimplePattern(String includePattern) {
        char[] chars = includePattern.toCharArray();
        StringBuilder currentPath = new StringBuilder();
        HashSet<String> extractedPlainTypes = new HashSet<String>();
        for (int i = 0; i < chars.length; ++i) {
            boolean isEscaped;
            boolean bl = isEscaped = i > 0 && chars[i - 1] == '\\';
            if (REGEX_CHARS_EXCEPT_OR_SIGN.contains(Character.valueOf(chars[i])) && !isEscaped) {
                return new HashSet<String>();
            }
            if (isEscaped) {
                currentPath.replace(currentPath.length() - 1, currentPath.length(), "");
            }
            if (chars[i] == '|') {
                extractedPlainTypes.add(currentPath.toString());
                currentPath.setLength(0);
                continue;
            }
            currentPath.append(chars[i]);
        }
        if (!currentPath.isEmpty()) {
            extractedPlainTypes.add(currentPath.toString());
        }
        return extractedPlainTypes;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ComponentNode getComponent() {
        return this.component;
    }

    public Long calculateHash() {
        String prefix = QuickCheckPattern.determineRequiredPrefix(this.pattern);
        int length = prefix.length();
        length -= length % 7;
        prefix = prefix.substring(0, length);
        return QuickCheckPattern.getPrefixHashCode(prefix);
    }

    public static List<Long> determinePrefixHashes(String path) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (int len = 0; len <= path.length(); len += 7) {
            String prefix = path.substring(0, len);
            result.add(QuickCheckPattern.getPrefixHashCode(prefix));
        }
        return result;
    }

    private static long getPrefixHashCode(String prefix) {
        if (prefix.isEmpty()) {
            return 0L;
        }
        return ((long)prefix.hashCode() << 8) + (long)prefix.length();
    }

    private static String determineRequiredPrefix(String regex) {
        if (regex.contains("|")) {
            return "";
        }
        int start = 0;
        if (regex.startsWith("^")) {
            start = 1;
        }
        for (int end = start; end < regex.length(); ++end) {
            switch (regex.charAt(end)) {
                case '*': 
                case '+': 
                case '?': 
                case '{': {
                    return regex.substring(start, Math.max(start, end - 1));
                }
                case '(': 
                case '.': 
                case '[': 
                case '\\': {
                    return regex.substring(start, end);
                }
            }
        }
        return regex.substring(start);
    }

    boolean hasPrecalculatedTypes() {
        return !this.extractedPlainTypes.isEmpty();
    }

    private boolean matchesPrecalculatedTypes(String type) {
        return this.extractedPlainTypes.contains(type);
    }

    public boolean matchesType(String type, Map<String, Pattern> cachedCompiledPatterns) {
        if (this.hasPrecalculatedTypes()) {
            return this.matchesPrecalculatedTypes(type);
        }
        return Objects.requireNonNull(QuickCheckPattern.compileAndCachePattern(this.pattern, cachedCompiledPatterns)).matcher(type).matches();
    }

    public static Pattern compileAndCachePattern(String pattern, Map<String, Pattern> compiledPatternCache) {
        try {
            return compiledPatternCache.computeIfAbsent(pattern, Pattern::compile);
        }
        catch (PatternSyntaxException e) {
            return (Pattern)CCSMAssert.fail((String)("Invalid regular expression '" + pattern + "': " + e.getMessage()));
        }
    }
}

