/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.architecture.assessment.TypeToComponentMapper;
import com.teamscale.index.architecture.incremental.ArchitectureAnalysisUtils;
import com.teamscale.index.architecture.incremental.ArchitectureMappingIndex;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class ArchitectureComponentMappingUpdater {
    private final ArchitectureMappingIndex mappingIndex;
    private final List<String> deletedTypes = new ArrayList<String>();
    private final List<String> deletedFiles = new ArrayList<String>();
    private final List<String> addedTypes = new ArrayList<String>();
    private final List<String> addedFiles = new ArrayList<String>();
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final TokenElementIndex contentIndex;
    private final Set<String> affectedTypes = new HashSet<String>();
    private final Set<String> affectedFiles = new HashSet<String>();
    private final TypeDependencyIndex typeDependencyIndex;
    private final TypeDependencyIndex previousTypeDependencyIndex;
    private final Set<String> knownTypes = new HashSet<String>();

    public ArchitectureComponentMappingUpdater(TokenElementIndex contentIndex, ArchitectureMappingIndex mappingIndex, KeyDelta typeDelta, KeyDelta typeDependencyDelta, TypeIndex typeIndex, TypeDependencyIndex previousTypeIndex, TypeDependencyIndex typeDependencyIndex, IParallelTaskExecutor parallelTaskExecutor) throws StorageException {
        this.contentIndex = contentIndex;
        this.mappingIndex = mappingIndex;
        this.typeDependencyIndex = typeDependencyIndex;
        List addedOrChangedTypes = typeDelta.getAddedOrChangedKeysAsStrings();
        HashSet<String> tmpAffectedTypes = new HashSet<String>(ArchitectureComponentMappingUpdater.filterKeys(addedOrChangedTypes, "file:"));
        tmpAffectedTypes.addAll(typeDependencyDelta.getAddedOrChangedKeysAsStrings());
        this.addedFiles.addAll(tmpAffectedTypes);
        this.deletedFiles.addAll(ArchitectureComponentMappingUpdater.filterKeys(typeDelta.getDeletedKeysAsStrings(), "file:"));
        this.addedTypes.addAll(ArchitectureComponentMappingUpdater.filterKeys(addedOrChangedTypes, "type:"));
        this.deletedTypes.addAll(ArchitectureComponentMappingUpdater.filterKeys(typeDelta.getDeletedKeysAsStrings(), "type:"));
        this.parallelTaskExecutor = parallelTaskExecutor;
        this.affectedFiles.addAll(this.addedFiles);
        this.affectedFiles.addAll(typeDependencyDelta.getAddedOrChangedKeysAsStrings());
        this.affectedFiles.addAll(this.deletedFiles);
        this.affectedTypes.addAll(this.addedTypes);
        this.affectedTypes.addAll(this.deletedTypes);
        this.affectedTypes.addAll(typeIndex.getTypeNamesForFiles(typeDependencyDelta.getAddedOrChangedKeysAsStrings()).stream().flatMap(Collection::stream).toList());
        this.knownTypes.addAll(typeIndex.getAllTypeNames());
        this.previousTypeDependencyIndex = previousTypeIndex;
    }

    @Nullable TypeComponentMapping updateComponentMapping(String architecturePath) throws ConQATException {
        TokenElementInfo tokenElement = this.contentIndex.getTokenElement(Objects.requireNonNull(architecturePath));
        ArchitectureDefinition architectureDefinition = ArchitectureAnalysisUtils.getArchitectureDefinition(List.of(tokenElement));
        if (ArchitectureComponentMappingUpdater.isUnaffected(architectureDefinition, this.affectedFiles, this.affectedTypes)) {
            return null;
        }
        TypeComponentMapping metaInfo = this.mappingIndex.getMapping(architecturePath);
        if (metaInfo == null) {
            return null;
        }
        List<String> deletedKeys = architectureDefinition.isFileBased() ? this.deletedFiles : this.deletedTypes;
        List<String> addedKeys = architectureDefinition.isFileBased() ? this.addedFiles : this.addedTypes;
        TypeToComponentMapper typeToComponentMapper = new TypeToComponentMapper(architectureDefinition, this.parallelTaskExecutor);
        this.removeDeletedKeys(metaInfo, typeToComponentMapper, deletedKeys);
        this.updateThirdPartyDependencies(architecturePath, metaInfo, typeToComponentMapper);
        ArchitectureComponentMappingUpdater.mapAddedKeys(architecturePath, typeToComponentMapper, addedKeys, metaInfo);
        return metaInfo;
    }

    private void updateThirdPartyDependencies(String architecturePath, TypeComponentMapping metaInfo, TypeToComponentMapper typeToComponentMapper) throws StorageException {
        PairList<String, List<String>> currentDependencies = this.currentThirdPartyDependencies(this.addedFiles);
        PairList<String, List<String>> previousDependencies = this.previousThirdPartyDependencies(this.addedFiles);
        HashSet<String> addedThirdPartyDependencies = new HashSet<String>();
        for (int i = 0; i < currentDependencies.size(); ++i) {
            List current3rdPartyDependencies = (List)currentDependencies.getSecond(i);
            List previous3rdPartyDependencies = (List)previousDependencies.getSecond(i);
            HashSet newThirdPartyDependencies = CollectionUtils.differenceSet((Collection)current3rdPartyDependencies, (Collection[])new Collection[]{previous3rdPartyDependencies});
            HashSet deletedThirdPartyDependencies = CollectionUtils.differenceSet((Collection)previous3rdPartyDependencies, (Collection[])new Collection[]{current3rdPartyDependencies});
            ArchitectureComponentMappingUpdater.removeThirdPartyDependencies(metaInfo, deletedThirdPartyDependencies, typeToComponentMapper);
            metaInfo.addThirdPartyDependency(newThirdPartyDependencies);
            addedThirdPartyDependencies.addAll(newThirdPartyDependencies);
        }
        typeToComponentMapper.map(addedThirdPartyDependencies);
        SetMap<String, ComponentNode> typesToComponents = typeToComponentMapper.getTypesToComponents();
        metaInfo.addTypes(typesToComponents, (List<String>)typeToComponentMapper.getUnmatchedTypes(), typeToComponentMapper.getNumberOfMatches(), architecturePath);
    }

    private static void mapAddedKeys(String architecturePath, TypeToComponentMapper typeToComponentMapper, List<String> addedKeys, TypeComponentMapping metaInfo) {
        typeToComponentMapper.map(addedKeys);
        SetMap<String, ComponentNode> typesToComponents = typeToComponentMapper.getTypesToComponents();
        metaInfo.addTypes(typesToComponents, (List<String>)typeToComponentMapper.getUnmatchedTypes(), typeToComponentMapper.getNumberOfMatches(), architecturePath);
    }

    private void removeDeletedKeys(TypeComponentMapping metaInfo, TypeToComponentMapper typeToComponentMapper, List<String> deletedKeys) throws StorageException {
        UnmodifiableList thirdPartyDependenciesOfDeletedFiles = this.previousThirdPartyDependencies(this.deletedFiles).getSecondList();
        List<String> list = thirdPartyDependenciesOfDeletedFiles.stream().flatMap(Collection::stream).toList();
        ArchitectureComponentMappingUpdater.removeThirdPartyDependencies(metaInfo, list, typeToComponentMapper);
        typeToComponentMapper.map(deletedKeys);
        ListMap<String, Integer> numberOfMatches = typeToComponentMapper.getNumberOfMatches();
        metaInfo.removeType(deletedKeys, numberOfMatches);
    }

    private static void removeThirdPartyDependencies(TypeComponentMapping metaInfo, Collection<String> thirdPartyTypes, TypeToComponentMapper typeToComponentMapper) {
        List<String> removableTypes = metaInfo.removeThirdPartyDependency(thirdPartyTypes);
        typeToComponentMapper.map(removableTypes);
        ListMap<String, Integer> numberOfMatches = typeToComponentMapper.getNumberOfMatches();
        metaInfo.removeType(removableTypes, numberOfMatches);
    }

    private static boolean isUnaffected(ArchitectureDefinition architectureDefinition, Set<String> affectedFiles, Set<String> affectedTypes) {
        if (architectureDefinition.isFileBased()) {
            return affectedFiles.stream().noneMatch(architectureDefinition::isIncludedInScope);
        }
        return affectedTypes.stream().noneMatch(architectureDefinition::isIncludedInScope);
    }

    private static List<String> filterKeys(List<String> keys, String prefix) {
        return new ArrayList<String>(keys.stream().filter(t -> t.startsWith(prefix)).map(key -> StringUtils.stripPrefix((String)key, (String)prefix)).toList());
    }

    private PairList<String, List<String>> currentThirdPartyDependencies(List<String> types) throws StorageException {
        return this.getThirdPartyDependencies(this.typeDependencyIndex, types);
    }

    private PairList<String, List<String>> previousThirdPartyDependencies(List<String> types) throws StorageException {
        return this.getThirdPartyDependencies(this.previousTypeDependencyIndex, types);
    }

    private PairList<String, List<String>> getThirdPartyDependencies(TypeDependencyIndex typeDependencyIndex, List<String> types) throws StorageException {
        PairList<String, ArrayList<TypeDependencies>> typeDependencies = typeDependencyIndex.getTypeDependenciesPerUniformPath(types);
        PairList current3rdPartyDependencies = new PairList();
        for (Pair dependencies : typeDependencies) {
            List<String> list = ((ArrayList)dependencies.getSecond()).stream().map(TypeDependencies::getDependencies).flatMap(Collection::stream).filter(t -> !this.knownTypes.contains(t)).toList();
            current3rdPartyDependencies.add((Object)((String)dependencies.getFirst()), list);
        }
        return current3rdPartyDependencies;
    }
}

