/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Index(name="architecture-mapping", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED})
public class ArchitectureMappingIndex
extends IndexBase
implements IProjectIndex {
    private final ValueIndex<TypeComponentMapping> delegate;
    public static final String INDEX_NAME = "architecture-mapping";

    public ArchitectureMappingIndex(IStore store) {
        super(store);
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public List<String> getAllArchitectures() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public @Nullable TypeComponentMapping getMapping(String architectureName) throws StorageException {
        return (TypeComponentMapping)this.delegate.getValue(architectureName);
    }

    public void removeArchitectures(Collection<String> architecturePaths) throws StorageException {
        this.delegate.removeValues(architecturePaths);
    }

    public void setArchitecturesAndChanges(PairList<String, TypeComponentMapping> architectures) throws StorageException {
        this.delegate.setValues(architectures);
    }
}

