/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.read;

import com.teamscale.core.EStartableComponent;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.index.backup.BackupTargetFactory;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.IBackupTarget;
import com.teamscale.index.backup.StatusReportingTriggerBase;
import com.teamscale.index.backup.TemporaryFileIndex;
import com.teamscale.index.backup.read.BackupImportStatus;
import com.teamscale.index.backup.read.BackupImportStatusIndex;
import com.teamscale.index.backup.read.BackupReader;
import com.teamscale.index.backup.read.BackupReadingParameters;
import com.teamscale.index.external.DelayedExternalUploadIntegrationTrigger;
import com.teamscale.index.external.ExternalAnalysisCommitInfo;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.tools.ExternalUploadIndexModifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.ZipFile;

public class BackupImportTrigger
extends StatusReportingTriggerBase<BackupImportStatus, BackupImportStatusIndex> {
    private static final Logger LOGGER = LogManager.getLogger();
    private ExternalCredentialsIndex externalCredentialsIndex;
    private TemporaryFileIndex fileIndex;

    public BackupImportTrigger() {
        super(BackupImportStatusIndex.class);
    }

    @Override
    protected void performAction() throws StorageException {
        try {
            this.externalCredentialsIndex = (ExternalCredentialsIndex)this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
            this.fileIndex = (TemporaryFileIndex)this.indexLayer.openGlobalIndex(TemporaryFileIndex.class);
            this.performImport();
        }
        finally {
            if (((BackupImportStatus)this.status).getBackupImportOptions().isDeleteAfterImport()) {
                this.deleteInputFiles();
            }
        }
    }

    private void performImport() {
        BackupReadingParameters parameters = new BackupReadingParameters(((BackupImportStatus)this.status).getBackupImportOptions(), this.indexLayer, (File)this.getTemporaryDirectory(), this.lockProvider, this.instanceConfiguration);
        ((BackupImportStatus)this.status).setStatusMessage("Running backup import...");
        for (String importUri : ((BackupImportStatus)this.status).getBackupImportOptions().getImportUris()) {
            try {
                this.verifyNotCanceled();
                IBackupTarget target = BackupTargetFactory.getReadTarget(importUri, this.externalCredentialsIndex, this.fileIndex, ((BackupImportStatus)this.status).getBackupImportOptions().getInstanceCredentials(), LOGGER);
                try (ZipFile backupFile = new ZipFile(target.getReadChannel(), "unknown");){
                    Set<InternalProjectId> updatedProjects = BackupReader.importBackupData(backupFile, parameters, (BackupImportStatus)this.status, (ICancelable)this, this.getParallelTaskExecutor());
                    this.scheduleUnprocessedSessions(updatedProjects);
                }
            }
            catch (ExecutionCanceledException e) {
                ((BackupImportStatus)this.status).setStatusAndMessage(EBackupStatus.FAILURE, e.getMessage());
            }
            catch (Throwable t) {
                this.handleFatalImportError(importUri, t);
            }
        }
        ((BackupImportStatus)this.status).finish();
    }

    private void scheduleUnprocessedSessions(Set<InternalProjectId> updatedProjects) throws StorageException {
        boolean unprocessedSessions = false;
        for (InternalProjectId project : updatedProjects) {
            unprocessedSessions |= this.findUnprocessedSessionsForProject(project);
        }
        if (unprocessedSessions) {
            ISchedulerCommunicator.getInstance().scheduleMaintenanceTrigger(DelayedExternalUploadIntegrationTrigger.class, "Schedule all unprocessed sessions from the backup", this.indexLayer);
        }
    }

    private boolean findUnprocessedSessionsForProject(InternalProjectId project) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)project);
        ExternalAnalysisImportSessionIndex sessionIndex = (ExternalAnalysisImportSessionIndex)projectStorageSystem.openProjectIndex(ExternalAnalysisImportSessionIndex.class, null);
        IStore externalAnalysisRawStore = projectStorageSystem.openStoreChecked("external-analysis-results", ExternalAnalysisResultIndex.class, (IStorageSystem)projectStorageSystem, true, null);
        Set<String> processedIds = BackupImportTrigger.getProcessedSessionIds((SchemaAwareStorageSystem)projectStorageSystem);
        PairList<String, ExternalAnalysisSessionInfo> sessionInfos = sessionIndex.getAllSessionInfos();
        List<String> unscheduled = this.determineUnscheduledSessions(project, sessionIndex, externalAnalysisRawStore, processedIds, sessionInfos);
        sessionIndex.setUnscheduledSessionIds(unscheduled);
        return !unscheduled.isEmpty();
    }

    private @NonNull List<String> determineUnscheduledSessions(InternalProjectId project, ExternalAnalysisImportSessionIndex sessionIndex, IStore externalAnalysisRawStore, Set<String> processedIds, PairList<String, ExternalAnalysisSessionInfo> sessionInfos) throws StorageException {
        CommitLayeringBranchingLayer externalAnalysisBranchingLayer = new CommitLayeringBranchingLayer(externalAnalysisRawStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
        ArrayList<String> unscheduled = new ArrayList<String>();
        for (Pair entry : sessionInfos) {
            CommitDescriptor latestCommitOnBranch;
            String sessionId = (String)entry.getFirst();
            ExternalAnalysisSessionInfo sessionInfo = (ExternalAnalysisSessionInfo)entry.getSecond();
            if (sessionInfo == null || sessionInfo.isOpen()) continue;
            if (processedIds.contains(sessionId)) {
                sessionIndex.deleteSession(sessionId);
                continue;
            }
            try {
                String branchName = sessionInfo.getCommit().getBranchName();
                latestCommitOnBranch = ExternalUploadIndexModifier.getLastCommitOnBranch((IBranchingLayer)externalAnalysisBranchingLayer, branchName);
            }
            catch (StorageException e) {
                LOGGER.error("Error obtaining latest commit on branch for session " + String.valueOf(sessionInfo) + " in project " + String.valueOf(this.indexLayer.resolveToPrimaryPublicProjectId((IProjectId)project)), (Throwable)e);
                continue;
            }
            if (latestCommitOnBranch != null && latestCommitOnBranch.getTimestamp() >= sessionInfo.getCommit().getTimestamp()) {
                LOGGER.warn("Skipping import of session " + sessionId + "(" + String.valueOf(sessionInfo.getCommit()) + ") because it is older than the newest already existing upload: " + String.valueOf(latestCommitOnBranch));
                sessionIndex.deleteSession(sessionId);
                continue;
            }
            unscheduled.add(sessionId);
        }
        return unscheduled;
    }

    private static Set<String> getProcessedSessionIds(SchemaAwareStorageSystem projectStorageSystem) throws StorageException {
        List<ExternalAnalysisCommitInfo> commitInfos = ExternalAnalysisResultIndex.loadCommitInfos(projectStorageSystem.openBranchingLayer(ExternalAnalysisResultIndex.class));
        return commitInfos.stream().map(ExternalAnalysisCommitInfo::getSessionId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private void deleteInputFiles() {
        for (String importUri : ((BackupImportStatus)this.status).getBackupImportOptions().getImportUris()) {
            try {
                BackupTargetFactory.getReadTarget(importUri, this.externalCredentialsIndex, this.fileIndex, LOGGER).deleteBackupFile();
            }
            catch (IOException | ConQATException e) {
                LOGGER.error("Failed to delete " + importUri, e);
            }
        }
    }

    private void handleFatalImportError(String importUrl, Throwable t) {
        String message = "Failed to import from URL " + importUrl + ": " + t.toString();
        ((BackupImportStatus)this.status).error(message);
        LOGGER.error(message, t);
        ((BackupImportStatus)this.status).setStatus(EBackupStatus.FAILURE);
        for (BackupImportStatus.ImportProgress progress : ((BackupImportStatus)this.status).getProjectProgress()) {
            if (progress.getStatus() != EBackupStatus.IN_PROGRESS) continue;
            progress.setStatusMessage("Aborted due to fatal error");
            progress.setStatus(EBackupStatus.FAILURE);
        }
        if (importUrl.startsWith("file:") && EStartableComponent.isCloudMode()) {
            ((BackupImportStatus)this.status).error("Seems like this instance uses cloud deployment. In this case, either a shared directory between the nodes must be present or remote URLs (e.g. S3) must be used. Check the user guide for details.");
        }
    }
}

