/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.code_change.ChangeRegion;
import com.teamscale.index.code_change.ChangeRegions;
import com.teamscale.index.code_change.CodeChangeIndex;
import com.teamscale.index.code_change.IndexContainer;
import com.teamscale.index.code_change.MatchRegion;
import com.teamscale.index.code_change.MatchRegionCloneStore;
import com.teamscale.index.code_change.MatchedRegionWrapper;
import com.teamscale.index.code_change.MethodInfoForRegionCreator;
import com.teamscale.index.code_change.MethodMatchRegion;
import com.teamscale.index.code_change.MethodRegionMatching;
import com.teamscale.index.code_change.RegionMatcher;
import com.teamscale.index.code_change.refactoring_detection.RefactoringDetector;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testgap.MethodInfo;
import com.teamscale.index.testgap.MethodInfoContainer;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLocation;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.region.SimpleRegion;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CodeChangeIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    public static final int BATCH_SIZE = 500;
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY, indexName="content")
    private List<TokenElementIndex> oldContentIndexes;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex newContentIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<CodeChangeIndex> oldCodeChangeIndexes;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CodeChangeIndex newCodeChangeIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<MethodInfoIndex> oldMethodInfoIndexes;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private MethodInfoIndex newMethodInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ElementHistoryIndex historyIndex;
    private final MatchRegionCloneStore matchRegionCloneStore = new MatchRegionCloneStore();
    private final Map<CommitDescriptor, MethodRegionMatching> unmatchedRegionsByBranchAndParentBranch = new HashMap<CommitDescriptor, MethodRegionMatching>();
    private final SetMap<String, MatchRegion> allNewRegionsByPath = new SetMap();
    private Set<String> pathsOfMatchedNewRegions = new HashSet<String>();
    private int parentCommitCount;

    public final void execute() throws StorageException {
        this.ensureIndexListsAreNotEmpty();
        UnmodifiableCollection<IndexContainer> parentCommitContainers = this.buildParentCommitInfos();
        for (KeyDelta deltaBatch : this.contentDelta.split(500)) {
            this.loadCodeRegions(parentCommitContainers, deltaBatch);
        }
        this.matchRegionsAndPersistResults(parentCommitContainers, this.contentDelta);
    }

    private void ensureIndexListsAreNotEmpty() {
        if (this.oldCodeChangeIndexes.isEmpty()) {
            this.oldCodeChangeIndexes.add(new CodeChangeIndex((IStore)new InMemoryStore()));
        }
        if (this.oldContentIndexes.isEmpty()) {
            this.oldContentIndexes.add(new TokenElementIndex((IStore)new InMemoryStore()));
        }
        if (this.oldMethodInfoIndexes.isEmpty()) {
            this.oldMethodInfoIndexes.add(new MethodInfoIndex((IStore)new InMemoryStore()));
        }
    }

    private void loadCodeRegions(UnmodifiableCollection<IndexContainer> indexContainers, KeyDelta currentContentDeltaBatch) throws StorageException {
        List changedFiles = currentContentDeltaBatch.getAddedOrChangedKeysAsStrings();
        List<TokenElementInfo> changedElementContents = this.getChangedElementContents(changedFiles);
        List<ElementHistoryEntry> changedHistoryEntries = this.getChangedHistoryContents(changedFiles);
        for (IndexContainer indexContainer : indexContainers) {
            MethodRegionMatching methodMatching = this.getMethodMatching(indexContainer.getCommit());
            this.loadRegionsIntoMethodMatching(changedElementContents, changedHistoryEntries, methodMatching, indexContainer, currentContentDeltaBatch);
        }
    }

    private UnmodifiableCollection<IndexContainer> buildParentCommitInfos() {
        ParentedCommitDescriptor parentedCommitDescriptor;
        CommitDescriptor commitDescriptor = this.getSchedulingCommit();
        if (!(commitDescriptor instanceof ParentedCommitDescriptor) || (parentedCommitDescriptor = (ParentedCommitDescriptor)commitDescriptor).getParentCommits().isEmpty()) {
            this.parentCommitCount = 1;
            return this.createArtificialParentCommit();
        }
        UnmodifiableList parentCommits = parentedCommitDescriptor.getParentCommits();
        this.parentCommitCount = parentCommits.size();
        return CollectionUtils.asUnmodifiable(IntStream.range(0, parentCommits.size()).mapToObj(i -> new IndexContainer((CommitDescriptor)parentCommits.get(i), this.oldContentIndexes.get(i), this.oldCodeChangeIndexes.get(i), this.oldMethodInfoIndexes.get(i))).collect(Collectors.toList()));
    }

    private UnmodifiableCollection<IndexContainer> createArtificialParentCommit() {
        return CollectionUtils.asUnmodifiable(Collections.singleton(new IndexContainer(this.getSchedulingCommit(), this.oldContentIndexes.getFirst(), this.oldCodeChangeIndexes.getFirst(), this.oldMethodInfoIndexes.getFirst())));
    }

    private MethodRegionMatching getMethodMatching(CommitDescriptor parentCommit) {
        return this.unmatchedRegionsByBranchAndParentBranch.computeIfAbsent(parentCommit, MethodRegionMatching::new);
    }

    private void matchRegionsAndPersistResults(UnmodifiableCollection<IndexContainer> parentCommitContainers, KeyDelta contentDelta) throws StorageException {
        PairList<IndexContainer, MethodRegionMatching> parentsWithMethodMatchings = this.matchOldCodeRegionsToNewOnes(parentCommitContainers);
        ListMap<MatchRegion, MatchedRegionWrapper> methodsWithAllMatches = this.matchNewRegionsToAllParents(parentsWithMethodMatchings, contentDelta);
        this.persistResults(methodsWithAllMatches, contentDelta);
        this.removeDeletedKeys(contentDelta);
    }

    private void removeDeletedKeys(KeyDelta contentDelta) throws StorageException {
        List deletedKeysAsStrings = contentDelta.getDeletedKeysAsStrings();
        if (!deletedKeysAsStrings.isEmpty()) {
            this.newCodeChangeIndex.removeChangeRegions(deletedKeysAsStrings);
            this.newMethodInfoIndex.removeValues(deletedKeysAsStrings);
        }
    }

    private ListMap<MatchRegion, MatchedRegionWrapper> matchNewRegionsToAllParents(PairList<IndexContainer, MethodRegionMatching> indexesWithMethodMatchings, KeyDelta currentContentDelta) throws StorageException {
        ListMap methodsWithAllMatches = new ListMap();
        this.pathsOfMatchedNewRegions = new HashSet<String>(currentContentDelta.getAddedOrChangedKeysAsStrings());
        ListMap matchedRegionsByIndex = new ListMap();
        for (Pair indexContainerWithMatching : indexesWithMethodMatchings) {
            MethodRegionMatching regionMatching = (MethodRegionMatching)indexContainerWithMatching.getSecond();
            List<MatchRegion> parentAwareNewRegions = regionMatching.newRegions;
            for (MatchRegion newRegion : parentAwareNewRegions) {
                IndexContainer indexesOfParent = (IndexContainer)indexContainerWithMatching.getFirst();
                MatchRegion matchedOldRegion = newRegion.getMatch();
                this.addNewRegionBranchAware(newRegion);
                boolean semanticallyEquivalent = matchedOldRegion != null && newRegion.getLastChangeTimestamp() == matchedOldRegion.getLastChangeTimestamp();
                MatchedRegionWrapper match = new MatchedRegionWrapper(matchedOldRegion, semanticallyEquivalent, regionMatching.parentCommit);
                methodsWithAllMatches.add((Object)newRegion, (Object)match);
                if (matchedOldRegion == null) continue;
                this.pathsOfMatchedNewRegions.add(newRegion.getUniformPath());
                matchedRegionsByIndex.add((Object)indexesOfParent, (Object)match);
            }
        }
        CodeChangeIndexSynchronizer.setMethodInfosOnOldRegions((ListMap<IndexContainer, MatchedRegionWrapper>)matchedRegionsByIndex);
        return methodsWithAllMatches;
    }

    private void addNewRegionBranchAware(MatchRegion newRegion) {
        String uniformPath = newRegion.getUniformPath();
        Set regionsInFile = (Set)this.allNewRegionsByPath.getCollectionOrEmpty((Object)uniformPath);
        if (regionsInFile.contains((Object)newRegion)) {
            regionsInFile.removeIf(region -> region.equals((Object)newRegion) && region.getLastChangeTimestamp() < newRegion.getLastChangeTimestamp());
        }
        this.allNewRegionsByPath.add((Object)uniformPath, (Object)newRegion);
    }

    private static void setMethodInfosOnOldRegions(ListMap<IndexContainer, MatchedRegionWrapper> matchedRegionsByIndex) throws StorageException {
        for (IndexContainer index : matchedRegionsByIndex.getKeys()) {
            PairList oldRegionsByUniformPath = new PairList();
            List matchedRegions = (List)matchedRegionsByIndex.getCollectionOrEmpty((Object)index);
            for (MatchedRegionWrapper entry : matchedRegions) {
                oldRegionsByUniformPath.add((Object)entry.getOldRegion().getUniformPath(), (Object)entry.getOldRegion());
            }
            Map<MethodLocation, MethodInfo> oldMethodInfos = index.getMethodInfoIndex().getMethodInfoMapForExactPaths((PairList<String, OffsetBasedRegion>)oldRegionsByUniformPath);
            for (MatchedRegionWrapper matchedRegion : matchedRegions) {
                MethodLocation methodLocation = new MethodLocation(matchedRegion.getOldRegion().getUniformPath(), (OffsetBasedRegion)matchedRegion.getOldRegion());
                matchedRegion.setMethodInfo(oldMethodInfos.get(methodLocation));
            }
        }
    }

    private PairList<IndexContainer, MethodRegionMatching> matchOldCodeRegionsToNewOnes(UnmodifiableCollection<IndexContainer> indexesOfParentCommits) throws StorageException {
        PairList parentsWithMethodMatchings = new PairList();
        for (IndexContainer indexContainer : indexesOfParentCommits) {
            MethodRegionMatching methodMatching = this.getMethodMatching(indexContainer.getCommit());
            this.matchRegions(methodMatching, indexContainer);
            this.detectRefactorings(methodMatching);
            parentsWithMethodMatchings.add((Object)indexContainer, (Object)methodMatching);
        }
        return parentsWithMethodMatchings;
    }

    private List<ElementHistoryEntry> getChangedHistoryContents(List<String> changedFiles) throws StorageException {
        if (changedFiles.isEmpty()) {
            return new ArrayList<ElementHistoryEntry>();
        }
        return this.historyIndex.getHistoryEntries(changedFiles, true);
    }

    private List<TokenElementInfo> getChangedElementContents(List<String> changedFiles) throws StorageException {
        if (changedFiles.isEmpty()) {
            return new ArrayList<TokenElementInfo>();
        }
        return this.newContentIndex.getTokenElements(changedFiles, true);
    }

    private void insertOldRegions(MethodRegionMatching methodMatching, TokenElementIndex contentIndex, CodeChangeIndex codeChangeIndex, List<String> paths) throws StorageException {
        List<TokenElementInfo> elements = contentIndex.getTokenElements(paths);
        List<ChangeRegions> changeRegions = codeChangeIndex.getChangeRegions(paths);
        for (int i = 0; i < elements.size(); ++i) {
            if (elements.get(i) == null) continue;
            methodMatching.oldRegions.addAll(this.loadRegionsForFile(elements.get(i), changeRegions.get(i), null));
        }
    }

    private void loadRegionsIntoMethodMatching(List<TokenElementInfo> changedElementContents, List<ElementHistoryEntry> changedHistoryEntries, MethodRegionMatching methodMatching, IndexContainer oldIndexContainer, KeyDelta currentContentDeltaBatch) throws StorageException {
        this.insertNewRegions(changedElementContents, changedHistoryEntries, methodMatching);
        List changedAndDeletedPaths = currentContentDeltaBatch.getAllKeysAsStrings();
        if (changedAndDeletedPaths.isEmpty()) {
            return;
        }
        this.insertOldRegions(methodMatching, oldIndexContainer.getContentIndex(), oldIndexContainer.getCodeChangeIndex(), changedAndDeletedPaths);
    }

    private void insertNewRegions(List<TokenElementInfo> changedElementContents, List<ElementHistoryEntry> changedHistoryEntries, MethodRegionMatching methodRegionMatching) {
        for (int i = 0; i < changedElementContents.size(); ++i) {
            TokenElementInfo changedElement = changedElementContents.get(i);
            try {
                methodRegionMatching.newRegions.addAll(this.loadRegionsForFile(changedElement, null, changedHistoryEntries.get(i).getOriginPath()));
                continue;
            }
            catch (RuntimeException e) {
                LOGGER.error("Severe unexpected error while generating tracking changes for file {}. Skipping change tracking for this file.", (Object)changedElement.getUniformPath(), (Object)e);
            }
        }
    }

    private List<MatchRegion> loadRegionsForFile(TokenElementInfo element, @Nullable ChangeRegions changeRegions, @Nullable String originPath) {
        if (element.isFilteredCompletely()) {
            return Collections.emptyList();
        }
        long timestamp = this.getSchedulingCommit().getTimestamp();
        if (!ShallowParserFactory.supportsLanguage((ELanguage)element.getLanguage())) {
            return Collections.singletonList(CodeChangeIndexSynchronizer.fixTimestamp(new MatchRegion(timestamp, element, originPath), changeRegions));
        }
        ArrayList<MatchRegion> targetList = new ArrayList<MatchRegion>();
        Map<String, List<IToken>> aliases = CodeChangeIndexSynchronizer.extractAliases(element);
        CounterSet idCounters = new CounterSet();
        for (ShallowEntityWithAstPath methodEntity : CodeChangeIndexSynchronizer.determineMethodEntitiesThatAreNotFiltered(element)) {
            MethodMatchRegion matchRegion = new MethodMatchRegion(timestamp, element, methodEntity, originPath, (CounterSet<String>)idCounters, aliases);
            targetList.add(CodeChangeIndexSynchronizer.fixTimestamp(matchRegion, changeRegions));
        }
        return targetList;
    }

    private static List<ShallowEntityWithAstPath> determineMethodEntitiesThatAreNotFiltered(TokenElementInfo element) {
        StringOffsetTransformer entityOffsetToRawCodeAdjuster;
        UnmodifiableList filterDeletions;
        Object rootEntities;
        if (PreprocessorUtils.hasPreprocessor((ELanguage)element.getLanguage())) {
            rootEntities = element.getShallowEntitiesWithRevertedPreprocessorTokens();
            filterDeletions = Collections.emptyList();
            entityOffsetToRawCodeAdjuster = new StringOffsetTransformer((List)element.getFilterDeletions());
        } else {
            rootEntities = element.getRawShallowEntities();
            filterDeletions = element.getFilterDeletions();
            entityOffsetToRawCodeAdjuster = new StringOffsetTransformer(Collections.emptyList());
        }
        if (rootEntities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ShallowEntityWithAstPath> methodEntities = new ArrayList<ShallowEntityWithAstPath>();
        ShallowEntityTraversalUtils.traverseWithKey((List)rootEntities, (arg_0, arg_1) -> CodeChangeIndexSynchronizer.lambda$determineMethodEntitiesThatAreNotFiltered$2((List)filterDeletions, entityOffsetToRawCodeAdjuster, methodEntities, arg_0, arg_1));
        return methodEntities;
    }

    private static Map<String, List<IToken>> extractAliases(TokenElementInfo element) {
        if (!element.getLanguage().isCppOrC()) {
            return Collections.emptyMap();
        }
        List<IToken> tokens = element.getPreprocessedTokens();
        if (tokens.isEmpty()) {
            return Collections.emptyMap();
        }
        return LanguageFeatureParser.CPP.getAliasMapping(tokens);
    }

    private static boolean isMethodAndNotFiltered(ShallowEntity entity, List<Deletion> filterDeletions) {
        return entity.getType() == EShallowEntityType.METHOD && !Deletion.isFilteredOffset((int)entity.getStartOffset(), filterDeletions);
    }

    private static MatchRegion fixTimestamp(MatchRegion matchRegion, ChangeRegions changeRegions) {
        if (changeRegions != null) {
            try {
                ChangeRegion existingRegion = changeRegions.findRegion((SimpleRegion)matchRegion);
                matchRegion.setLastChangeTimestamp(existingRegion.getLastChangeTimestamp());
            }
            catch (AssertionError e) {
                LOGGER.error("Failed to update timestamp for match region. This should only occur if the parser implementation changes significantly in a patch release. As a consequence, the findings tracking may show existing findings incorrectly as 'findings in changed code' for this commit. The issue should be resolved automatically in subsequent commits or upon full reanalysis.", (Throwable)((Object)e));
            }
        }
        return matchRegion;
    }

    private void matchRegions(MethodRegionMatching methodMatching, IndexContainer indexContainer) throws StorageException {
        new RegionMatcher(methodMatching).performMatching(this.matchRegionCloneStore, this.getSchedulingCommit().getBranchName(), indexContainer.getCommit().getBranchName());
    }

    private void detectRefactorings(MethodRegionMatching methodMatching) {
        RefactoringDetector refactoringDetector = new RefactoringDetector(this.getSchedulingCommit().getTimestamp());
        refactoringDetector.detectRenamingsAndLoadChangedRegions(methodMatching.newRegions);
        refactoringDetector.markIfRefactoredAndSetLastChangeTimestamp(methodMatching.newRegions);
    }

    private void persistResults(ListMap<MatchRegion, MatchedRegionWrapper> methodsWithAllMatches, KeyDelta currentContentDelta) throws StorageException {
        HashMap<String, MethodInfoContainer> methodsInfosAlreadyCollected = new HashMap<String, MethodInfoContainer>();
        for (MatchRegion newRegion : methodsWithAllMatches.getKeys()) {
            List matchedRegions = (List)methodsWithAllMatches.getCollectionOrEmpty((Object)newRegion);
            this.assertNumberOfMethodPredecessors(newRegion, matchedRegions);
            MethodInfoContainer newContainerForSingleMethod = this.createMethodInfo(newRegion, matchedRegions);
            if (newContainerForSingleMethod == null) continue;
            methodsInfosAlreadyCollected.merge(newRegion.getUniformPath(), newContainerForSingleMethod, MethodInfoContainer::merge);
        }
        this.persistMethodContainers(methodsInfosAlreadyCollected, currentContentDelta);
        PairList<String, ChangeRegions> newChangeValues = this.determineNewChangeValues();
        if (!newChangeValues.isEmpty()) {
            this.newCodeChangeIndex.setChangeRegions(newChangeValues);
        }
    }

    private void assertNumberOfMethodPredecessors(MatchRegion newRegion, List<MatchedRegionWrapper> matchedRegions) {
        CCSMAssert.isTrue((matchedRegions.size() == this.parentCommitCount ? 1 : 0) != 0, (String)("Expected equal number of parent branches and (dummy) predecessors for region " + String.valueOf((Object)newRegion)));
    }

    private void persistMethodContainers(Map<String, MethodInfoContainer> methodsInfosAlreadyCollected, KeyDelta currentContentDelta) throws StorageException {
        PairList allMethodInfoContainers = new PairList();
        for (Map.Entry<String, MethodInfoContainer> pathAndContainer : methodsInfosAlreadyCollected.entrySet()) {
            allMethodInfoContainers.add((Object)pathAndContainer.getKey(), (Object)pathAndContainer.getValue());
        }
        this.newMethodInfoIndex.setMethodContainers((PairList<String, MethodInfoContainer>)allMethodInfoContainers);
        this.removeDeletedMethodInfosExcept(methodsInfosAlreadyCollected.keySet(), currentContentDelta);
    }

    private MethodInfoContainer createMethodInfo(MatchRegion newRegion, List<MatchedRegionWrapper> matchedRegions) {
        if (!ELanguage.languageHasMethods((ELanguage)newRegion.getLanguage()) || CodeChangeIndexSynchronizer.isAbstractMethodDeclaration(newRegion)) {
            return null;
        }
        MethodInfo newMethodInfo = new MethodInfoForRegionCreator(this.getSchedulingCommit()).createMethodInfoForParents(newRegion, matchedRegions);
        return new MethodInfoContainer(newRegion, newMethodInfo);
    }

    private void removeDeletedMethodInfosExcept(Collection<String> keysToKeep, KeyDelta currentContentDelta) throws StorageException {
        HashSet keysToDelete = CollectionUtils.differenceSet((Collection)currentContentDelta.getAddedOrChangedKeysAsStrings(), (Collection[])new Collection[]{keysToKeep});
        this.newMethodInfoIndex.removeValues(new ArrayList<String>(keysToDelete));
    }

    private static boolean isAbstractMethodDeclaration(MatchRegion region) {
        MethodMatchRegion methodRegion;
        return region instanceof MethodMatchRegion && (methodRegion = (MethodMatchRegion)region).getContent().getEntity().getSubtype().equals("abstract");
    }

    private PairList<String, ChangeRegions> determineNewChangeValues() throws StorageException {
        PairList newChangeValues = new PairList();
        ArrayList<String> pathsList = new ArrayList<String>(this.pathsOfMatchedNewRegions);
        List<ChangeRegions> existingChangeRegionsList = this.newCodeChangeIndex.getChangeRegions(pathsList);
        for (int i = 0; i < pathsList.size(); ++i) {
            Set newRegions = (Set)this.allNewRegionsByPath.getCollection((Object)((String)pathsList.get(i)));
            ChangeRegions changeRegions = this.createOrUpdateChangeRegions(existingChangeRegionsList.get(i), newRegions);
            newChangeValues.add((Object)((String)pathsList.get(i)), (Object)changeRegions);
        }
        return newChangeValues;
    }

    private ChangeRegions createOrUpdateChangeRegions(ChangeRegions oldChangeRegions, Set<MatchRegion> newRegions) {
        if (newRegions == null) {
            newRegions = new HashSet<MatchRegion>();
        }
        if (oldChangeRegions == null || oldChangeRegions.getCreationTimestamp() < this.getSchedulingCommit().getTimestamp()) {
            ChangeRegions result = new ChangeRegions(this.getSchedulingCommit().getTimestamp());
            for (MatchRegion region : newRegions) {
                result.getRegions().add(new ChangeRegion(region.getStart(), region.getEnd(), region.getLastChangeTimestamp()));
            }
            result.sortRegions();
            return result;
        }
        for (MatchRegion region : newRegions) {
            oldChangeRegions.replaceRegion(new ChangeRegion(region.getStart(), region.getEnd(), region.getLastChangeTimestamp()));
        }
        return oldChangeRegions;
    }

    private static /* synthetic */ boolean lambda$determineMethodEntitiesThatAreNotFiltered$2(List filterDeletions, StringOffsetTransformer entityOffsetToRawCodeAdjuster, List methodEntities, int[] pathToEntity, ShallowEntity entity) {
        if (entity.getType() == EShallowEntityType.STATEMENT) {
            return false;
        }
        if (CodeChangeIndexSynchronizer.isMethodAndNotFiltered(entity, filterDeletions) && !entity.getSubtype().endsWith("declaration")) {
            int rawStartOffset = entityOffsetToRawCodeAdjuster.getUnfilteredOffset(entity.getStartOffset());
            int rawEndOffset = entityOffsetToRawCodeAdjuster.getUnfilteredOffset(entity.getEndOffset());
            methodEntities.add(new ShallowEntityWithAstPath(entity, pathToEntity, rawStartOffset, rawEndOffset));
            return false;
        }
        return true;
    }

    record ShallowEntityWithAstPath(ShallowEntity entity, int[] astPath, int rawStartOffset, int rawEndOffset) {
    }
}

