/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.core.xpath.DocumentRootShallowEntity;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.scanner.LanguageProperties;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.EntitySelectionExpressionParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public abstract class CommentCompletenessAnalyzerBase {
    private static final Pattern DOCTAG_PATTERN = Pattern.compile("([@\\\\](author|version|param|throws)|@ConQAT.Rating).*\\n");
    private static final Pattern JAVA_LIKE_PROPERTY = Pattern.compile("@property\\s+(\\w+)\\s");
    public static final Set<ELanguage> SUPPORTED_LANGUAGES = EnumSet.of(ELanguage.ABAP, new ELanguage[]{ELanguage.C, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.CS, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.KOTLIN, ELanguage.MATLAB, ELanguage.PYTHON, ELanguage.SWIFT, ELanguage.VB});
    public static final Pattern XMLTAG_PATTERN = Pattern.compile("<.*?>");
    private static final Pattern CS_SEE_TAG = Pattern.compile("<see.*cref=\\\"(.*)\\\"\\s*/>");
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final Pattern CS_INHERITDOC_XMLTAG_PATTERN = Pattern.compile("<inheritdoc.*/>", 2);
    private static final Pattern JAVA_INHERITDOC_PATTERN = Pattern.compile("\\{@inheritDoc\\s*\\}", 2);
    private final boolean requireDocComment;
    private final String entitySelectionExpression;
    private final boolean allowCommentInside;
    private Predicate<ShallowEntity> entitySelector;
    private ELanguage language;
    private static final Set<String> ANNOTATION_SUBTYPES = Set.of("attribute annotation", "annotation", "decorator");

    protected CommentCompletenessAnalyzerBase(boolean requireDocComment, String entitySelectionExpression, boolean allowCommentInside) {
        this.requireDocComment = requireDocComment;
        this.entitySelectionExpression = entitySelectionExpression;
        this.allowCommentInside = allowCommentInside;
    }

    public void performAnalysis(Collection<TokenElementInfo> elements) throws ConQATException {
        try {
            this.entitySelector = EntitySelectionExpressionParser.parse((String)this.entitySelectionExpression);
        }
        catch (ShallowParserException e) {
            throw new ConQATException((Throwable)e);
        }
        for (TokenElementInfo element : elements) {
            this.analyzeTokens((List<IToken>)element.getTokens(), element);
        }
    }

    protected void analyzeTokens(List<IToken> tokens, TokenElementInfo element) throws StorageException {
        if (!SUPPORTED_LANGUAGES.contains(element.getLanguage())) {
            return;
        }
        this.language = element.getLanguage();
        UnmodifiableList<ShallowEntity> entities = element.getShallowEntitiesWithoutPreprocessorTokens();
        DocumentRootShallowEntity.wrapWithRootIfNecessary(entities, (String)UniformPathUtils.getElementName((String)element.getUniformPath()));
        List filteredEntities = ShallowEntityTraversalUtils.selectEntities(entities, this.entitySelector);
        for (ShallowEntity entity : filteredEntities) {
            if (CommentCompletenessAnalyzerBase.isEntityToBeIgnored(tokens, entity)) continue;
            ShallowEntity entityToComment = entity;
            ShallowEntity parent = entity.getParent();
            if (parent != null && "typedef".equals(parent.getSubtype())) {
                entityToComment = parent;
            }
            ECommentInspectionResult commentAssessment = this.getCommentType(entityToComment, (List<ShallowEntity>)entities, tokens);
            this.analyzeSelectedEntity(entityToComment, element, commentAssessment);
        }
    }

    private static boolean isEntityToBeIgnored(List<IToken> tokens, ShallowEntity entity) {
        ELanguage language = TokenStreamUtils.getLanguage(tokens);
        if (CommentCompletenessAnalyzerBase.isIgnoredCppEntity(language, entity)) {
            return true;
        }
        if (language == ELanguage.PYTHON && entity.getSubtype().equals("lambda")) {
            return true;
        }
        ShallowEntity parent = entity.getParent();
        if (parent == null) {
            return false;
        }
        if (CommentCompletenessAnalyzerBase.isIgnoredJavascriptEntity(language, entity, parent)) {
            return true;
        }
        if (CommentCompletenessAnalyzerBase.isIgnoredKotlinEntity(language, entity, parent)) {
            return true;
        }
        if (entity.getSubtype().equals("static initializer")) {
            return true;
        }
        return CommentCompletenessAnalyzerBase.isClassEntityDefinedInMethod(entity);
    }

    private static boolean isIgnoredKotlinEntity(ELanguage language, ShallowEntity entity, ShallowEntity parent) {
        if (language != ELanguage.KOTLIN) {
            return false;
        }
        boolean isType = EShallowEntityType.TYPE == entity.getType();
        boolean isObject = "object".equals(entity.getSubtype());
        boolean isCompanionObject = TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.COMPANION);
        if (isType && isObject && isCompanionObject) {
            return true;
        }
        boolean isAttribute = EShallowEntityType.ATTRIBUTE == entity.getType();
        boolean parentIsType = EShallowEntityType.TYPE == parent.getType();
        boolean parentIsPrivate = parent.ownStartTokens().stream().map(IToken::getType).anyMatch(arg_0 -> ETokenType.PRIVATE.equals(arg_0));
        boolean parentIsObject = "object".equals(parent.getSubtype());
        return isAttribute && parentIsType && parentIsPrivate && parentIsObject;
    }

    private static boolean isIgnoredCppEntity(ELanguage language, ShallowEntity entity) {
        if (LanguageGroups.C_CPP_AND_MS_CLI.contains(language)) {
            if (entity.getType() == EShallowEntityType.META) {
                return true;
            }
            return LanguageFeatureParser.CPP.isCpp11DeletedFunctionOrConstructor(entity);
        }
        return false;
    }

    private static boolean isIgnoredJavascriptEntity(ELanguage language, ShallowEntity entity, ShallowEntity parent) {
        if (language == ELanguage.JAVASCRIPT) {
            return CommentCompletenessAnalyzerBase.hasEmptyName(entity) || CommentCompletenessAnalyzerBase.isInnerFunctionDeclaration(entity, parent) || CommentCompletenessAnalyzerBase.isAttributeFunction(entity);
        }
        return parent.getType() == EShallowEntityType.STATEMENT || parent.getType() == EShallowEntityType.ATTRIBUTE;
    }

    private static boolean hasEmptyName(ShallowEntity entity) {
        return StringUtils.isEmpty((String)entity.getName());
    }

    private static boolean isAttributeFunction(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.METHOD && entity.getSubtype().equals("attribute function");
    }

    private static boolean isInnerFunctionDeclaration(ShallowEntity entity, ShallowEntity parent) {
        if (parent == null) {
            return false;
        }
        if (parent.getType() == EShallowEntityType.METHOD && entity.getType() == EShallowEntityType.METHOD) {
            return true;
        }
        return CommentCompletenessAnalyzerBase.isInnerFunctionDeclaration(entity, parent.getParent());
    }

    private static boolean isClassEntityDefinedInMethod(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.TYPE && entity.getSubtype().equals("class") && ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, parentEntity -> parentEntity.getType() == EShallowEntityType.METHOD).isPresent();
    }

    protected abstract void analyzeSelectedEntity(ShallowEntity var1, TokenElementInfo var2, ECommentInspectionResult var3) throws StorageException;

    private ECommentInspectionResult getCommentType(ShallowEntity entity, List<ShallowEntity> entities, List<IToken> tokens) {
        int searchEndOffset;
        int searchStartOffset;
        ECommentInspectionResult searchCommentResult;
        if (tokens.isEmpty()) {
            return ECommentInspectionResult.UNCOMMENTED;
        }
        UnmodifiableList siblings = entities;
        if (entity.getParent() != null) {
            siblings = entity.getParent().getChildren();
        }
        if ((searchCommentResult = this.searchComment(tokens, searchStartOffset = this.determineSearchStartOffset(entity, (List<ShallowEntity>)siblings), searchEndOffset = entity.getStartOffset())) == ECommentInspectionResult.COMMENTED) {
            return ECommentInspectionResult.COMMENTED;
        }
        ELanguage language = TokenStreamUtils.getLanguage(tokens);
        if (LanguageGroups.C_CPP_AND_MS_CLI.contains(language) && CommentCompletenessAnalyzerBase.isAttributeSucceededByCppDoxygenComment(entity, tokens)) {
            return ECommentInspectionResult.COMMENTED;
        }
        if (language == ELanguage.KOTLIN && this.isAttributeCommentedInKDocs(entity, tokens)) {
            return ECommentInspectionResult.COMMENTED;
        }
        if (language == ELanguage.ABAP && this.isAbapKettensatz(entity, tokens)) {
            return ECommentInspectionResult.COMMENTED;
        }
        if (this.isCommentInsideAllowed(tokens)) {
            return this.isCommentedInside(entity, tokens);
        }
        return searchCommentResult;
    }

    private boolean isAbapKettensatz(ShallowEntity entity, List<IToken> tokens) {
        int startIndex = CommentCompletenessAnalyzerBase.firstTokenIndex(tokens, entity.getStartOffset());
        if (tokens.size() > startIndex + 2 && tokens.get(startIndex + 1).getType() == ETokenType.COLON) {
            return this.isNonEmptyInterfaceComment(tokens.get(startIndex + 2)) == ECommentInspectionResult.COMMENTED;
        }
        return false;
    }

    private boolean isCommentInsideAllowed(List<IToken> tokens) {
        return this.allowCommentInside || TokenStreamUtils.getLanguage(tokens) == ELanguage.PYTHON;
    }

    private ECommentInspectionResult isCommentedInside(ShallowEntity entity, List<IToken> tokens) {
        int searchStartOffset = entity.getStartOffset() + 1;
        int searchEndOffset = entity.getChildren().isEmpty() ? entity.getEndOffset() : ((ShallowEntity)entity.getChildren().get(0)).getStartOffset();
        return this.searchComment(tokens, searchStartOffset, searchEndOffset);
    }

    private static boolean isAttributeSucceededByCppDoxygenComment(ShallowEntity entity, List<IToken> tokens) {
        if (entity.getType() != EShallowEntityType.ATTRIBUTE) {
            return false;
        }
        ShallowEntity nextSibling = ShallowEntityTraversalUtils.getSubsequentEntity((ShallowEntity)entity);
        if (nextSibling != null) {
            return CommentCompletenessAnalyzerBase.isCppDoxygenStyleComment(tokens.get(CommentCompletenessAnalyzerBase.firstTokenIndex(tokens, entity.getEndOffset() + 1)));
        }
        return false;
    }

    private ECommentInspectionResult searchComment(List<IToken> tokens, int searchStartOffset, int searchEndOffset) {
        int tokenIndex = CommentCompletenessAnalyzerBase.firstTokenIndex(tokens, searchStartOffset);
        boolean sawEmptyComment = false;
        while (tokenIndex < tokens.size() && tokens.get(tokenIndex).getOffset() < searchEndOffset) {
            IToken token = tokens.get(tokenIndex);
            if (token.getOffset() == 0 && token.getType() != ETokenType.DOCUMENTATION_COMMENT) {
                ++tokenIndex;
                continue;
            }
            ECommentInspectionResult commentEmptyCheck = this.isNonEmptyInterfaceComment(token);
            if (commentEmptyCheck == ECommentInspectionResult.COMMENTED && (this.isCommentInsideAllowed(tokens) || CommentCompletenessAnalyzerBase.isFirstTokenInLine(token, tokens, tokenIndex))) {
                return ECommentInspectionResult.COMMENTED;
            }
            if (commentEmptyCheck == ECommentInspectionResult.EMPTY && !sawEmptyComment) {
                sawEmptyComment = true;
            }
            ++tokenIndex;
        }
        if (tokenIndex < tokens.size() && tokens.get(tokenIndex).getOffset() == searchEndOffset && CommentCompletenessAnalyzerBase.isPythonSingleOrDoubleQuotedComment(tokens, tokenIndex)) {
            return ECommentInspectionResult.COMMENTED;
        }
        if (sawEmptyComment) {
            return ECommentInspectionResult.EMPTY;
        }
        return ECommentInspectionResult.UNCOMMENTED;
    }

    private static String getKotlinCommentContent(List<IToken> tokens, int searchStartOffset, int searchEndOffset) {
        for (int tokenIndex = CommentCompletenessAnalyzerBase.firstTokenIndex(tokens, searchStartOffset); tokenIndex < tokens.size() && tokens.get(tokenIndex).getOffset() < searchEndOffset; ++tokenIndex) {
            IToken token = tokens.get(tokenIndex);
            if (token.getType() != ETokenType.DOCUMENTATION_COMMENT) continue;
            return token.getText();
        }
        return "";
    }

    private static boolean isFirstTokenInLine(IToken token, List<IToken> tokens, int tokenIndex) {
        if (tokenIndex == 0) {
            return true;
        }
        return token.getLineNumber() > tokens.get(tokenIndex - 1).getLineNumber();
    }

    private static boolean isCppDoxygenStyleComment(IToken token) {
        if (!LanguageGroups.C_CPP_AND_MS_CLI.contains(token.getLanguage())) {
            return false;
        }
        String commentText = token.getText();
        return token.getType() == ETokenType.DOCUMENTATION_COMMENT && (commentText.startsWith("/*!<") || commentText.startsWith("/**<") || commentText.startsWith("//!<") || commentText.startsWith("///<"));
    }

    private boolean isAttributeCommentedInKDocs(ShallowEntity entity, List<IToken> tokens) {
        if (entity.getType() != EShallowEntityType.ATTRIBUTE) {
            return false;
        }
        ShallowEntity parent = entity.getParent();
        if (parent == null || parent.getType() != EShallowEntityType.TYPE) {
            return false;
        }
        int searchStartOffset = 0;
        if (parent.getParent() != null) {
            UnmodifiableList siblings = parent.getParent().getChildren();
            searchStartOffset = this.determineSearchStartOffset(parent, (List<ShallowEntity>)siblings);
        }
        int searchEndOffset = parent.getStartOffset();
        String comment = CommentCompletenessAnalyzerBase.getKotlinCommentContent(tokens, searchStartOffset, searchEndOffset);
        return CommentCompletenessAnalyzerBase.isJavaLikePropertyDocumented(comment, entity.getName());
    }

    private static boolean isJavaLikePropertyDocumented(String javaLikeDoc, String propertyName) {
        Matcher matcher = JAVA_LIKE_PROPERTY.matcher(javaLikeDoc);
        while (matcher.find()) {
            if (!matcher.group(1).equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPythonSingleOrDoubleQuotedComment(List<IToken> tokens, int tokenIndex) {
        if (TokenStreamUtils.getLanguage(tokens) != ELanguage.PYTHON) {
            return false;
        }
        IToken currentToken = tokens.get(tokenIndex);
        String currentTokenText = currentToken.getText();
        boolean isSingleQuoted = currentTokenText.startsWith(SINGLE_QUOTE) && currentTokenText.endsWith(SINGLE_QUOTE);
        boolean isDoubleQuoted = currentTokenText.startsWith(DOUBLE_QUOTE) && currentTokenText.endsWith(DOUBLE_QUOTE);
        return currentToken.getType() == ETokenType.STRING_LITERAL && (isSingleQuoted || isDoubleQuoted);
    }

    private ECommentInspectionResult isNonEmptyInterfaceComment(IToken token) {
        if (token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT) {
            return ECommentInspectionResult.UNCOMMENTED;
        }
        if (CommentCompletenessAnalyzerBase.isEmptyComment(token.getText(), token.getLanguage())) {
            return ECommentInspectionResult.EMPTY;
        }
        if (!(token.getType() != ETokenType.DOCUMENTATION_COMMENT && this.requireDocComment || CommentCompletenessAnalyzerBase.isCppDoxygenStyleComment(token))) {
            return ECommentInspectionResult.COMMENTED;
        }
        return ECommentInspectionResult.UNCOMMENTED;
    }

    private static int firstTokenIndex(List<IToken> tokens, int offset) {
        CCSMAssert.isFalse((boolean)tokens.isEmpty(), (String)"Tokens may not be empty!");
        IToken referenceToken = tokens.get(0);
        IToken searchToken = referenceToken.newToken(referenceToken.getType(), offset, 0, "", "");
        int tokenIndex = Collections.binarySearch(tokens, searchToken, Comparator.comparingInt(IToken::getOffset));
        if (tokenIndex < 0) {
            tokenIndex = -tokenIndex - 1;
        }
        return tokenIndex;
    }

    private int determineSearchStartOffset(ShallowEntity entity, List<ShallowEntity> siblings) {
        IToken token;
        int index;
        for (index = siblings.indexOf(entity) - 1; index >= 0 && (CommentCompletenessAnalyzerBase.isAnnotation(siblings.get(index)) || this.isTypeScriptOverloadedMethod(entity, siblings.get(index)) || this.isCppTemplate(siblings.get(index))); --index) {
        }
        if (index >= 0) {
            return siblings.get(index).getEndOffset();
        }
        if (entity.getParent() != null && !"document-root".equals(entity.getParent().getSubtype()) && (token = (IToken)CollectionUtils.getLast((List)entity.getParent().ownStartTokens())) != null) {
            return token.getEndOffset();
        }
        return 0;
    }

    private static boolean isAnnotation(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && ANNOTATION_SUBTYPES.contains(entity.getSubtype());
    }

    private boolean isTypeScriptOverloadedMethod(ShallowEntity entity, ShallowEntity sibling) {
        return this.language == ELanguage.JAVASCRIPT && sibling.getType() == EShallowEntityType.METHOD && !CommentCompletenessAnalyzerBase.hasEmptyName(entity) && entity.getName() != null && entity.getName().equals(sibling.getName());
    }

    private boolean isCppTemplate(ShallowEntity entity) {
        return this.language.isCppOrObjectiveCpp() && Objects.equals(entity.getSubtype(), "template");
    }

    private static boolean isEmptyComment(String commentText, ELanguage language) {
        commentText = StringUtils.normalizeLineSeparatorsPlatformIndependent((String)LanguageProperties.of((ELanguage)language).getCommentContent(commentText));
        commentText = DOCTAG_PATTERN.matcher(commentText).replaceAll("");
        if (language == ELanguage.CS) {
            if (CommentCompletenessAnalyzerBase.isInheritdocFoundInCSComment(commentText)) {
                return false;
            }
            commentText = CommentCompletenessAnalyzerBase.removeEmptyCsCommentTags(commentText);
        }
        commentText = StringUtils.removeWhitespace((String)commentText);
        return commentText.isEmpty();
    }

    private static String removeEmptyCsCommentTags(String commentText) {
        commentText = CommentCompletenessAnalyzerBase.replaceWithGroupOneTextIfMatches(CS_SEE_TAG, commentText);
        Matcher matcher = XMLTAG_PATTERN.matcher(commentText);
        return matcher.replaceAll("");
    }

    public static boolean isInheritdocFoundInCSComment(String commentText) {
        Matcher matcher = CS_INHERITDOC_XMLTAG_PATTERN.matcher(commentText);
        return matcher.find();
    }

    public static boolean isInheritdocFoundInJavaComment(String commentText) {
        Matcher matcher = JAVA_INHERITDOC_PATTERN.matcher(commentText);
        return matcher.find();
    }

    private static String replaceWithGroupOneTextIfMatches(Pattern pattern, String text) {
        Matcher matcher = pattern.matcher(text);
        if (matcher.find() && matcher.groupCount() > 0) {
            String replacement = Matcher.quoteReplacement(matcher.group(1));
            return matcher.replaceAll(replacement);
        }
        return text;
    }

    protected static enum ECommentInspectionResult {
        COMMENTED,
        EMPTY,
        UNCOMMENTED;

    }
}

