/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.classification;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.ECommentCategory;
import com.teamscale.index.comment_analysis.classification.ECommentClassificationFeature;
import com.teamscale.index.comment_analysis.classification.ICommentClassifier;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CommentClassifierBase
implements ICommentClassifier {
    private static final Pattern TASK_TAG_PATTERN = Pattern.compile("\\b(todo|fixme|hack)\\b", 258);
    private static final Pattern NON_JAVADOC_COMMENT_PATTERN = Pattern.compile("\\(non-javadoc\\).*@see", 34);

    @Override
    public ECommentCategory getClassification(Comment comment) {
        ECommentCategory preclassification = CommentClassifierBase.preClassify(comment);
        if (preclassification != null) {
            return preclassification;
        }
        ECommentClassificationFeature[] features = ECommentClassificationFeature.values();
        Object[] featureVector = new Object[features.length];
        for (int i = 0; i < features.length; ++i) {
            Object value = features[i].extractFromComment(comment);
            if (features[i].isBooleanFeature()) {
                value = CommentClassifierBase.boolToDouble((Boolean)value);
            }
            featureVector[i] = value;
        }
        return ECommentCategory.values()[(int)this.classify(featureVector)];
    }

    protected abstract double classify(Object[] var1);

    private static double boolToDouble(boolean b) {
        if (b) {
            return 1.0;
        }
        return 0.0;
    }

    public static @Nullable ECommentCategory preClassify(Comment comment) {
        if (TASK_TAG_PATTERN.matcher(comment.getText()).find()) {
            return ECommentCategory.TASK;
        }
        if (NON_JAVADOC_COMMENT_PATTERN.matcher(comment.getText()).find()) {
            return ECommentCategory.INTERFACE;
        }
        if (ECommentClassificationFeature.COMMENTED_CODE.extractFromComment(comment).equals(1.0)) {
            return ECommentCategory.CODE;
        }
        return null;
    }
}

