/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.utils;

import com.teamscale.index.comment_analysis.classification.CodeRecognizer;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageProperties;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class CommentUtils {
    private static final String[] DEFAULT_COMMENT_PARTS = new String[]{"@see", "@inheritDoc", "@deprecated", "<inheritDoc", "<deprecated", "<see", "constructor", "destructor", "@ConQAT\\.Doc"};
    public static final String[] JAVA_DOC_TAGS = new String[]{"@param", "@return", "@throws", "@since", "@deprecated", "@author", "@see", "@serial"};

    public static boolean isDefaultComment(String comment) {
        String reducedComment = StringUtils.removeAll((String)comment.toLowerCase(), (String[])DEFAULT_COMMENT_PARTS);
        return reducedComment.length() != comment.length();
    }

    public static boolean hasOnlyJavaDoc(String comment) {
        return StringUtils.isEmpty((String)CommentUtils.normalizeComment(CommentUtils.removeLineBreaks(comment)));
    }

    private static String normalizeComment(String comment) {
        String result = CommentUtils.removeJavaDocElements(comment);
        result = result.replace('_', ' ');
        result = StringUtils.removeAll((String)result, (String[])new String[]{"}"});
        return result;
    }

    private static String removeJavaDocElements(String comment) {
        return StringUtils.removeAll((String)comment, (String[])JAVA_DOC_TAGS);
    }

    private static String removeLineBreaks(String comment) {
        return StringUtils.replaceLineBreaks((String)comment, (char)' ');
    }

    public static String getTextInComment(String comment, ELanguage language) {
        StringBuilder result = new StringBuilder();
        List lines = StringUtils.splitLinesAsList((String)comment);
        for (String line : lines) {
            if (CodeRecognizer.isCodeLine(line, language)) continue;
            result.append(" ").append(line);
        }
        return CommentUtils.normalizeComment(result.toString());
    }

    public static List<IToken> getCommentTokens(List<IToken> tokens) {
        return CollectionUtils.filter(tokens, t -> t.getType().getTokenClass() == ETokenType.ETokenClass.COMMENT);
    }

    public static List<String> getCommentTextLines(IToken commentToken) {
        return StringUtils.splitLinesAsList((String)LanguageProperties.of((ELanguage)commentToken.getLanguage()).getCommentContent(commentToken.getText()));
    }
}

