/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.JsonMigrator;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.index.migration.finding.ConfigurationOptionReplacement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class AnalysisProfileMigrationUtils {
    public static @Nullable ObjectNode getAnalysisGroup(ObjectNode analysisProfile, String analysisGroupName) {
        return AnalysisProfileMigrationUtils.getAnalysisGroupsByName(analysisProfile).get(analysisGroupName);
    }

    static Map<String, ObjectNode> getAnalysisGroupsByName(ObjectNode analysisProfile) {
        ArrayNode qualityIndicators = AnalysisProfileMigrationUtils.getQualityIndicators(analysisProfile);
        CCSMAssert.isNotNull((Object)qualityIndicators);
        HashMap<String, ObjectNode> analysisGroupNames = new HashMap<String, ObjectNode>();
        for (int i = 0; i < qualityIndicators.size(); ++i) {
            JsonNode qualityIndicator = qualityIndicators.get(i);
            if (!qualityIndicator.has("groups")) continue;
            ArrayNode analysisGroups = (ArrayNode)CCSMAssert.checkedCast((Object)qualityIndicator.get("groups"), ArrayNode.class);
            for (int j = 0; j < analysisGroups.size(); ++j) {
                analysisGroupNames.putIfAbsent(analysisGroups.get(j).get("name").asText(), (ObjectNode)CCSMAssert.checkedCast((Object)analysisGroups.get(j), ObjectNode.class));
            }
        }
        return analysisGroupNames;
    }

    private static boolean isCodeInspectorGroup(ObjectNode analysisGroup) {
        Iterator codeCloneOptions = analysisGroup.get("options").fieldNames();
        while (codeCloneOptions.hasNext()) {
            String optionName = (String)codeCloneOptions.next();
            if (!optionName.startsWith("EXTENDED_CHECK")) continue;
            return true;
        }
        return false;
    }

    private static String moveAbapCodeInspectorCheckOptions(ObjectNode oldAnalysisGroup, String newAnalysisGroup, String json) throws MigrationException {
        Iterator codeCloneOptions = oldAnalysisGroup.get("options").fieldNames();
        ArrayList<String> optionNames = new ArrayList<String>();
        while (codeCloneOptions.hasNext()) {
            optionNames.add((String)codeCloneOptions.next());
        }
        List<ConfigurationOptionReplacement> migrations = optionNames.stream().map(option -> new ConfigurationOptionReplacement((String)option, oldAnalysisGroup.get("name").textValue(), (String)option, newAnalysisGroup)).toList();
        return new JsonMigrator(migrations).migrate(json);
    }

    public static Set<String> getLanguagesInUseJson(String analysisProfileJson) throws MigrationException {
        return AnalysisProfileMigrationUtils.getPropertiesFromProfile(analysisProfileJson, "languages");
    }

    static Set<String> getToolsInUseJson(String analysisProfileJson) throws MigrationException {
        return AnalysisProfileMigrationUtils.getPropertiesFromProfile(analysisProfileJson, "tools");
    }

    static Set<String> getPropertiesFromProfile(ObjectNode analysisProfile, String analysisProfileProperty) {
        JsonNode propertyNode = analysisProfile.get(analysisProfileProperty);
        HashSet<String> properties = new HashSet<String>();
        for (int i = 0; i < propertyNode.size(); ++i) {
            properties.add(propertyNode.get(i).textValue());
        }
        return properties;
    }

    static ObjectNode getAnalysisProfileObjectNode(String analysisProfileJson) throws MigrationException {
        ObjectNode analysisProfile;
        try {
            analysisProfile = (ObjectNode)JsonUtils.deserializeFromJson((String)analysisProfileJson, ObjectNode.class);
        }
        catch (JsonSerializationException e) {
            throw new MigrationException((Throwable)e);
        }
        return analysisProfile;
    }

    static LinkedHashMap<String, String> getOptionsInUse(ObjectNode node) throws MigrationException {
        try {
            return (LinkedHashMap)JsonUtils.getObjectMapper().treeToValue((TreeNode)node.findValue("options"), (JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructMapType(LinkedHashMap.class, String.class, String.class));
        }
        catch (JsonProcessingException e) {
            throw new MigrationException((Throwable)e);
        }
    }

    static List<ObjectNode> getAnalysisGroups(ObjectNode analysisProfile, String analysisGroupName) {
        if (!analysisProfile.has("qualityIndicators")) {
            return Collections.emptyList();
        }
        ArrayNode qualityIndicators = (ArrayNode)CCSMAssert.checkedCast((Object)analysisProfile.get("qualityIndicators"), ArrayNode.class);
        ArrayList<ObjectNode> result = new ArrayList<ObjectNode>();
        for (int i = 0; i < qualityIndicators.size(); ++i) {
            JsonNode qualityIndicator = qualityIndicators.get(i);
            if (!qualityIndicator.has("groups")) continue;
            ArrayNode analysisGroups = (ArrayNode)CCSMAssert.checkedCast((Object)qualityIndicator.get("groups"), ArrayNode.class);
            for (int j = 0; j < analysisGroups.size(); ++j) {
                String groupName = analysisGroups.get(j).get("name").asText();
                if (!analysisGroupName.equals(groupName)) continue;
                result.add((ObjectNode)CCSMAssert.checkedCast((Object)analysisGroups.get(j), ObjectNode.class));
            }
        }
        return result;
    }

    static String mergeDuplicateCodeClonesGroups(String json) throws MigrationException {
        Set<String> toolsInUseJson = AnalysisProfileMigrationUtils.getToolsInUseJson(json);
        if (!toolsInUseJson.contains("CODE_INSPECTOR") || AnalysisProfileMigrationUtils.getNumberOfAnalysisGroups(json, "Code Clones") < 2) {
            return json;
        }
        try {
            ObjectNode analysisProfileNode = (ObjectNode)CCSMAssert.checkedCast((Object)JsonUtils.deserializeFromJson((String)json), ObjectNode.class);
            String tempCodeInspectorGroupName = "Temp-CodeInspector-Cloning";
            String tempCloningGroupName = "Temp-Cloning";
            List<ObjectNode> codeClonesGroups = AnalysisProfileMigrationUtils.getAnalysisGroups(analysisProfileNode, "Code Clones");
            for (ObjectNode codeClonesGroup : codeClonesGroups) {
                boolean isCodeInspectorGroup = AnalysisProfileMigrationUtils.isCodeInspectorGroup(codeClonesGroup);
                String tempGroupName = isCodeInspectorGroup ? tempCodeInspectorGroupName : tempCloningGroupName;
                json = AnalysisProfileMigrationUtils.moveAbapCodeInspectorCheckOptions(Objects.requireNonNull(codeClonesGroup), tempGroupName, json);
                analysisProfileNode = (ObjectNode)CCSMAssert.checkedCast((Object)JsonUtils.deserializeFromJson((String)json), ObjectNode.class);
            }
            json = AnalysisProfileMigrationUtils.renameCodeCloneGroups(json, analysisProfileNode, tempCloningGroupName, tempCodeInspectorGroupName);
        }
        catch (JsonSerializationException e) {
            throw new MigrationException((Throwable)e);
        }
        return json;
    }

    private static String renameCodeCloneGroups(String json, ObjectNode analysisProfileNode, String tempCloningGroupName, String tempCodeInspectorGroupName) throws MigrationException {
        ObjectNode tempCodeClonesGroup = AnalysisProfileMigrationUtils.getAnalysisGroup(analysisProfileNode, tempCloningGroupName);
        json = AnalysisProfileMigrationUtils.moveAbapCodeInspectorCheckOptions(Objects.requireNonNull(tempCodeClonesGroup), "Code Clones", json);
        ObjectNode tempCodeInspectorGroup = AnalysisProfileMigrationUtils.getAnalysisGroup(analysisProfileNode, tempCodeInspectorGroupName);
        json = AnalysisProfileMigrationUtils.moveAbapCodeInspectorCheckOptions(Objects.requireNonNull(tempCodeInspectorGroup), "Code Clones", json);
        return json;
    }

    private static int getNumberOfAnalysisGroups(String json, String analysisGroupName) throws MigrationException {
        ObjectNode analysisProfile = AnalysisProfileMigrationUtils.getAnalysisProfileObjectNode(json);
        int result = 0;
        if (!analysisProfile.has("qualityIndicators")) {
            return result;
        }
        ArrayNode qualityIndicators = (ArrayNode)CCSMAssert.checkedCast((Object)analysisProfile.get("qualityIndicators"), ArrayNode.class);
        for (int i = 0; i < qualityIndicators.size(); ++i) {
            JsonNode qualityIndicator = qualityIndicators.get(i);
            if (!qualityIndicator.has("groups")) continue;
            ArrayNode analysisGroups = (ArrayNode)CCSMAssert.checkedCast((Object)qualityIndicator.get("groups"), ArrayNode.class);
            for (int j = 0; j < analysisGroups.size(); ++j) {
                ObjectNode group = (ObjectNode)CCSMAssert.checkedCast((Object)analysisGroups.get(j), ObjectNode.class);
                if (!analysisGroupName.equals(group.get("name").asText())) continue;
                ++result;
            }
        }
        return result;
    }

    private static Set<String> getPropertiesFromProfile(String analysisProfileJson, String analysisProfileProperty) throws MigrationException {
        ObjectNode analysisProfile = AnalysisProfileMigrationUtils.getAnalysisProfileObjectNode(analysisProfileJson);
        return AnalysisProfileMigrationUtils.getPropertiesFromProfile(analysisProfile, analysisProfileProperty);
    }

    static @Nullable ArrayNode getQualityIndicators(ObjectNode analysisProfile) {
        if (!analysisProfile.has("qualityIndicators")) {
            return null;
        }
        return (ArrayNode)CCSMAssert.checkedCast((Object)analysisProfile.get("qualityIndicators"), ArrayNode.class);
    }

    static List<ObjectNode> getAnalysisGroups(ObjectNode analysisProfile) {
        ArrayNode qualityIndicators = AnalysisProfileMigrationUtils.getQualityIndicators(analysisProfile);
        CCSMAssert.isNotNull((Object)qualityIndicators);
        ArrayList<ObjectNode> analysisGroups = new ArrayList<ObjectNode>();
        for (JsonNode indicator : qualityIndicators) {
            if (!indicator.has("groups")) continue;
            ArrayNode groupNodes = (ArrayNode)CCSMAssert.checkedCast((Object)indicator.get("groups"), ArrayNode.class);
            for (JsonNode groupNode : groupNodes) {
                ObjectNode analysisGroup = (ObjectNode)CCSMAssert.checkedCast((Object)groupNode, ObjectNode.class);
                analysisGroups.add(analysisGroup);
            }
        }
        return analysisGroups;
    }
}

