/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.architecture.ArchitectureFindingsCleaner;
import com.teamscale.index.architecture.ArchitectureMetricsMappingIndexSynchronizer;
import com.teamscale.index.architecture.ArchitectureReferenceContentSynchronizer;
import com.teamscale.index.architecture.ArchitectureReferenceDependenciesSynchronizer;
import com.teamscale.index.architecture.ArchitectureReferenceIndex;
import com.teamscale.index.architecture.IndexBasedArchitectureAnalysis;
import com.teamscale.index.architecture.external.ArchitectureUploadStateCleanupTrigger;
import com.teamscale.index.architecture.external.ExternalArchitectureUploadChangeRetriever;
import com.teamscale.index.architecture.external.ExternalArchitectureUploadPersister;
import com.teamscale.index.architecture.incremental.ArchitectureAnalysisSynchronizer;
import com.teamscale.index.architecture.incremental.ArchitectureComponentDependencyIndex;
import com.teamscale.index.architecture.incremental.ArchitectureComponentDependencySynchronizer;
import com.teamscale.index.architecture.incremental.ArchitectureFileDependenciesIndex;
import com.teamscale.index.architecture.incremental.ArchitectureMappingIndex;
import com.teamscale.index.architecture.incremental.ArchitectureScopeSynchronizer;
import com.teamscale.index.architecture.incremental.ArchitectureTypeDependenciesIndex;
import com.teamscale.index.dependencies.DependencyListIndex;
import com.teamscale.index.dependencies.DependencySynchronizer;
import com.teamscale.index.dependencies.ProjectModuleIndex;
import com.teamscale.index.dependencies.ProjectModuleIndexSynchronizer;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndexSynchronizer;
import com.teamscale.index.dependencies.UnresolvedDependenciesIndex;
import com.teamscale.index.dependencies.VariableWriteDependencyIndex;
import com.teamscale.index.dependencies.abap.AbapThirdPartyPathsIndex;
import com.teamscale.index.dependencies.abap.AbapThirdPartyPathsSynchronizer;
import com.teamscale.index.dependencies.cpp.CppDependencyExtractor;
import com.teamscale.index.dependencies.dart.DartPackagePathsIndex;
import com.teamscale.index.dependencies.dart.DartPubSpecPathsSynchronizer;
import com.teamscale.index.dependencies.javascript.TsConfigPathsIndex;
import com.teamscale.index.dependencies.javascript.TsConfigPathsSynchronizer;
import com.teamscale.index.dependencies.type.PatternMatchingCacheIndex;
import com.teamscale.index.external.update.ExternalUploadChangeRetrieverBase;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsIndexSynchronizer;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class ArchitectureAnalysisConfiguration
extends AnalysisConfigurationBase {
    public static final String EXTERNAL_ARCHITECTURE_COMMIT_TREE_INDEX = "external-architecture-commit-tree";
    public static final UnmodifiableSet<ELanguage> SUPPORTED_LANGUAGES = CollectionUtils.asUnmodifiable(EnumSet.of(ELanguage.JAVA, new ELanguage[]{ELanguage.CS, ELanguage.ABAP, ELanguage.ABAP_DDIC, ELanguage.ABAP_CDS, ELanguage.XML, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVASCRIPT, ELanguage.MATLAB, ELanguage.PHP, ELanguage.HANA_VIEW, ELanguage.IEC61131, ELanguage.PYTHON, ELanguage.SIMULINK, ELanguage.GOSU, ELanguage.KOTLIN, ELanguage.DART}));
    @ConfigExposed(name="Include 3rd-party dependencies", description="Whether to consider dependencies to 3rd-party code for which the content is not available in Teamscale. The extracted dependencies will always be type-based.")
    private boolean includeThirdPartyDependencies = false;
    @ConfigExposed(name="Header resolution is case sensitive (only C/C++)", description="Whether the resolution of header files to types is done case-sensitive. Builds on Windows systems require case-insensitive resolution, but this can lead to false dependencies on unix builds.")
    private boolean performCaseSensitiveHeaderResolution = false;
    @ConfigExposed(name="Search for dependencies in excluded code (only C/C++)", description="If enabled, the architecture analysis for C/C++ code also tries to extract dependencies from code that is excluded from the normal analysis. For example, generated code filtered by text filters in the project configuration or code excluded by the preprocessor (e.g., in \"#if 0\" directives). The architecture analysis for most other languages always extracts dependencies from excluded code (excluded by text filters). [documentation](./documentation/howto/improving-analysis-results-for-cpp/#analyzing-excluded-code-in-architecture-analysis)")
    private boolean findCppDependenciesInExcludedCode = false;
    @ConfigExposed(name="Include intermediary types in call chain (only ABAP)", description="Whether to  interpret intermediary types in a call chain as dependencies. An intermediary type is, for example, the return type of m in this call: DATA(x) = l_y=>m()->f().")
    private boolean includeIntermediaryTypesInCallChain = false;
    private final FindingDescriptor policyViolationFinding = new FindingDescriptor("Architecture violation", EAnalysisTool.TEAMSCALE, SUPPORTED_LANGUAGES, EFindingEnablement.RED, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-policy-violation.md").orElseThrow());
    private final FindingDescriptor unmatchedTypesFinding = new FindingDescriptor("Unmatched Types", EAnalysisTool.TEAMSCALE, SUPPORTED_LANGUAGES, EFindingEnablement.YELLOW, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-unmatched-types.md").orElseThrow());

    public ArchitectureAnalysisConfiguration() {
        this.autoExpose();
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        ArchitectureAnalysisConfiguration.createIndexes(proxy);
        this.createTriggers(proxy);
        ArchitectureAnalysisConfiguration.createArchitectureMetricTriggers(proxy);
        proxy.addFindingsSchemaEntry("Architecture Conformance", this.policyViolationFinding.getName(), this.policyViolationFinding);
        proxy.addFindingsSchemaEntry("Architecture Conformance", this.unmatchedTypesFinding.getName(), this.unmatchedTypesFinding);
    }

    private static void createIndexes(ProjectCreationProxy proxy) {
        proxy.createProjectIndex(DependencyListIndex.class, "dependencies");
        proxy.createProjectIndex(DependencyListIndex.class, "inverse-dependencies");
        proxy.createProjectIndex(TypeDependencyIndex.class);
        proxy.createProjectIndex(UnresolvedDependenciesIndex.class);
        proxy.createProjectIndex(ArchitectureAssessmentIndex.class);
        proxy.createProjectIndex(ArchitectureReferenceIndex.class);
        proxy.createProjectIndex(ArchitectureMappingIndex.class);
        proxy.createProjectIndex(ArchitectureFileDependenciesIndex.class);
        proxy.createProjectIndex(ArchitectureTypeDependenciesIndex.class);
        proxy.createProjectIndex(ArchitectureComponentDependencyIndex.class);
        proxy.createProjectIndex(ProjectModuleIndex.class);
        proxy.createProjectIndex(PatternMatchingCacheIndex.class);
        proxy.createProjectIndex(CommitTreeIndex.class, EXTERNAL_ARCHITECTURE_COMMIT_TREE_INDEX);
        proxy.createProjectIndex(VariableWriteDependencyIndex.class);
        proxy.createProjectIndex(AbapThirdPartyPathsIndex.class);
        proxy.createProjectIndex(TsConfigPathsIndex.class);
        proxy.createProjectIndex(DartPackagePathsIndex.class);
    }

    private void createTriggers(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.createTriggerForTypeIndexSynchronizer(proxy);
        proxy.createTrigger(new TriggerBuilder(ProjectModuleIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        this.createTriggerForDependencySynchronizer(proxy);
        proxy.createTrigger(new TriggerBuilder(IndexBasedArchitectureAnalysis.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(ArchitectureAnalysisSynchronizer.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(ArchitectureScopeSynchronizer.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(ArchitectureFindingsCleaner.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(ArchitectureReferenceContentSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(ArchitectureComponentDependencySynchronizer.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(ArchitectureReferenceDependenciesSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        for (EAnalysisState state : EAnalysisState.values()) {
            proxy.addPostRevisionAnalysisTrigger(state, ArchitectureUploadStateCleanupTrigger.class);
        }
        ArchitectureAnalysisConfiguration.createExternalArchitectureUploadTriggers(proxy);
        ArchitectureAnalysisConfiguration.configureAbapSupport(proxy);
    }

    private void createTriggerForTypeIndexSynchronizer(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        TriggerBuilder triggerBuilder = new TriggerBuilder(TypeIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED);
        if (CppDependencyExtractor.ACCEPTED_LANGUAGES.stream().anyMatch(((Set)proxy.getConfiguredLanguages().getValueForDefaultCodeScope())::contains)) {
            triggerBuilder.setTriggerParameter("perform-case-sensitive-header-resolution", this.performCaseSensitiveHeaderResolution);
            triggerBuilder.setTriggerParameter("find-dependencies-in-excluded-code", this.findCppDependenciesInExcludedCode);
        }
        proxy.createTrigger(triggerBuilder);
    }

    private void createTriggerForDependencySynchronizer(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        TriggerBuilder triggerBuilder = new TriggerBuilder(DependencySynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED);
        triggerBuilder.setTriggerParameter("include-third-party-dependencies", this.includeThirdPartyDependencies);
        if (CppDependencyExtractor.ACCEPTED_LANGUAGES.stream().anyMatch(((Set)proxy.getConfiguredLanguages().getValueForDefaultCodeScope())::contains)) {
            triggerBuilder.setTriggerParameter("perform-case-sensitive-header-resolution", this.performCaseSensitiveHeaderResolution);
            triggerBuilder.setTriggerParameter("find-dependencies-in-excluded-code", this.findCppDependenciesInExcludedCode);
        }
        if (((Set)proxy.getConfiguredLanguages().getValueForDefaultCodeScope()).contains(ELanguage.ABAP)) {
            triggerBuilder.setTriggerParameter("include-intermediary-types-in-call-chain", this.includeIntermediaryTypesInCallChain);
        }
        if (((Set)proxy.getConfiguredLanguages().getValueForDefaultCodeScope()).contains(ELanguage.JAVASCRIPT)) {
            proxy.createTrigger(new TriggerBuilder(TsConfigPathsSynchronizer.class, ETriggerConcurrency.PARALLEL));
        }
        if (((Set)proxy.getConfiguredLanguages().getValueForDefaultCodeScope()).contains(ELanguage.DART)) {
            proxy.createTrigger(new TriggerBuilder(DartPubSpecPathsSynchronizer.class, ETriggerConcurrency.PARALLEL));
        }
        proxy.createTrigger(triggerBuilder);
    }

    private static void configureAbapSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        if (!((Set)proxy.getConfiguredLanguages().getValueForDefaultCodeScope()).contains(ELanguage.ABAP)) {
            return;
        }
        proxy.createTrigger(new TriggerBuilder(AbapThirdPartyPathsSynchronizer.class, ETriggerConcurrency.PARALLEL));
    }

    private static void createExternalArchitectureUploadTriggers(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        TriggerBuilder externalArchitectureUploadChangeRetrieverTriggerBuilder = ExternalUploadChangeRetrieverBase.configurePeriodicTrigger(ExternalArchitectureUploadChangeRetriever.class);
        proxy.createTrigger(externalArchitectureUploadChangeRetrieverTriggerBuilder);
        proxy.addPostBuildCompletenessAnalysisTrigger(externalArchitectureUploadChangeRetrieverTriggerBuilder);
        proxy.createTrigger(new TriggerBuilder(ExternalArchitectureUploadPersister.class, ETriggerConcurrency.PARALLEL));
    }

    private static void createArchitectureMetricTriggers(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createTrigger(new TriggerBuilder(ArchitectureMetricsMappingIndexSynchronizer.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(ArchitectureMetricsIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        if (CollectionUtils.intersectionSet(languages, (Collection[])new Collection[]{SUPPORTED_LANGUAGES}).isEmpty()) {
            return;
        }
        ArrayList<ConfigOptionDescriptorBase> items = new ArrayList<ConfigOptionDescriptorBase>(Collections.singletonList(this.getOptionForField("includeThirdPartyDependencies")));
        if (languages.contains(ELanguage.ABAP)) {
            items.add(this.getOptionForField("includeIntermediaryTypesInCallChain"));
        }
        if (LanguageGroups.C_CPP_AND_MS_CLI.stream().anyMatch(languages::contains)) {
            items.add(this.getOptionForField("performCaseSensitiveHeaderResolution"));
            items.add(this.getOptionForField("findCppDependenciesInExcludedCode"));
        }
        items.addAll(Arrays.asList(this.policyViolationFinding, this.unmatchedTypesFinding));
        template.registerConfigurationItems("Architecture Conformance", "Architecture", items);
    }

    public boolean isCoreConfiguration() {
        return true;
    }
}

