/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.google.common.base.Verify;
import com.teamscale.core.analysis.IndexBasedAnalysisConstants;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.runtime.impl.analysis.CoreConfiguration;
import com.teamscale.index.code_clones.CloneChunkByHashIndex;
import com.teamscale.index.code_clones.CloneChunkByPathIndex;
import com.teamscale.index.code_clones.CloneChunkIndexInverter;
import com.teamscale.index.code_clones.CloneChunkIndexSynchronizer;
import com.teamscale.index.code_clones.CloneClassIndex;
import com.teamscale.index.code_clones.CloneListIndex;
import com.teamscale.index.code_clones.CloneSynchronizer;
import com.teamscale.index.code_clones.CloneWiaUtils;
import com.teamscale.wia.WiaUtils;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.Unmodifiable;

public class CloningConfiguration
extends AnalysisConfigurationBase {
    private static final int DEFAULT_CODE_CLONE_MIN_LENGTH = 10;
    private static final int DEFAULT_SPEC_ITEM_CLONE_MIN_LENGTH = 50;
    private static final int DEFAULT_CLONE_MIN_LENGTH_COBOL = 20;
    private static final int DEFAULT_CLONE_CLASS_SIZE_LIMIT = 50;
    private static final int CLONE_INDEX_CHUNK_SIZE = 5;
    private static final int CLONE_INDEX_CHUNK_SIZE_GAPPED = 3;
    public static final String CLONE_DESCRIPTION_PATH = "cqse-clone.md";
    private static final String SPECIFICATION_CLONE_DESCRIPTION_PATH = "cqse-specification-clone.md";
    public static final String CLONE_COVERAGE_METRIC_NAME = "Clone Coverage";
    public static final String CROSS_COMPONENT_CLONE_COVERAGE_METRIC_NAME = "Cross Component Clone Coverage";
    public static final String INTRA_COMPONENT_CLONE_COVERAGE_METRIC_NAME = "Intra Component Clone Coverage";
    @ConfigExposed(name="Minimal code clone length", description="The minimal length of detected clones in statements.")
    private int codeCloneMinLength = 10;
    @ConfigExposed(name="Minimal spec item clone length", description="The minimal length of detected clones in spec items.")
    private int specItemCloneMinLength = 50;
    @ConfigExposed(name="Code clone instance limit", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Clone classes with more than the given number of clone instances will not be reported. Note that very large clone classes will increase the memory consumption and run-time significantly. If clones are potentially lost due to these settings, this will be shown in the worker log.\n")
    private int codeCloneClassSizeLimit = 50;
    @ConfigExposed(name="Spec item clone instance limit", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Clone classes with more than the given number of clone instances will not be reported. Note that very large clone classes will increase the memory consumption and run-time significantly. If clones are potentially lost due to these settings, this will be shown in the worker log.\n")
    private int specItemCloneClassSizeLimit = 50;
    @ConfigExposed(name="Exclude Path Patterns", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="List of ant patterns for which paths should be ignored in the code clone detection. (e.g. **/Foo.java)")
    private List<String> ignoreCodePatternList = CollectionUtils.emptyList();
    @ConfigExposed(name="Exclude Spec Item Patterns", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="List of ant patterns for which paths should be ignored in the spec item clone detection. (e.g. My Area/**)")
    private List<String> ignoreSpecItemPatternList = CollectionUtils.emptyList();
    @ConfigExposed(name="Allow code gaps", description="Whether to allow gaps in the detected clones.", visibility=ConfigExposed.EConfigVisibility.EXPERIMENTAL)
    private boolean allowCodeGaps = false;
    @ConfigExposed(name="Allow spec item gaps", description="Whether to allow gaps in the detected clones.", visibility=ConfigExposed.EConfigVisibility.EXPERIMENTAL)
    private boolean allowSpecItemGaps = false;
    @ConfigExposed(name="Include closed spec items", description="Whether to include clones in closed spec items.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private boolean includeClosedSpecItems = false;
    @ConfigExposed(name="Component-based Clone Analysis: Architecture filename", description="The path of the architecture file that defines the components to be used for cross and/or intra component clone detection", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private String crossComponentArchitectureFilename = "clone_analysis_components.architecture";
    @ConfigExposed(name="Enable exclusive intra-component detection", description="Enables an *alternative mode* for intra-component clone detection that detects clones within the components specified by the cross-component architecture. Cross-component clones cannot be detected in this mode, but potentially more intra-component clones, esp. if code is shared between components.  \n**Note:** This mode generates clone findings only if the cross-component architecture file is present and contains components. All files that do not belong to a component are ignored.\n", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private boolean exclusiveIntraComponentDetection = false;
    private final CodeScopeAware<MetricDescriptor> cloneCoverageMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Clone Coverage", "The relative amount of statements covered by at least one clone."));
    private final MetricDescriptor crossComponentCloneCoverageMetric = new MetricDescriptor("Cross Component Clone Coverage", "The relative amount of statements covered by at least one cross component clone.", false, ConfigExposed.EConfigVisibility.EXPERT);
    private final MetricDescriptor intraComponentCloneCoverageMetric = new MetricDescriptor("Intra Component Clone Coverage", "The relative amount of statements covered by at least one intra component clone.", false, ConfigExposed.EConfigVisibility.EXPERT);
    private static final Map<String, String> CLONE_FINDING_PROPERTIES = Map.of("Instances", "The number of clone instances, i.e., in how many locations in the source code does the fragment exist.", "Length", "The length of the clone, i.e., how many statements are duplicated.", "Gaps", "The maximal number of different statements between any pair of the cloned fragments.");
    private static final Map<String, String> SPECIFICATION_CLONE_FINDING_PROPERTIES = Map.of("Instances", "The number of the clone instances, i.e., in how many locations does the fragment exist.", "Length", "The length of the clone, i.e., how many words are duplicated.", "Gaps", "The maximal number of different words between any pair of the cloned fragments.");
    private final CodeScopeAware<FindingDescriptor> cloneFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)CloningConfiguration.createCloneFinding("Clones", EFindingEnablement.YELLOW, ConfigExposed.EConfigVisibility.DEFAULT, null, CLONE_FINDING_PROPERTIES));
    private final FindingDescriptor crossComponentCloneFinding = CloningConfiguration.createCloneFinding("Cross Component Clones", EFindingEnablement.OFF, ConfigExposed.EConfigVisibility.EXPERT, "Cross Component Clones are Clones that have at least on sibling in another component as defined in the cross component cloning architecture.", null);
    private final FindingDescriptor intraComponentCloneFinding = CloningConfiguration.createCloneFinding("Intra Component Clones", EFindingEnablement.OFF, ConfigExposed.EConfigVisibility.EXPERT, "Intra Component Clones are Clones where all siblings are located within the same component as per the component definitions in the cross component cloning architecture", null);
    private final FindingDescriptor specificationCloneFinding = CloningConfiguration.createSpecificationCloneFinding();

    private static FindingDescriptor createCloneFinding(String idAndReadableName, EFindingEnablement findingEnablement, ConfigExposed.EConfigVisibility visibility, String additionalDescriptionInfo, @Nullable Map<String, String> properties) {
        FindingDescriptor findingDescriptor = new FindingDescriptor(idAndReadableName, EAnalysisTool.TEAMSCALE, (Set)CollectionUtils.differenceSet(EnumSet.allOf(ELanguage.class), (Collection[])new Collection[]{WiaUtils.getWiaEnabledLanguages(), Set.of(ELanguage.KUBERNETES)}), findingEnablement, visibility, CloningConfiguration.getCloneFindingDescription(additionalDescriptionInfo));
        if (properties != null) {
            properties.forEach((arg_0, arg_1) -> ((FindingDescriptor)findingDescriptor).setPropertyDescription(arg_0, arg_1));
        }
        return findingDescriptor;
    }

    private static FindingDescriptor createSpecificationCloneFinding() {
        FindingDescriptor findingDescriptor = new FindingDescriptor("spec-item-clones", "Clones", EAnalysisTool.TEAMSCALE, CloneWiaUtils.getSupportedLanguages(), EFindingEnablement.YELLOW, ConfigExposed.EConfigVisibility.DEFAULT, (String)CheckDescriptionLoader.getCheckDescription(CloningConfiguration.class, (String)SPECIFICATION_CLONE_DESCRIPTION_PATH).orElseThrow());
        SPECIFICATION_CLONE_FINDING_PROPERTIES.forEach((arg_0, arg_1) -> ((FindingDescriptor)findingDescriptor).setPropertyDescription(arg_0, arg_1));
        return findingDescriptor;
    }

    private static String getCloneFindingDescription(@Nullable String additionalInfo) {
        String baseDescription = (String)CheckDescriptionLoader.getCheckDescription(CloningConfiguration.class, (String)CLONE_DESCRIPTION_PATH).orElseThrow();
        Object replacementString = "";
        if (!StringUtils.isEmpty((String)additionalInfo)) {
            replacementString = additionalInfo + "\n";
        }
        return baseDescription.replace("<ADDITIONAL_INFO>", (CharSequence)replacementString);
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.verifyNormalCloneMetricAndFindings();
        this.verifyComponentRelatedConfig();
        CloningConfiguration.createIndexes(proxy);
        this.createCloneCoverageMetrics(proxy);
        for (CodeScopeName scopeName : proxy.getCodeScopeNames()) {
            this.addFindingSchemaEntries(proxy, scopeName);
        }
        this.createTriggers(proxy);
    }

    private void createTriggers(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        if (!this.isCloningEnabled()) {
            return;
        }
        CodeScopeAware<Boolean> perScopeEnablement = this.getCloneAnalysisEnablementPerScope(proxy.getCodeScopeNames());
        this.createCloneChunkIndexTrigger(proxy, perScopeEnablement);
        this.createCloneSynchronizerTrigger(proxy, perScopeEnablement);
    }

    private void addFindingSchemaEntries(ProjectCreationProxy proxy, CodeScopeName scopeName) {
        proxy.addFindingsSchemaEntry("Redundancy", "Clones", (FindingDescriptor)this.cloneFinding.getValue(scopeName), scopeName);
        proxy.addFindingsSchemaEntry("Redundancy", "Specification Clones", this.specificationCloneFinding, scopeName);
        proxy.addFindingsSchemaEntry("Redundancy", "Cross Component Clones", this.crossComponentCloneFinding, scopeName);
        proxy.addFindingsSchemaEntry("Redundancy", "Intra Component Clones", this.intraComponentCloneFinding, scopeName);
    }

    private @NonNull CodeScopeAware<Boolean> getCloneAnalysisEnablementPerScope(List<CodeScopeName> codeScopeNames) {
        if (this.isCloningEnabledNonCodeScope()) {
            return CodeScopeAware.sameForAll(codeScopeNames, (Object)Boolean.TRUE);
        }
        CodeScopeAware enablement = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : codeScopeNames) {
            boolean activeInScope = ((FindingDescriptor)this.cloneFinding.getValue(codeScopeName)).isActive() || ((MetricDescriptor)this.cloneCoverageMetric.getValue(codeScopeName)).isActive();
            enablement.setValue(codeScopeName, (Object)activeInScope);
        }
        return enablement;
    }

    private boolean cloneFindingActiveInAnyScope() {
        return this.cloneFinding.getValues().stream().anyMatch(FindingDescriptor::isActive);
    }

    private @NonNull Stream<CodeScopeName> getScopesWithActiveCloneFinding() {
        return this.cloneFinding.parameter().entrySet().stream().filter(e -> ((FindingDescriptor)e.getValue()).isActive()).map(Map.Entry::getKey);
    }

    private boolean cloneCoverageMetricActiveInAnyScope() {
        return this.cloneCoverageMetric.getValues().stream().anyMatch(MetricDescriptor::isActive);
    }

    private @NonNull @Unmodifiable Set<CodeScopeName> getScopesWithDisabledCloneCoverageMetric() {
        return this.cloneCoverageMetric.parameter().entrySet().stream().filter(e -> !((MetricDescriptor)e.getValue()).isActive()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private @NonNull Stream<CodeScopeName> getScopesWithEnabledCloneCoverageMetric() {
        return this.cloneCoverageMetric.parameter().entrySet().stream().filter(e -> ((MetricDescriptor)e.getValue()).isActive()).map(Map.Entry::getKey);
    }

    private void verifyNormalCloneMetricAndFindings() throws ProjectConfigurationException {
        Set scopesWithFindings = this.getScopesWithActiveCloneFinding().collect(Collectors.toSet());
        if (scopesWithFindings.isEmpty()) {
            return;
        }
        List<String> scopesWithMetricButNoFinding = this.getScopesWithEnabledCloneCoverageMetric().filter(Predicate.not(scopesWithFindings::contains)).map(CodeScopeName::toString).sorted().toList();
        if (!scopesWithMetricButNoFinding.isEmpty()) {
            throw new ProjectConfigurationException("Since code clone findings are enabled in at least one code scope, the code clone coverage metric can be enabled only if code clone findings are also enabled in the respective code scope. The following code scopes violate this constraint: " + String.join((CharSequence)", ", scopesWithMetricButNoFinding));
        }
    }

    private void verifyComponentRelatedConfig() throws ProjectConfigurationException {
        boolean cloneFindingActiveInAnyScope = this.cloneFindingActiveInAnyScope();
        if (this.exclusiveIntraComponentDetection) {
            if (cloneFindingActiveInAnyScope || this.crossComponentCloneFinding.isActive()) {
                String scopeMessage = this.getComponentAndScopeRelatedErrorMessage();
                throw new ProjectConfigurationException("Only Intra-component Clones can be enabled if exclusive intra-component cloning is enabled." + scopeMessage);
            }
            if (this.specificationCloneFinding.isActive()) {
                throw new ProjectConfigurationException("Spec Item clone detection cannot be enabled if exclusive intra-component cloning is enabled.");
            }
            if (this.crossComponentCloneCoverageMetric.isActive()) {
                throw new ProjectConfigurationException("Cross-component clone coverage cannot be enabled if exclusive intra-component cloning is enabled.");
            }
            if (this.allowCodeGaps) {
                throw new ProjectConfigurationException("Gapped clone detection cannot be used if exclusive intra-component cloning is enabled.");
            }
        }
        if ((this.crossComponentCloneFinding.isActive() || this.intraComponentCloneFinding.isActive()) && cloneFindingActiveInAnyScope) {
            String scopeMessage = this.getComponentAndScopeRelatedErrorMessage();
            throw new ProjectConfigurationException("Clones cannot be enabled if either Cross or Intra Component Clone options are enabled." + scopeMessage);
        }
    }

    private @NonNull String getComponentAndScopeRelatedErrorMessage() {
        List<String> activeScopes = this.getScopesWithActiveCloneFinding().map(CodeScopeName::toString).toList();
        Object scopeMessage = "";
        if (!(activeScopes.isEmpty() || activeScopes.size() <= 1 && ((String)activeScopes.getFirst()).equals(CodeScopeAware.DEFAULT_CODE_SCOPE.name()))) {
            scopeMessage = " Normal clones are enabled in scopes: " + String.join((CharSequence)", ", activeScopes);
        }
        return scopeMessage;
    }

    private boolean isCloningEnabled() {
        return this.isCloningEnabledNonCodeScope() || this.cloneFindingActiveInAnyScope() || this.cloneCoverageMetricActiveInAnyScope();
    }

    private boolean isCloningEnabledNonCodeScope() {
        return this.specificationCloneFinding.isActive() || this.crossComponentCloneCoverageMetric.isActive() || this.intraComponentCloneCoverageMetric.isActive() || this.crossComponentCloneFinding.isActive() || this.intraComponentCloneFinding.isActive();
    }

    private void createCloneChunkIndexTrigger(ProjectCreationProxy proxy, CodeScopeAware<Boolean> perScopeEnablement) throws ProjectConfigurationException {
        TriggerBuilder triggerBuilder = new TriggerBuilder(CloneChunkIndexSynchronizer.class).setTriggerParameter("chunk-length", this.determineChunkLength()).setTriggerParameter("ignored-pattern", ITriggerParameter.of(this.getMergedExcludePatterns())).setTriggerParameter("clone-detection-enablement", perScopeEnablement);
        proxy.createTrigger(triggerBuilder);
        proxy.createTrigger(new TriggerBuilder(CloneChunkIndexInverter.class, ETriggerConcurrency.OUTPUT_ISOLATED));
    }

    private List<String> getMergedExcludePatterns() {
        return CollectionUtils.unionList(this.ignoreCodePatternList, (Collection[])new Collection[]{this.ignoreSpecItemPatternList});
    }

    private int determineChunkLength() {
        int chunkLength = 5;
        if (this.allowCodeGaps || this.allowSpecItemGaps) {
            chunkLength = 3;
        }
        return chunkLength;
    }

    private void addCloneSynchronizerConstraintParameters(TriggerBuilder cloneSynchronizer) {
        cloneSynchronizer.setTriggerParameter("min-code-clone-length", this.codeCloneMinLength);
        cloneSynchronizer.setTriggerParameter("min-spec-item-clone-length", this.specItemCloneMinLength);
        cloneSynchronizer.setTriggerParameter("code-clone-class-size-limit", this.codeCloneClassSizeLimit);
        cloneSynchronizer.setTriggerParameter("spec-item-clone-class-size-limit", this.specItemCloneClassSizeLimit);
        cloneSynchronizer.setTriggerParameter("allow-code-gaps", this.allowCodeGaps);
        cloneSynchronizer.setTriggerParameter("allow-spec-item-gaps", this.allowSpecItemGaps);
        cloneSynchronizer.setTriggerParameter("include-closed-spec-items", this.includeClosedSpecItems);
        cloneSynchronizer.setTriggerParameter("ignored-pattern", ITriggerParameter.of(this.getMergedExcludePatterns()));
    }

    private void createCloneSynchronizerTrigger(ProjectCreationProxy proxy, CodeScopeAware<Boolean> perScopeEnablement) throws ProjectConfigurationException {
        TriggerBuilder cloneSynchronizer = new TriggerBuilder(CloneSynchronizer.class, ETriggerConcurrency.PARALLEL);
        this.addCloneSynchronizerConstraintParameters(cloneSynchronizer);
        cloneSynchronizer.setTriggerParameter("clone-detection-enablement", perScopeEnablement);
        cloneSynchronizer.setTriggerParameter("report-normal-clones", (ITriggerParameter)this.cloneFinding.map(FindingDescriptor::isActive));
        cloneSynchronizer.setTriggerParameter("enable-clone-coverage-metric", (ITriggerParameter)this.cloneCoverageMetric.map(MetricDescriptor::isActive));
        cloneSynchronizer.setTriggerParameter("report-cross-component-clones", this.crossComponentCloneFinding.isActive());
        cloneSynchronizer.setTriggerParameter("report-intra-component-clones", this.intraComponentCloneFinding.isActive());
        cloneSynchronizer.setTriggerParameter("exclusive-intra-component-detection", this.exclusiveIntraComponentDetection);
        if (this.isCrossComponentCloneDetectionEnabled()) {
            cloneSynchronizer.setTriggerParameter("cross-component-clones-architecture", this.crossComponentArchitectureFilename);
        }
        proxy.createTrigger(cloneSynchronizer);
    }

    private boolean isCrossComponentCloneDetectionEnabled() {
        return this.crossComponentCloneCoverageMetric.isActive() || this.crossComponentCloneFinding.isActive() || this.intraComponentCloneFinding.isActive() || this.intraComponentCloneCoverageMetric.isActive();
    }

    private void createCloneCoverageMetrics(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        MetricSchemaProxy schema = proxy.getCodeMetricSchema();
        boolean cloneCoverageMetricActiveInAnyScope = this.cloneCoverageMetricActiveInAnyScope();
        if (cloneCoverageMetricActiveInAnyScope || this.crossComponentCloneCoverageMetric.isActive() || this.intraComponentCloneCoverageMetric.isActive()) {
            schema.addNumericMetric("units", "Units", "Number of Units", MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.SIZE_METRIC, EMetricProperty.HIDDEN});
        }
        if (cloneCoverageMetricActiveInAnyScope) {
            schema.addNumericMetric("cloned-units", "Cloned Units", "Number of units that are part of at least one clone", MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.HIDDEN});
            schema.addMetric("clone-coverage", schema.createDivisionMetricSource("cloned-units", "units", this.getScopesWithDisabledCloneCoverageMetric()), CLONE_COVERAGE_METRIC_NAME, "The relative amount of statements covered by at least one clone.", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.NONE, new EMetricProperty[]{EMetricProperty.RATIO_METRIC});
        }
        if (this.crossComponentCloneCoverageMetric.isActive()) {
            CloningConfiguration.addCrossComponentCloneCoverageMetric(schema);
        }
        if (this.intraComponentCloneCoverageMetric.isActive()) {
            CloningConfiguration.addIntraComponentCloneCoverageMetric(schema);
        }
    }

    private static void addIntraComponentCloneCoverageMetric(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addNumericMetric("intra-component-cloned-units", "Intra Component Cloned Units", "Number of units that are part of at least one intra component clone", MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.HIDDEN});
        schema.addMetric("intra-component-clone-clone-coverage", schema.createDivisionMetricSource("intra-component-cloned-units", "units"), INTRA_COMPONENT_CLONE_COVERAGE_METRIC_NAME, "The relative amount of statements covered by at least one intra component clone.", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.NONE, new EMetricProperty[]{EMetricProperty.RATIO_METRIC});
    }

    private static void addCrossComponentCloneCoverageMetric(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addNumericMetric("cross-component-cloned-units", "Cross Component Cloned Units", "Number of units that are part of at least one cross component clone", MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.HIDDEN});
        schema.addMetric("cross-component-clone-clone-coverage", schema.createDivisionMetricSource("cross-component-cloned-units", "units"), CROSS_COMPONENT_CLONE_COVERAGE_METRIC_NAME, "The relative amount of statements covered by at least one cross component clone.", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.NONE, new EMetricProperty[]{EMetricProperty.RATIO_METRIC});
    }

    private static void createIndexes(ProjectCreationProxy proxy) {
        proxy.createProjectIndex(CloneChunkByPathIndex.class);
        proxy.createProjectIndex(CloneChunkByHashIndex.class);
        proxy.createProjectIndex(CloneListIndex.class);
        proxy.createProjectIndex(CloneClassIndex.class);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        CodeScopeName scopeName = (CodeScopeName)Verify.verifyNotNull((Object)template.getCodeScope(), (String)"Code scope name must not be null", (Object[])new Object[0]);
        this.autoExpose(scopeName);
        template.registerConfiguration((AnalysisConfigurationBase)this);
        if (!IndexBasedAnalysisConstants.containsCodeLanguage(languages) && !CloneWiaUtils.containsSupportedLanguage(languages) || IndexBasedAnalysisConstants.allLanguagesHaveStructuringAndCloningDisabled(languages)) {
            return;
        }
        if (languages.size() == 1 && languages.contains(ELanguage.COBOL)) {
            this.codeCloneMinLength = 20;
        }
        if (IndexBasedAnalysisConstants.containsCodeLanguage(languages)) {
            this.registerConfigurationItemsForCodeLanguages(template, scopeName);
        }
        if (CloneWiaUtils.containsSupportedLanguage(languages)) {
            this.registerConfigurationItemsForSpecItems(template, scopeName);
        }
    }

    private void registerConfigurationItemsForCodeLanguages(ConfigurationTemplate template, CodeScopeName scopeName) {
        FindingDescriptor scopedCloneFinding = (FindingDescriptor)this.cloneFinding.getValue(scopeName);
        scopedCloneFinding.declareCodeScopeAware();
        MetricDescriptor scopedCloneCoverageMetric = (MetricDescriptor)this.cloneCoverageMetric.getValue(scopeName);
        scopedCloneCoverageMetric.declareCodeScopeAware();
        List<ConfigurationItemBase> items = Arrays.asList(this.getOptionForField("codeCloneMinLength", scopeName), this.getOptionForField("codeCloneClassSizeLimit", scopeName), this.getOptionForField("allowCodeGaps", scopeName), this.getOptionForField("ignoreCodePatternList", scopeName), this.getOptionForField("crossComponentArchitectureFilename", scopeName), this.getOptionForField("exclusiveIntraComponentDetection", scopeName), scopedCloneCoverageMetric, this.crossComponentCloneCoverageMetric, this.intraComponentCloneCoverageMetric, scopedCloneFinding, this.crossComponentCloneFinding, this.intraComponentCloneFinding);
        template.registerConfigurationItems("Code Clones", "Redundancy", items, true);
    }

    private void registerConfigurationItemsForSpecItems(ConfigurationTemplate template, CodeScopeName scopeName) {
        List<ConfigurationItemBase> items = Arrays.asList(this.getOptionForField("specItemCloneMinLength", scopeName), this.getOptionForField("specItemCloneClassSizeLimit", scopeName), this.getOptionForField("allowSpecItemGaps", scopeName), this.getOptionForField("includeClosedSpecItems", scopeName), this.getOptionForField("ignoreSpecItemPatternList", scopeName), this.specificationCloneFinding);
        template.registerConfigurationItems("Specification Clones", "Redundancy", items, true);
    }

    public boolean isCoreConfiguration() {
        return true;
    }

    public List<Class<? extends AnalysisConfigurationBase>> getRequiredConfigurations() {
        return Collections.singletonList(CoreConfiguration.class);
    }
}

