/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreator;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.index.GlobalSchemaRegistry;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.index.configuration.AnalysisProfileValidationResult;
import com.teamscale.index.project.ExternalCodeMetricsDescriptionIndex;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.project.ExternalMetricsDescriptionIndexBase;
import com.teamscale.index.project.ExternalNonCodeMetricsDescriptionIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.cache.StorageCacheRegistry;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.distribution.LocalMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStorageSystemProvider;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ProjectValidationUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final PublicProjectId DUMMY_PROJECT_ID = new PublicProjectId("test");
    private static final AnalysisProfile DUMMY_ANALYSIS_PROFILE = new AnalysisProfile("test-profile", EnumSet.allOf(ELanguage.class), (Set)CollectionUtils.emptySet());

    public static void validateAnalysisProfile(AnalysisProfile analysisProfile, GlobalStorageSystem globalStorageSystem, boolean validateTools) throws StorageException {
        ProjectValidationUtils.validateAnalysisProfiles(List.of(analysisProfile), globalStorageSystem, validateTools);
    }

    public static @Nullable AnalysisProfileValidationResult validateAnalysisProfiles(List<AnalysisProfile> analysisProfiles, GlobalStorageSystem globalStorageSystem, boolean validateTools) throws StorageException {
        try {
            ProjectValidationUtils.createDummyProject(analysisProfiles, null, globalStorageSystem, validateTools);
        }
        catch (TriggerCompilationException e) {
            String errorMessage = ProjectValidationUtils.getErrorMessage(analysisProfiles, (Exception)((Object)e));
            LOGGER.error(errorMessage, (Throwable)e);
            throw new StorageException(errorMessage, (Throwable)e);
        }
        catch (ProjectConfigurationException e) {
            if (e.getCodeScopeViolations() != null && !e.getCodeScopeViolations().isEmpty()) {
                return AnalysisProfileValidationResult.from(e);
            }
            String errorMessage = ProjectValidationUtils.getErrorMessage(analysisProfiles, (Exception)((Object)e));
            LOGGER.error(errorMessage, (Throwable)e);
            throw new StorageException(errorMessage, (Throwable)e);
        }
        return null;
    }

    private static @NonNull String getErrorMessage(List<AnalysisProfile> analysisProfiles, Exception e) {
        return "Error validating analysis profiles '" + String.join((CharSequence)", ", analysisProfiles.stream().map(NamedConfigurableObjectBase::getName).collect(Collectors.toSet())) + "': " + e.getMessage();
    }

    public static void validateMetricThresholdConfiguration(MetricThresholdConfiguration metricThresholdConfiguration, GlobalStorageSystem globalStorageSystem) throws StorageException {
        Objects.requireNonNull(metricThresholdConfiguration, "metricThresholdConfiguration");
        try {
            ProjectValidationUtils.createDummyProject(List.of(DUMMY_ANALYSIS_PROFILE), metricThresholdConfiguration, globalStorageSystem, false);
        }
        catch (ProjectConfigurationException | TriggerCompilationException e) {
            LOGGER.error((Object)e);
            String message = "Metric threshold configuration '" + metricThresholdConfiguration.getName() + "' is not consistent: " + e.getMessage();
            throw new BadRequestException(message, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build(), e);
        }
    }

    public static IndexLayer createDummyProject(List<AnalysisProfile> analysisProfiles, @Nullable MetricThresholdConfiguration metricThresholdConfiguration, GlobalStorageSystem globalStorageSystem, boolean validateTools) throws StorageException, TriggerCompilationException, ProjectConfigurationException {
        LocalMessageBroker messageBroker = new LocalMessageBroker();
        IndexLayer dummyIndexLayer = new IndexLayer((IStorageSystemProvider)new InMemoryStorageSystemProvider(), StorageCacheRegistry.createCacheProvider((IMessageBroker)messageBroker), (IMessageBroker)messageBroker);
        dummyIndexLayer.saveGlobalIndexSchema(GlobalSchemaRegistry.getInstance().getSchema());
        ProjectValidationUtils.copyExternalFindingsAndMetricsToIndex(dummyIndexLayer, globalStorageSystem);
        ProjectValidationUtils.createDummyProject(dummyIndexLayer, analysisProfiles, metricThresholdConfiguration, validateTools);
        return dummyIndexLayer;
    }

    private static void copyExternalFindingsAndMetricsToIndex(IndexLayer dummyIndexLayer, GlobalStorageSystem globalStorageSystem) throws StorageException {
        GlobalStorageSystem dummySchemaAwareStorageSystem = dummyIndexLayer.openGlobalStorageSystem();
        ProjectValidationUtils.copyExternalFindingsIndex(ExternalFindingsGroupDescriptionIndex.class, globalStorageSystem, dummySchemaAwareStorageSystem);
        ProjectValidationUtils.copyExternalMetricsIndex(ExternalCodeMetricsDescriptionIndex.class, globalStorageSystem, dummySchemaAwareStorageSystem);
        ProjectValidationUtils.copyExternalMetricsIndex(ExternalNonCodeMetricsDescriptionIndex.class, globalStorageSystem, dummySchemaAwareStorageSystem);
    }

    private static void copyExternalFindingsIndex(Class<ExternalFindingsGroupDescriptionIndex> indexClass, GlobalStorageSystem source, GlobalStorageSystem target) throws StorageException {
        ExternalFindingsGroupDescriptionIndex sourceFindingsIndex = (ExternalFindingsGroupDescriptionIndex)source.openGlobalIndex(indexClass);
        ExternalFindingsGroupDescriptionIndex targetFindingsIndex = (ExternalFindingsGroupDescriptionIndex)target.openGlobalIndex(indexClass);
        targetFindingsIndex.copyContentFrom(sourceFindingsIndex);
    }

    private static void copyExternalMetricsIndex(Class<? extends ExternalMetricsDescriptionIndexBase> indexClass, GlobalStorageSystem source, GlobalStorageSystem target) throws StorageException {
        ExternalMetricsDescriptionIndexBase sourceMetricsIndex = (ExternalMetricsDescriptionIndexBase)source.openGlobalIndex(indexClass);
        ExternalMetricsDescriptionIndexBase targetMetricsIndex = (ExternalMetricsDescriptionIndexBase)target.openGlobalIndex(indexClass);
        targetMetricsIndex.putMetrics(sourceMetricsIndex.getAllMetrics());
    }

    private static void createDummyProject(IndexLayer dummyIndexLayer, List<AnalysisProfile> analysisProfiles, @Nullable MetricThresholdConfiguration metricThresholdConfiguration, boolean validateTools) throws StorageException, TriggerCompilationException, ProjectConfigurationException {
        ProjectValidationUtils.createDummyProject(DUMMY_PROJECT_ID.toString(), DUMMY_PROJECT_ID, dummyIndexLayer, analysisProfiles, metricThresholdConfiguration, validateTools);
    }

    public static void createDummyProject(String name, PublicProjectId primaryId, IndexLayer dummyIndexLayer, List<AnalysisProfile> analysisProfiles, @Nullable MetricThresholdConfiguration metricThresholdConfiguration, PublicProjectId secondaryId, boolean validateTools) throws StorageException, TriggerCompilationException, ProjectConfigurationException {
        dummyIndexLayer.saveGlobalIndexSchema(GlobalSchemaRegistry.getInstance().getSchema());
        ArrayList<PublicProjectId> publicIds = new ArrayList<PublicProjectId>();
        publicIds.add(primaryId);
        if (secondaryId != null) {
            publicIds.add(secondaryId);
        }
        ProjectConfiguration dummyProjectConfiguration = ProjectValidationUtils.createDummyProjectConfiguration(name, publicIds, analysisProfiles);
        if (metricThresholdConfiguration != null) {
            dummyProjectConfiguration.setMetricThresholdConfiguration(metricThresholdConfiguration);
        }
        new ProjectCreator(dummyIndexLayer, ConfigurationInitializationContext.EInitializationReason.OTHER).createProject(dummyProjectConfiguration, validateTools);
    }

    public static void createDummyProject(String name, PublicProjectId id, IndexLayer indexLayer, List<AnalysisProfile> analysisProfiles, @Nullable MetricThresholdConfiguration metricThresholdConfiguration, boolean validateTools) throws StorageException, TriggerCompilationException, ProjectConfigurationException {
        ProjectValidationUtils.createDummyProject(name, id, indexLayer, analysisProfiles, metricThresholdConfiguration, null, validateTools);
    }

    public static ProjectStorageSystem getDummyProjectPartition(IndexLayer dummyIndexLayer) throws StorageException {
        return dummyIndexLayer.openProjectStorageSystem((IProjectId)DUMMY_PROJECT_ID);
    }

    public static void validateConnectorsInProject(IProjectId projectName, IndexLayer indexLayer, ConfigurationInitializationContext context) throws StorageException, ProjectConfigurationException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)projectName, (IndexLayer)indexLayer);
        HashSet<String> identifiers = new HashSet<String>();
        UnmodifiableList connectors = projectConfiguration.getConnectors();
        for (int i = 0; i < connectors.size(); ++i) {
            ConnectorConfiguration connector = (ConnectorConfiguration)connectors.get(i);
            String identifier = connector.getIdentifier();
            if (identifier != null && !identifiers.add(identifier)) {
                throw new ProjectConfigurationException("Duplicate identifier in connectors: " + identifier);
            }
            ConnectorUtils.loadAndValidateConnector((ConnectorConfiguration)connector, (ConfigurationInitializationContext)context, (InternalProjectId)indexLayer.resolveToInternalProjectId(projectName), (Integer)i);
        }
    }

    private static ProjectConfiguration createDummyProjectConfiguration(String name, List<PublicProjectId> publicIds, List<AnalysisProfile> analysisProfiles) {
        ArrayList<CodeScope> dummyCodeScopes = new ArrayList<CodeScope>();
        ProjectConfiguration projectConfiguration = new ProjectConfiguration(name, null, null, publicIds, dummyCodeScopes, null);
        for (int i = 0; i < analysisProfiles.size() - 1; ++i) {
            AnalysisProfile analysisProfile = analysisProfiles.get(i);
            CodeScopeName codeScopeName = new CodeScopeName("code-scope-" + i);
            CodeScope dummyCodeScope = new CodeScope(null, codeScopeName, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            dummyCodeScopes.add(dummyCodeScope);
            projectConfiguration.setEmbeddedProfile(analysisProfile, codeScopeName);
        }
        AnalysisProfile analysisProfileForDefaultCodeScope = analysisProfiles.get(analysisProfiles.size() - 1);
        dummyCodeScopes.add(CodeScope.createCatchAllCodeScope(null));
        projectConfiguration.setEmbeddedProfile(analysisProfileForDefaultCodeScope, CodeScopeAware.DEFAULT_CODE_SCOPE);
        return projectConfiguration;
    }
}

