/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryIndexSynchronizer;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.configuration.RepositoryConfiguration;
import com.teamscale.index.project.ExternalNonCodeMetricsDescriptionIndex;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import com.teamscale.index.report.result.processor.ProcessStepPartitionAndPathToMetricIdMappingIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.CodeFileToCoverageReportIndex;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.CompileCommandReportContentIndex;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ContainerIndexSynchronizer;
import com.teamscale.index.resource.ContentIndexSynchronizer;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveIndex;
import com.teamscale.index.resource.GeneralReportContentIndex;
import com.teamscale.index.resource.KubernetesManifestIndex;
import com.teamscale.index.resource.PreprocessorExpansionsIndex;
import com.teamscale.index.resource.ProcessArtifactIndexes;
import com.teamscale.index.resource.SapScovReportContentIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureContainerIndexSynchronizer;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricDirectoryIndexSynchronizer;
import com.teamscale.index.resource.metrics.code_scopes.CodeScopesContainerIndexSynchronizer;
import com.teamscale.index.resource.metrics.code_scopes.CodeScopesMetricDirectoryIndexSynchronizer;
import com.teamscale.index.resource.metrics.code_scopes.CodeScopesMetricsIndexSynchronizer;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.path_lookup.PathLookupUpdater;
import com.teamscale.index.resource.reparsing_dependency.PreprocessorIncludeReparseTrigger;
import com.teamscale.index.resource.reparsing_dependency.PreprocessorIncludeReparsingDepedencyIndexSynchronizer;
import com.teamscale.index.resource.reparsing_dependency.PreprocessorIncludeReparsingDependencyIndex;
import com.teamscale.index.resource.reparsing_dependency.ReparseRequiredIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ResourceConfiguration
extends AnalysisConfigurationBase {
    private final List<MetricSchemaChangeEntry> customProcessMetrics;

    public ResourceConfiguration(GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException {
        try {
            ExternalNonCodeMetricsDescriptionIndex processMetricsDescriptionIndex = (ExternalNonCodeMetricsDescriptionIndex)globalStorageSystem.openGlobalIndex(ExternalNonCodeMetricsDescriptionIndex.class);
            this.customProcessMetrics = processMetricsDescriptionIndex.getAllMetrics();
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
        this.autoExpose();
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        ResourceConfiguration.configureResourceIndexes(proxy);
        ResourceConfiguration.configureMetricIndexes(proxy);
        ResourceConfiguration.configureTriggers(proxy);
        this.configureProcessArtifactSupport(proxy);
        ResourceConfiguration.configureCppReanalysisOnHeaderChangeSupport(proxy);
    }

    private static void configureResourceIndexes(ProjectCreationProxy proxy) {
        proxy.createProjectIndex(BasicTokenElementIndex.class);
        proxy.createProjectIndex(CodeScopesMappingIndex.class);
        proxy.createProjectIndex(TokenElementIndex.class, "content");
        proxy.createProjectIndex(TokenElementLineInfoIndex.class);
        proxy.createProjectIndex(PreprocessorExpansionsIndex.class);
        proxy.createProjectIndex(BinaryElementIndex.class);
        proxy.createProjectIndex(ContainerIndex.class, "dir");
        proxy.createProjectIndex(ExtendedResourceTypeIndex.class);
        proxy.createProjectIndex(GeneralReportContentIndex.class);
        proxy.createProjectIndex(CompileCommandReportContentIndex.class);
        proxy.createProjectIndex(SapScovReportContentIndex.class);
        proxy.createProjectIndex(CompileCommandIndex.class);
        proxy.createProjectIndex(CodeFileToCoverageReportIndex.class);
        proxy.createProjectIndex(KubernetesManifestIndex.class);
        proxy.createProjectIndex(PathLookupIndex.class);
        proxy.createProjectIndex(ExternalAnalysisReportArchiveIndex.class);
    }

    private static void configureMetricIndexes(ProjectCreationProxy proxy) {
        proxy.createProjectIndex(MetricsIndex.class, "architecture-metrics");
        proxy.createProjectIndex(MetricsIndex.class, "code-scopes-metrics");
    }

    private static void configureTriggers(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createTrigger(new TriggerBuilder(ContentIndexSynchronizer.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(ContainerIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.CHEAP));
        proxy.createTrigger(new TriggerBuilder(ArchitectureContainerIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.CHEAP));
        proxy.createTrigger(new TriggerBuilder(ArchitectureMetricDirectoryIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.CHEAP));
        proxy.createTrigger(new TriggerBuilder(CodeScopesContainerIndexSynchronizer.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(CodeScopesMetricDirectoryIndexSynchronizer.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(PathLookupUpdater.class, ETriggerConcurrency.PARALLEL).setCost(ETriggerCost.CHEAP));
        proxy.createTrigger(new TriggerBuilder(CodeScopesMetricsIndexSynchronizer.class, ETriggerConcurrency.PARALLEL));
    }

    private void configureProcessArtifactSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(ProcessArtifactIndexes.PROCESS_ARTIFACT_INDEX_TYPE, "process-artifacts");
        proxy.createProjectIndex(ProcessStepPartitionAndPathToMetricIdMappingIndex.class);
        proxy.createProjectIndex(ProcessArtifactIndexes.PROCESS_ARTIFACT_DIRECTORY_INDEX_TYPE, "process-dir");
        proxy.createProjectIndex(ProcessArtifactIndexes.PROCESS_METRICS_INDEX_TYPE, "process-metrics");
        proxy.createProjectIndex(ProcessArtifactIndexes.PROCESS_METRIC_SCHEMA_INDEX_TYPE, "process-metric-schema");
        proxy.createProjectIndex(ProcessArtifactIndexes.PROCESS_METRICS_DIRECTORY_INDEX_TYPE, "process-metrics-dir");
        proxy.createProjectIndex(ProcessArtifactIndexes.PROCESS_METRICS_TREND_INDEX_TYPE, "process-metric-trend");
        TriggerBuilder containerIndexSynchronizerTrigger = new TriggerBuilder(ContainerIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.CHEAP);
        containerIndexSynchronizerTrigger.renameIndex("content", "process-artifacts");
        containerIndexSynchronizerTrigger.renameIndex("dir", "process-dir");
        proxy.createTrigger(containerIndexSynchronizerTrigger, "process");
        TriggerBuilder processDirSynchronizer = new TriggerBuilder(MetricDirectoryIndexSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED);
        processDirSynchronizer.renameIndex("metrics", "process-metrics");
        processDirSynchronizer.renameIndex("metrics-dir", "process-metrics-dir");
        processDirSynchronizer.renameIndex("metric-trend", "process-metric-trend");
        processDirSynchronizer.renameIndex("metric-schema", "process-metric-schema");
        processDirSynchronizer.setTriggerParameter("use-hidden-metrics-index", false);
        processDirSynchronizer.setCost(ETriggerCost.CHEAP);
        proxy.createTrigger(processDirSynchronizer, "process");
        this.configureProcessMetrics(proxy.getProcessMetricSchema());
    }

    private void configureProcessMetrics(MetricSchemaProxy schema) throws ProjectConfigurationException {
        for (MetricSchemaChangeEntry customProcessMetric : this.customProcessMetrics) {
            MetricDirectorySchemaEntry entry = customProcessMetric.getMetricDirectoryEntry();
            schema.addMetric(customProcessMetric.getMetricId(), schema.createMetricIndexSource(customProcessMetric.getMetricId()), entry.getName(), entry.getDescription(), entry.getValueType(), entry.getAggregation(), entry.getProperties().toArray(new EMetricProperty[0]));
        }
    }

    private static void configureCppReanalysisOnHeaderChangeSupport(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(ReparseRequiredIndex.class);
        if (CollectionUtils.intersectionSet((Collection)proxy.getAllConfiguredLanguages(), (Collection[])new Collection[]{PreprocessorIncludeReparseTrigger.RELEVANT_LANGUAGES}).isEmpty()) {
            return;
        }
        proxy.createProjectIndex(PreprocessorIncludeReparsingDependencyIndex.class);
        if (EFeatureToggle.CPP_DISABLE_REPARSE_ON_HEADER_CHANGE.isEnabled()) {
            return;
        }
        proxy.createTrigger(new TriggerBuilder(PreprocessorIncludeReparseTrigger.class, ETriggerConcurrency.PARALLEL));
        proxy.createTrigger(new TriggerBuilder(PreprocessorIncludeReparsingDepedencyIndexSynchronizer.class, ETriggerConcurrency.PARALLEL));
    }

    public boolean isCoreConfiguration() {
        return true;
    }

    public List<Class<? extends AnalysisConfigurationBase>> getRequiredConfigurations() {
        return List.of(RepositoryConfiguration.class);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) {
        template.registerConfiguration((AnalysisConfigurationBase)this);
    }
}

