/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.configuration.StructuringConfiguration;
import com.teamscale.index.external.update.ExternalUploadChangeRetrieverBase;
import com.teamscale.index.reviews.ElementReviewChangePersister;
import com.teamscale.index.reviews.ElementReviewChangeRetriever;
import com.teamscale.index.reviews.ElementReviewStatusIndex;
import com.teamscale.index.reviews.ElementReviewUploadIndex;
import com.teamscale.index.reviews.ReviewRatingSynchronizer;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;

public class ReviewAnalysisConfiguration
extends AnalysisConfigurationBase {
    private static final String REVIEW_COMMENT_FINDING_NAME = "Review Comment Findings";
    public static final String REVIEW_COMMENT_FINDING_PARTITION = "code-review-findings";
    public static final String REVIEW_COMMENT_FINDING_GROUP = "Review Comment";
    public static final String CODE_REVIEW_FINDING_CATEGORY = "Code Review";
    private final MetricDescriptor ratingMetric = new MetricDescriptor("Review Rating", "Assessment metric for a file-based review rating.", false);
    private final FindingDescriptor codeReviewFinding = new FindingDescriptor("Review Comment Findings", EAnalysisTool.TEAMSCALE, EnumSet.allOf(ELanguage.class), EFindingEnablement.YELLOW, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-code-review.md").orElseThrow());

    public ReviewAnalysisConfiguration() {
        this.autoExpose();
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        if (this.ratingMetric.isMetricEnabled()) {
            TriggerBuilder triggerBuilder = new TriggerBuilder(ReviewRatingSynchronizer.class, ETriggerConcurrency.PARALLEL);
            proxy.createTrigger(triggerBuilder);
            MetricSchemaProxy schema = proxy.getCodeMetricSchema();
            schema.addMetric("rating", schema.createMetricIndexSource("rating"), "Review Rating", "Review rating assessment", EMetricValueType.ASSESSMENT, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[0]);
            proxy.createProjectIndex(ElementReviewUploadIndex.class);
            proxy.createProjectIndex(CommitTreeIndex.class, "element-review-commit-tree");
            TriggerBuilder elementReviewChangeRetrieverTriggerBuilder = ExternalUploadChangeRetrieverBase.configurePeriodicTrigger(ElementReviewChangeRetriever.class);
            proxy.createTrigger(elementReviewChangeRetrieverTriggerBuilder);
            proxy.addPostBuildCompletenessAnalysisTrigger(triggerBuilder);
            proxy.createTrigger(new TriggerBuilder(ElementReviewChangePersister.class, ETriggerConcurrency.PARALLEL));
            proxy.createProjectIndex(ElementReviewStatusIndex.class);
        }
        proxy.addFindingsSchemaEntry(CODE_REVIEW_FINDING_CATEGORY, REVIEW_COMMENT_FINDING_GROUP, this.codeReviewFinding);
        if (this.codeReviewFinding.isActive()) {
            proxy.addMetaIndexEntry((Serializable)new CodeReviewEnabledMetaIndexEntry());
        }
    }

    public List<Class<? extends AnalysisConfigurationBase>> getRequiredConfigurations() {
        return Collections.singletonList(StructuringConfiguration.class);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerConfigurationItems("Code review", null, new ArrayList<ConfigurationItemBase>(Arrays.asList(this.ratingMetric, this.codeReviewFinding)));
    }

    public static boolean isCodeReviewFindingSupportEnabled(MetaIndex metaIndex) throws StorageException {
        return metaIndex.getValue(CodeReviewEnabledMetaIndexEntry.class) != null;
    }

    private static class CodeReviewEnabledMetaIndexEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private CodeReviewEnabledMetaIndexEntry() {
        }
    }
}

