/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dashboard.templates;

import com.teamscale.index.dashboard.templates.DashboardTemplateDescriptor;
import java.util.List;
import java.util.UUID;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="dashboard-templates", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP})
public class DashboardTemplateIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "dashboard-templates";
    private final ValueIndex<DashboardTemplateDescriptor> delegateIndex;

    public DashboardTemplateIndex(IStore store) {
        this.delegateIndex = ValueIndex.forSerializable((IStore)store);
    }

    public void storeDashboardTemplate(DashboardTemplateDescriptor dashboard) throws StorageException {
        this.delegateIndex.setValue(dashboard.getId().toString(), (Object)dashboard);
    }

    public DashboardTemplateDescriptor getDashboardTemplate(UUID dashboardId) throws StorageException {
        return (DashboardTemplateDescriptor)this.delegateIndex.getValue(dashboardId.toString());
    }

    public List<DashboardTemplateDescriptor> getAllDashboardTemplates() throws StorageException {
        return this.delegateIndex.getAllEntries().extractSecondList();
    }

    public void removeDashboardTemplate(UUID dashboardId) throws StorageException {
        this.delegateIndex.removeValue(dashboardId.toString());
    }
}

