/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.cs;

import com.teamscale.index.dataflow.controlflowgraph.VariableDereferenceInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.clike.CLikeDefUseHeuristicBase;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.cs.CsCheckUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStreamParser;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.enums.EnumUtils;

public class CsDefUseHeuristic
extends CLikeDefUseHeuristicBase {
    public static final UnmodifiableSet<ETokenType> DEREFERENCE_OPERATORS = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.DOT, ETokenType.ARROW, ETokenType.LBRACK, ETokenType.LPAREN, ETokenType.SAFECALL_OPERATOR));
    private static final TokenPattern NULL_COALESCING_ASSIGNMENT = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.DOUBLE_QUESTION, ETokenType.EQ});
    private static final TokenPattern FUNCTOR_READ_PATTERN = new TokenPattern().notPrecededBy((Object)ETokenType.DOT).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.LPAREN});
    private static final TokenPattern POINTER_OR_FUNCTOR_DEREFERENCE_PATTERN = new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.MULT}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).notFollowedBy(DEREFERENCE_OPERATORS), new TokenPattern().notPrecededBy(DEREFERENCE_OPERATORS).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.LPAREN})});
    private static final TokenPattern ANONYMOUS_CLASS_INIT_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.NEW}).repeated(new Object[]{EnumSet.of(ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.COLON)}).skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, true).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true).skipNested((Object)ETokenType.LBRACE, (Object)ETokenType.RBRACE, false).group(0);
    private static final UnmodifiableSet<ETokenType> PRIMITIVE_TYPES = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.BOOL, new ETokenType[]{ETokenType.BYTE, ETokenType.CHAR, ETokenType.DECIMAL, ETokenType.DOUBLE, ETokenType.ENUM, ETokenType.FLOAT, ETokenType.INT, ETokenType.LONG, ETokenType.SBYTE, ETokenType.SHORT, ETokenType.UINT, ETokenType.ULONG, ETokenType.USHORT, ETokenType.STRING, ETokenType.OBJECT, ETokenType.DYNAMIC, ETokenType.VAR}));
    private static final UnmodifiableSet<ETokenType> TYPES = CollectionUtils.asUnmodifiable((Set)EnumUtils.mergeSets(PRIMITIVE_TYPES, (Enum[])new ETokenType[]{ETokenType.IDENTIFIER}));
    private static final TokenPattern OUT_REF_PARAMETER_PATTERN = new TokenPattern().sequence(new Object[]{EnumSet.of(ETokenType.OUT, ETokenType.REF)}).group(1).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).notFollowedBy(DEREFERENCE_OPERATORS);
    private static final TokenPattern OUT_VARIABLE_DECLARATION = new TokenPattern().sequence(new Object[]{ETokenType.OUT, TYPES}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);
    private static final TokenPattern IS_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.IS}).sequence(new Object[]{TYPES}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);
    private static final UnmodifiableSet<ETokenType> GENERICS_CONTENT = CollectionUtils.asUnmodifiable((Set)EnumUtils.mergeSets(PRIMITIVE_TYPES, (Enum[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.QUESTION, ETokenType.DOT, ETokenType.COMMA, ETokenType.SUPER, ETokenType.EXTENDS, ETokenType.AND, ETokenType.LBRACK, ETokenType.RBRACK, ETokenType.AT, ETokenType.COLON, ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.GLOBAL}));
    private static final UnmodifiableSet<ETokenType> TYPE_MODIFIERS = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.QUESTION, new ETokenType[]{ETokenType.MULT, ETokenType.THIS, ETokenType.PARAMS, ETokenType.OUT, ETokenType.REF, ETokenType.USING}));
    private static final TokenPattern GENERIC_TYPE = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).repeated(new Object[]{ETokenType.COLON, ETokenType.COLON, ETokenType.IDENTIFIER}).repeated(new Object[]{new TokenPattern().repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, false)}).repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER});
    private static final TokenPattern OUT_REF_FORMAL_PARAMETER_PATTERN = new TokenPattern().alternative(new Object[]{ETokenType.OUT, ETokenType.REF}).group(1).alternative(new Object[]{PRIMITIVE_TYPES, GENERIC_TYPE}).skipTo(new Object[]{ETokenType.IDENTIFIER}).group(0);
    public static final UnmodifiableSet<ETokenType> NOT_ALLOWED_BEFORE_IDENTIFIER = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.DOT, ETokenType.ARROW, ETokenType.SAFECALL_OPERATOR));
    private static final Pattern STRING_INTERPOLATION_LITERAL_SEPARATORS = Pattern.compile("[?:.,()]");

    public CsDefUseHeuristic() {
        super((Set<ETokenType>)TYPE_MODIFIERS, (Set<ETokenType>)PRIMITIVE_TYPES, (Set<ETokenType>)GENERICS_CONTENT, (Set<ETokenType>)DEREFERENCE_OPERATORS, (Set<ETokenType>)NOT_ALLOWED_BEFORE_IDENTIFIER);
    }

    @Override
    protected int skipAnnotations(TokenStreamParser parser) {
        int count = 0;
        while (parser.isAnyOf(EnumSet.of(ETokenType.LBRACK)) && !CsDefUseHeuristic.isArrayType(parser)) {
            ++count;
            if (((Boolean)parser.skipBalanced(ETokenType.LBRACK, ETokenType.RBRACK, EnumSet.complementOf(EnumSet.of(ETokenType.LBRACK, ETokenType.RBRACK))).getFirst()).booleanValue()) continue;
            return -1;
        }
        return count;
    }

    private static boolean isArrayType(TokenStreamParser parser) {
        int position = parser.getConsumedTokenCount();
        try {
            if (parser.consumeOneOrZeroOf(ETokenType.LBRACK).isPresent()) {
                parser.consumeAnyOf((ITokenMatcher)ETokenType.COMMA);
                boolean bl = parser.consumeOneOrZeroOf(ETokenType.RBRACK).isPresent();
                return bl;
            }
        }
        finally {
            parser.resetToPosition(position);
        }
        return false;
    }

    @Override
    protected List<String> parseReads(List<IToken> tokens) {
        List<String> reads = super.parseReads(tokens);
        List matches = FUNCTOR_READ_PATTERN.findAll(tokens);
        for (TokenPatternMatch match : matches) {
            String variable = match.groupString(0);
            if (!this.isKnownVariableName(variable)) continue;
            reads.add(variable);
        }
        tokens.stream().filter(token -> token.getType() == ETokenType.STRING_LITERAL).flatMap(this::findInterpolatedReads).forEach(reads::add);
        return reads;
    }

    private Stream<String> findInterpolatedReads(IToken stringLiteral) {
        if (!stringLiteral.getText().startsWith("$") && !stringLiteral.getText().startsWith("@$")) {
            return Stream.empty();
        }
        Matcher matcher = CsCheckUtils.getInterpolatedStringMatcher((String)stringLiteral.getText());
        return matcher.results().map(matchResult -> matchResult.group(1)).flatMap(STRING_INTERPOLATION_LITERAL_SEPARATORS::splitAsStream).map(String::trim).filter(this::isKnownVariableName);
    }

    @Override
    protected VariableDereferenceInfo parseDereferences(List<IToken> tokens) {
        VariableDereferenceInfo dereferences = super.parseDereferences(tokens);
        List matches = POINTER_OR_FUNCTOR_DEREFERENCE_PATTERN.findAll(tokens);
        for (TokenPatternMatch match : matches) {
            String variable;
            if (CsDefUseHeuristic.indexIsInOperator(tokens, (Integer)match.groupIndices(0).get(0), "nameof") || !this.isKnownVariableName(variable = match.groupString(0))) continue;
            dereferences.addDereference(match, 0);
        }
        return dereferences;
    }

    @Override
    protected boolean isActualVariableDereference(List<IToken> tokens, int potentialDereferencedVariableIndex) {
        return !CsDefUseHeuristic.indexIsInOperator(tokens, potentialDereferencedVariableIndex, "nameof");
    }

    @Override
    protected List<String> parseAssignmentsAndDefinitions(List<IToken> tokens, VariableReadWriteInfo info) {
        tokens = CsDefUseHeuristic.filterAnonymousClassInits(tokens);
        ArrayList<String> writtenAndNotReadVariables = new ArrayList<String>(super.parseAssignmentsAndDefinitions(tokens, info));
        this.parseOutAndRefParameters(tokens, info, writtenAndNotReadVariables);
        this.parseEmptyVariableDeclarations(tokens, info, writtenAndNotReadVariables, OUT_VARIABLE_DECLARATION);
        this.parseEmptyVariableDeclarations(tokens, info, writtenAndNotReadVariables, IS_PATTERN);
        this.parseNullCoalescingVariableAssignment(tokens, info, writtenAndNotReadVariables);
        return writtenAndNotReadVariables;
    }

    private void parseNullCoalescingVariableAssignment(List<IToken> tokens, VariableReadWriteInfo info, List<String> writtenAndNotReadVariables) {
        for (TokenPatternMatch match : NULL_COALESCING_ASSIGNMENT.findAll(tokens)) {
            String variable = match.groupString(0);
            if (!this.isKnownVariableName(variable)) continue;
            info.getAssignments().add(this.parseNormalAssignment(variable, tokens.subList(3, tokens.size() - 1)));
            info.getReads().add(variable);
            writtenAndNotReadVariables.add(variable);
        }
    }

    private void parseEmptyVariableDeclarations(List<IToken> tokens, VariableReadWriteInfo info, List<String> writtenAndNotReadVariables, TokenPattern pattern) {
        for (TokenPatternMatch match : pattern.findAll(tokens)) {
            this.parseEmptyDefinition(match.groupTokens(0), info, writtenAndNotReadVariables);
        }
    }

    private void parseOutAndRefParameters(List<IToken> tokens, VariableReadWriteInfo info, List<String> writtenAndNotReadVariables) {
        List matches = OUT_REF_PARAMETER_PATTERN.findAll(tokens);
        for (TokenPatternMatch match : matches) {
            String variable = match.groupString(0);
            if (!this.isKnownVariableName(variable)) continue;
            info.getAssignments().add(new VariableWrite(variable));
            if (((IToken)match.groupTokens(1).get(0)).getType() != ETokenType.OUT) continue;
            writtenAndNotReadVariables.add(variable);
        }
    }

    private static List<IToken> filterAnonymousClassInits(List<IToken> tokens) {
        ArrayList<IToken> filteredTokens = new ArrayList<IToken>(tokens);
        List matches = ANONYMOUS_CLASS_INIT_PATTERN.findAll(tokens);
        filteredTokens.removeAll(TokenPatternMatch.getAllTokens((List)matches, (int)0));
        return filteredTokens;
    }

    @Override
    public VariableReadWriteInfo parseParameterList(List<IToken> parameterListTokens, ShallowEntity methodEntity) {
        boolean mustContainTypes = methodEntity.getName() != null;
        VariableReadWriteInfo info = super.parseParameterList(parameterListTokens, methodEntity, mustContainTypes);
        List matches = OUT_REF_FORMAL_PARAMETER_PATTERN.findAll(parameterListTokens);
        List outRefParameters = TokenPatternMatch.getAllStrings((List)matches, (int)0);
        for (VariableWrite write : info.getDefinitions()) {
            if (!outRefParameters.contains(write.getChangedVariable())) continue;
            write.makeDefaultInitialization();
        }
        return info;
    }

    @Override
    public VariableReadWriteInfo parseStatement(List<IToken> tokens) {
        VariableReadWriteInfo info = super.parseStatement(tokens);
        for (VariableWrite write : info.getDefinitions()) {
            info.getDereferenceInfo().removeDereference(write.getChangedVariable());
        }
        return info;
    }
}

