/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CodeLabelRule
implements IControlFlowRule {
    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        IControlFlowRule.Result result;
        ShallowEntity entity = entities.get(0);
        UnmodifiableList tokens = entity.includedTokens();
        String labelName = ((IToken)tokens.get(0)).getText();
        ControlFlowNode labelNode = context.createNode((List<IToken>)tokens, false);
        context.getCodeLabelManager().addJumpTargetNode(labelName, labelNode);
        if (entities.size() == 1) {
            return new IControlFlowRule.Result(1, labelNode, Collections.singletonList(labelNode));
        }
        int consumedEntities = 1;
        do {
            List<ShallowEntity> remainingEntities;
            if ((result = creator.transformOneStep(remainingEntities = entities.subList(consumedEntities, entities.size()))) != null) {
                consumedEntities += result.getNumberOfConsumedEntities();
                continue;
            }
            ++consumedEntities;
        } while (result == null && consumedEntities < entities.size());
        if (result == null) {
            return new IControlFlowRule.Result(entities.size(), labelNode, Collections.singletonList(labelNode));
        }
        ControlFlowNode.link(labelNode, result.getEntryNode());
        ControlFlowNode afterLabelledBlockNode = context.createSyntheticNode();
        context.getCodeLabelManager().addJumpTargetNode("after\u0000" + labelName, afterLabelledBlockNode);
        for (ControlFlowNode exitNode : result.getExitNodes()) {
            ControlFlowNode.link(exitNode, afterLabelledBlockNode);
        }
        return new IControlFlowRule.Result(consumedEntities, labelNode, Collections.singletonList(afterLabelledBlockNode));
    }
}

