/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.nullpointer;

import com.google.common.collect.ImmutableMap;
import com.teamscale.index.dataflow.DataFlowGraph;
import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.EDirection;
import com.teamscale.index.dataflow.IDataFlowGraph;
import com.teamscale.index.dataflow.IDataflowFindingsCreator;
import com.teamscale.index.dataflow.ILattice;
import com.teamscale.index.dataflow.PathSensitiveAnalysisState;
import com.teamscale.index.dataflow.PathSensitiveDataflowAnalysisBase;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.dataflow.nullpointer.NullPointerFindingCreationAnalysis;
import com.teamscale.index.dataflow.nullpointer.NullPointerFindingsCreationUtils;
import com.teamscale.index.dataflow.nullpointer.NullPointerLattice;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class NullPointerAnalysis
extends PathSensitiveDataflowAnalysisBase<NullPointerLattice.ENullness> {
    private static final Set<String> C_AND_CPP_NULL_POINTER_RETURNING_FUNCTIONS = CollectionUtils.asHashSet((Object[])new String[]{"malloc"});
    private static final Set<String> JAVA_NON_NULL_ASSERTIONS = CollectionUtils.asHashSet((Object[])new String[]{"requireNonNull", "checkNotNull"});
    private static final Set<String> CS_NON_NULL_ASSERTIONS = CollectionUtils.asHashSet((Object[])new String[]{"IsNullOrWhiteSpace", "IsNullOrEmpty", "IsNotNull"});

    @Override
    public EDirection getDirection() {
        return EDirection.FORWARD;
    }

    @Override
    protected IDataFlowGraph createDataFlowGraph(ControlFlowGraph controlFlowGraph) {
        return new DataFlowGraph(controlFlowGraph);
    }

    @Override
    protected ImmutableMap<String, NullPointerLattice.ENullness> transformValues(ControlFlowNode block, PathSensitiveAnalysisState<NullPointerLattice.ENullness> state) {
        NullPointerLattice.ENullness previousNullnessOfAssignedVariable;
        ImmutableMap<String, NullPointerLattice.ENullness> previousState = state.getValueState();
        HashMap<String, NullPointerLattice.ENullness> changedNullnessValues = new HashMap<String, NullPointerLattice.ENullness>();
        for (VariableWrite assignment : block.getReadWriteInfo().getAllWrites()) {
            if (assignment.isWriteToDereferencedAddress()) continue;
            previousNullnessOfAssignedVariable = (NullPointerLattice.ENullness)((Object)previousState.get((Object)assignment.getChangedVariable()));
            Optional<NullPointerLattice.ENullness> newNullnessOfAssignedVariable = this.processAssignmentValueNullness((Map<String, NullPointerLattice.ENullness>)previousState, (Map<String, NullPointerLattice.ENullness>)changedNullnessValues, assignment, block);
            if (!newNullnessOfAssignedVariable.isPresent() || previousNullnessOfAssignedVariable == newNullnessOfAssignedVariable.get()) continue;
            changedNullnessValues.put(assignment.getChangedVariable(), newNullnessOfAssignedVariable.get());
        }
        for (Pair newNullnessValue : this.processNullAssertionStatements(block)) {
            previousNullnessOfAssignedVariable = (NullPointerLattice.ENullness)((Object)previousState.get(newNullnessValue.getFirst()));
            if (newNullnessValue.getSecond() == previousNullnessOfAssignedVariable) continue;
            changedNullnessValues.put((String)newNullnessValue.getFirst(), (NullPointerLattice.ENullness)((Object)newNullnessValue.getSecond()));
        }
        if (changedNullnessValues.isEmpty()) {
            return previousState;
        }
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)previousState.size());
        builder.putAll(previousState);
        builder.putAll(changedNullnessValues);
        return builder.buildKeepingLast();
    }

    private Optional<NullPointerLattice.ENullness> processAssignmentValueNullness(Map<String, NullPointerLattice.ENullness> previousState, Map<String, NullPointerLattice.ENullness> changedNullnessValuesInCurrentStatement, VariableWrite assignment, ControlFlowNode block) throws AssertionError {
        switch (assignment.getType()) {
            case EMPTY: 
            case VALUE: {
                return Optional.of(NullPointerLattice.ENullness.NON_NULL);
            }
            case NULL: {
                return Optional.of(NullPointerLattice.ENullness.NULL);
            }
            case OTHER: {
                return Optional.of(this.getNullnessValueOfAssignedValue(assignment, block));
            }
            case VARIABLE: {
                String valueVariable = assignment.getValueVariable();
                if (changedNullnessValuesInCurrentStatement.containsKey(valueVariable)) {
                    return Optional.of(changedNullnessValuesInCurrentStatement.get(valueVariable));
                }
                return Optional.of(previousState.get(valueVariable));
            }
        }
        CCSMAssert.fail((String)("Unhandled assignment type " + String.valueOf((Object)assignment.getType())));
        return Optional.empty();
    }

    private NullPointerLattice.ENullness getNullnessValueOfAssignedValue(VariableWrite assignment, ControlFlowNode block) {
        if (!LanguageGroups.C_CPP_AND_MS_CLI.contains(this.element.getLanguage())) {
            return NullPointerLattice.ENullness.MAYBE_NULL;
        }
        List<IToken> nodeTokens = block.getTokens();
        for (Integer assignmentIndex : TokenStreamUtils.allStartingIndicesOfTypeSequence(nodeTokens, (int)0, (int)nodeTokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EQ})) {
            if (!nodeTokens.get(assignmentIndex).getText().equals(assignment.getChangedVariable()) || nodeTokens.size() <= assignmentIndex + 2) continue;
            List<IToken> assignmentValueTokens = nodeTokens.subList(assignmentIndex + 2, nodeTokens.size());
            if (TokenStreamUtils.startsWith(assignmentValueTokens, (ETokenType[])new ETokenType[]{ETokenType.AND})) {
                return NullPointerLattice.ENullness.NON_NULL;
            }
            if (NullPointerFindingsCreationUtils.isFunctionCallTo(assignmentValueTokens, C_AND_CPP_NULL_POINTER_RETURNING_FUNCTIONS)) {
                return NullPointerLattice.ENullness.NULL;
            }
            return NullPointerLattice.ENullness.MAYBE_NULL;
        }
        return NullPointerLattice.ENullness.MAYBE_NULL;
    }

    private PairList<String, NullPointerLattice.ENullness> processNullAssertionStatements(ControlFlowNode block) {
        if (this.element.getLanguage() == ELanguage.JAVA) {
            return this.processNullAssertionMethod(block, JAVA_NON_NULL_ASSERTIONS);
        }
        if (this.element.getLanguage() == ELanguage.CS) {
            return this.processNullAssertionMethod(block, CS_NON_NULL_ASSERTIONS);
        }
        return PairList.emptyPairList();
    }

    private PairList<String, NullPointerLattice.ENullness> processNullAssertionMethod(ControlFlowNode block, Set<String> requireNonNullMethodNames) {
        PairList changedNullnessValues = new PairList();
        Iterator iterator = TokenStreamUtils.firstTokenOfTypeSequences(block.getTokens(), (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN}).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (!requireNonNullMethodNames.contains(block.getTokens().get(i).getText())) continue;
            String variable = block.getTokens().get(i + 2).getText();
            if (!this.controlFlowGraph.getDefinedVariables().contains(variable)) continue;
            changedNullnessValues.add((Object)variable, (Object)NullPointerLattice.ENullness.NON_NULL);
        }
        return changedNullnessValues;
    }

    @Override
    protected ILattice<NullPointerLattice.ENullness> getLattice() {
        return NullPointerLattice.INSTANCE;
    }

    @Override
    public IDataflowFindingsCreator<DataflowAnalysisResult<String, NullPointerLattice.ENullness>> createFindingsCreator(List<IFalsePositiveFilter> filters) {
        return (element, result, fileEntities, offsetTransformer, rawLineOffsetConverter) -> {
            NullPointerFindingCreationAnalysis findingDuplicationAnalysis = new NullPointerFindingCreationAnalysis(result, fileEntities, filters);
            findingDuplicationAnalysis.analyze(element, this.controlFlowGraph, filters, fileEntities, rawLineOffsetConverter);
            return ListMap.of((Object)element.getUniformPath(), findingDuplicationAnalysis.findings);
        };
    }
}

