/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph;

import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReturnValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.IToken;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.StatementPathElement;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocationUtils;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;

public class TaintAnalysisUtils {
    public static final String ENABLE_DETAILED_TAINT_ANALYSIS_LOG_VM_PARAMETER = "com.teamscale.enableDetailedTaintAnalysisLog";
    public static final String METHOD_IDENTIFIER_DELIMITER = "#$!$#";

    public static boolean isFieldOrReturnValueForField(TaintGraphReferenceBase reference) {
        if (reference.getType() == TaintGraphReferenceBase.EReferenceType.FIELD) {
            return true;
        }
        return reference.getType() == TaintGraphReferenceBase.EReferenceType.METHOD_CALL_RETURN && ((MethodCallReturnValueReference)reference).getReturnValueType() == MethodCallReturnValueReference.EReturnParameterType.FIELD;
    }

    public static TextRegionLocation createLocationForTokens(List<IToken> tokens, TokenElementInfo element, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        return TextRegionLocationUtils.createTextRegionLocationForFilteredOffsets((String)element.getUniformPath(), (int)tokens.get(0).getOffset(), (int)tokens.get(tokens.size() - 1).getEndOffset(), (StringOffsetTransformer)offsetTransformer, (LineOffsetConverter)rawLineOffsetConverter);
    }

    static String getReferenceNameForSourceOrSink(IToken referenceToken, String variableName) {
        return StringUtils.concat((Object[])new String[]{variableName, "@", FileSystemUtils.normalizeSeparators((String)referenceToken.getOriginId()), ":", String.valueOf(referenceToken.getLineNumber() + 1)}, (String)"");
    }

    static String getReferenceNameForRfcSource(TextRegionLocation location, String variableName) {
        return StringUtils.concat((Object[])new String[]{variableName, "@", FileSystemUtils.normalizeSeparators((String)location.getUniformPath()), ":", String.valueOf(location.getRawStartLine())}, (String)"");
    }

    public static boolean detailedTaintAnalysisLoggingEnabled() {
        return Boolean.getBoolean(ENABLE_DETAILED_TAINT_ANALYSIS_LOG_VM_PARAMETER);
    }

    public static Set<StatementPathElement> getSinks(List<StatementPathElement> statementPath) {
        HashSet<Integer> potentialSinkIndices = new HashSet<Integer>();
        for (int i = 0; i < statementPath.size(); ++i) {
            potentialSinkIndices.add(i);
        }
        for (StatementPathElement pathElement : statementPath) {
            potentialSinkIndices.removeAll(pathElement.getPredecessorPathElements());
        }
        return potentialSinkIndices.stream().map(statementPath::get).collect(Collectors.toSet());
    }

    public static String buildMethodIdentifier(String uniformPath, String methodName) {
        return uniformPath + METHOD_IDENTIFIER_DELIMITER + methodName;
    }

    public static String getUniformPathFromMethodIdentifier(String methodIdentifier) {
        CCSMAssert.isTrue((boolean)methodIdentifier.contains(METHOD_IDENTIFIER_DELIMITER), () -> "Method identifier is invalid since it doesn't contain the expected delimiter '#$!$#': " + methodIdentifier);
        return StringUtils.getFirstPart((String)methodIdentifier, (String)METHOD_IDENTIFIER_DELIMITER);
    }
}

