/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.teamscale.index.dependencies.TypeDependencies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Index(name="type-dependencies", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED})
public class TypeDependencyIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "type-dependencies";
    private final ValueIndex<ArrayList<TypeDependencies>> delegate;

    public TypeDependencyIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public PairList<String, ArrayList<TypeDependencies>> getAllTypeDependencies() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public @Nullable List<TypeDependencies> getTypeDependencies(String uniformPath) throws StorageException {
        return (List)this.delegate.getValue(uniformPath);
    }

    public List<TypeDependencies> getTypeDependencies(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths).stream().filter(Objects::nonNull).flatMap(Collection::stream).toList();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public PairList<String, ArrayList<TypeDependencies>> getTypeDependenciesPerUniformPath(List<String> uniformPaths) throws StorageException {
        @Nullable List values = this.delegate.getValues(uniformPaths);
        PairList result = new PairList(uniformPaths.size());
        for (int i = 0; i < uniformPaths.size(); ++i) {
            String uniformPath = uniformPaths.get(i);
            ArrayList typeDependencies = (ArrayList)values.get(i);
            if (typeDependencies == null) {
                typeDependencies = new ArrayList();
            }
            result.add(new Pair((Object)uniformPath, typeDependencies));
        }
        return result;
    }

    public void removeTypeDependencies(List<String> uniformPaths) throws StorageException {
        this.delegate.removeValues(uniformPaths);
    }

    public void setTypeDependencies(PairList<String, ArrayList<TypeDependencies>> typeDependencies) throws StorageException {
        this.delegate.setValues(typeDependencies);
    }

    public void setTypeDependencies(String uniformPath, ArrayList<TypeDependencies> typeDependencies) throws StorageException {
        this.delegate.setValue(uniformPath, typeDependencies);
    }
}

