/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.abap;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.utils.CSVParserBase;
import com.teamscale.core.utils.CsvStringListParser;
import com.teamscale.index.dependencies.abap.AbapThirdPartyPathsIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

public class AbapThirdPartyPathsSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String OBJECT_PATHS_FORMAT_FILE_EXTENSION = ".objectpaths";
    public static final String OBJECT_PATHS_DIRECTORY = "objectPaths/";
    private static final Pattern OBJECT_PATHS_FILE_PATTERN = Pattern.compile(".*objectPaths/([^.]+).objectpaths");
    public static final String OBJECT_PATHS_FORMAT_TITLE_LINE = "Teamscale object name to path format v1.";
    public static final String OBJECT_PATHS_FILE_COLUMNS_HEADER = "OBJTYPE;OBJNAME;PATH";
    @DeltaSource(value=BasicTokenElementIndex.class)
    private KeyDelta delta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex inputIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private AbapThirdPartyPathsIndex thirdPartyPathsIndex;

    public static boolean isAbapThirdPartyPathsFile(ELanguage language, String uniformPath, byte[] contents) {
        return ELanguage.LINE == language && uniformPath.endsWith(OBJECT_PATHS_FORMAT_FILE_EXTENSION) && ByteArrayUtils.isPrefix((byte[])StringUtils.stringToBytes((String)OBJECT_PATHS_FORMAT_TITLE_LINE), (byte[])contents) && OBJECT_PATHS_FILE_PATTERN.matcher(uniformPath).matches();
    }

    public static boolean isAbapThirdPartyPathsFile(ELanguage language, String uniformPath, String contents) {
        return ELanguage.LINE == language && uniformPath.endsWith(OBJECT_PATHS_FORMAT_FILE_EXTENSION) && contents.startsWith(OBJECT_PATHS_FORMAT_TITLE_LINE) && OBJECT_PATHS_FILE_PATTERN.matcher(uniformPath).matches();
    }

    public void execute() throws StorageException {
        Map<EAbapObjectType, String> deletedObjectPathFiles = AbapThirdPartyPathsSynchronizer.filterObjectPathFiles(this.delta.getDeletedKeysAsStrings());
        Set<EAbapObjectType> deletedObjectTypes = deletedObjectPathFiles.keySet();
        this.thirdPartyPathsIndex.removeEntriesForObjectTypes(deletedObjectTypes);
        LOGGER.debug("Removed all entries for deleted object path files: {}", deletedObjectTypes);
        Map<EAbapObjectType, String> addedOrChangedObjectPathFiles = AbapThirdPartyPathsSynchronizer.filterObjectPathFiles(this.delta.getAddedOrChangedKeysAsStrings());
        IndexDelta indexDelta = this.computeIndexDelta(addedOrChangedObjectPathFiles);
        this.thirdPartyPathsIndex.removePaths(indexDelta.deletedKeys);
        this.thirdPartyPathsIndex.setPaths(indexDelta.addedOrChangedEntries);
        LOGGER.debug("Finished synchronization.\nIn total {} entries were added/changed and {} entries were deleted.\n", (Object)indexDelta.addedOrChangedEntries.size(), (Object)indexDelta.deletedKeys.size());
    }

    private IndexDelta computeIndexDelta(Map<EAbapObjectType, String> addedOrChangedObjectPathFiles) throws StorageException {
        Set<EAbapObjectType> addedOrChangedObjectTypes = addedOrChangedObjectPathFiles.keySet();
        LOGGER.debug("Added/Changed object path files to be synchronized: {}", addedOrChangedObjectTypes);
        Map<EAbapObjectType, Map<String, String>> oldEntriesByObjectType = this.batchReadOldEntries(addedOrChangedObjectTypes);
        Map<String, BasicTokenElementInfo> tokenElementInfoForAddedOrChangedObjectPathFiles = this.inputIndex.getTokenElementsByPath(addedOrChangedObjectPathFiles.values());
        IndexDelta fullIndexDelta = IndexDelta.empty();
        for (Map.Entry<EAbapObjectType, String> addedOrChangedObjectPathFile : addedOrChangedObjectPathFiles.entrySet()) {
            EAbapObjectType objectType = addedOrChangedObjectPathFile.getKey();
            String objectPathsFileUniformPath = addedOrChangedObjectPathFile.getValue();
            BasicTokenElementInfo objectPathsFileTokenElementInfo = tokenElementInfoForAddedOrChangedObjectPathFiles.get(objectPathsFileUniformPath);
            Map<String, String> oldEntriesForType = oldEntriesByObjectType.get(objectType);
            IndexDelta indexDeltaForObjectType = AbapThirdPartyPathsSynchronizer.computeIndexDelta(objectType, objectPathsFileTokenElementInfo, oldEntriesForType);
            fullIndexDelta.addFrom(indexDeltaForObjectType);
        }
        return fullIndexDelta;
    }

    private Map<EAbapObjectType, Map<String, String>> batchReadOldEntries(Set<EAbapObjectType> objectTypes) throws StorageException {
        Instant startTimeBatchRead = Instant.now();
        Map<EAbapObjectType, Map<String, String>> oldEntriesByObjectType = this.thirdPartyPathsIndex.getAllKeysForTypes(objectTypes);
        Instant endTimeBatchRead = Instant.now();
        long elapsedTimeInMillis = Duration.between(startTimeBatchRead, endTimeBatchRead).toMillis();
        int numberOfEntriesReadFromTheIndex = oldEntriesByObjectType.values().stream().mapToInt(Map::size).sum();
        LOGGER.debug("Read {} old entries from the index which took {} ms.", (Object)numberOfEntriesReadFromTheIndex, (Object)elapsedTimeInMillis);
        return oldEntriesByObjectType;
    }

    private static IndexDelta computeIndexDelta(EAbapObjectType objectType, BasicTokenElementInfo objectPathsFileTokenElementInfo, Map<String, String> oldEntriesForType) {
        try {
            Map<String, String> newEntriesForType = AbapThirdPartyPathsSynchronizer.parseObjectPathsFile(objectType, objectPathsFileTokenElementInfo);
            IndexDelta indexKeyDeltaForType = AbapThirdPartyPathsSynchronizer.computeIndexDelta(oldEntriesForType, newEntriesForType);
            LOGGER.debug("Computed index delta for {} object type.\n{} entries already existed in the index.\n{} entries need to be added/changed and {} entries need to be deleted.\n", (Object)objectType, (Object)oldEntriesForType.size(), (Object)indexKeyDeltaForType.addedOrChangedEntries.size(), (Object)indexKeyDeltaForType.deletedKeys.size());
            return indexKeyDeltaForType;
        }
        catch (ConQATException e) {
            LOGGER.error("Failed to compute index delta for object type {}.", (Object)objectType, (Object)e);
            return IndexDelta.empty();
        }
    }

    private static Map<String, String> parseObjectPathsFile(EAbapObjectType objectType, BasicTokenElementInfo objectPathsElement) throws ConQATException {
        CsvStringListParser csvParser = AbapThirdPartyPathsSynchronizer.initializeParserAndCheckFormatting(objectPathsElement);
        Instant startTimeParsing = Instant.now();
        HashMap<String, String> newValues = new HashMap<String, String>();
        int currentLineNumber = 2;
        for (List lineParts : csvParser) {
            if (!AbapThirdPartyPathsSynchronizer.sanityCheckObjectPathsFileLine(lineParts, objectType, objectPathsElement.getUniformPath(), ++currentLineNumber)) continue;
            String key = AbapThirdPartyPathsIndex.buildKey(objectType, (String)lineParts.get(1));
            String value = (String)lineParts.get(2);
            newValues.put(key, value);
        }
        Instant endTimeParsing = Instant.now();
        long elapsedTimeInMillis = Duration.between(startTimeParsing, endTimeParsing).toMillis();
        LOGGER.debug("Parsed object path file {}. {} entries were found and it took {} ms.", (Object)objectType, (Object)newValues.size(), (Object)elapsedTimeInMillis);
        return newValues;
    }

    private static @NonNull CsvStringListParser initializeParserAndCheckFormatting(BasicTokenElementInfo objectPathsElement) throws ConQATException {
        CCSMAssert.isTrue((boolean)objectPathsElement.getText().startsWith(OBJECT_PATHS_FORMAT_TITLE_LINE), (String)("ObjectPaths starts with wrong title " + objectPathsElement.getUniformPath()));
        CsvStringListParser csvParser = new CsvStringListParser(new CSVParserBase.Configuration().setCommentLinePattern("^Teamscale object name to path format v1."));
        csvParser.parseAndWrapExceptions((Reader)new StringReader(objectPathsElement.getText()));
        CCSMAssert.isTrue((boolean)csvParser.getHeader().equals(Arrays.asList(OBJECT_PATHS_FILE_COLUMNS_HEADER.split(";"))), (String)("ObjectPaths starts with wrong column headers " + objectPathsElement.getUniformPath()));
        return csvParser;
    }

    private static boolean sanityCheckObjectPathsFileLine(List<String> lineParts, EAbapObjectType objectPathsFileObjectType, String objectPathsFileUniformPath, int lineNumber) {
        if (lineParts.size() != 3) {
            LogManager.getLogger().error("Line {} in {} does not have 3 columns. Ignoring line.", (Object)lineNumber, (Object)objectPathsFileUniformPath);
            return false;
        }
        if (!objectPathsFileObjectType.name().equals(lineParts.get(0))) {
            LogManager.getLogger().error("ObjectType in line {} in {} does not match type in filename. Ignoring line.", (Object)lineNumber, (Object)objectPathsFileUniformPath);
            return false;
        }
        return true;
    }

    private static Map<EAbapObjectType, String> filterObjectPathFiles(List<String> filePaths) {
        HashMap<EAbapObjectType, String> objectPathsFiles = new HashMap<EAbapObjectType, String>();
        for (String filePath : filePaths) {
            Matcher matcher = OBJECT_PATHS_FILE_PATTERN.matcher(filePath);
            if (!matcher.matches()) continue;
            EAbapObjectType objectType = (EAbapObjectType)EnumUtils.valueOf(EAbapObjectType.class, (String)matcher.group(1));
            if (objectType == null) {
                LogManager.getLogger().warn("Could not determine object type from filename {}. Ignoring file.", (Object)filePath);
                continue;
            }
            CCSMAssert.isFalse((boolean)objectPathsFiles.containsKey(objectType), () -> "Two objectPathsFiles for type " + String.valueOf(objectType) + ": " + (String)objectPathsFiles.get(objectType) + " and " + filePath);
            objectPathsFiles.put(objectType, filePath);
        }
        return objectPathsFiles;
    }

    private static IndexDelta computeIndexDelta(Map<String, String> oldEntries, Map<String, String> newEntries) {
        PairList addedOrChangedEntries = new PairList();
        HashSet<String> deletedKeys = new HashSet<String>(oldEntries.keySet());
        for (Map.Entry<String, String> entry : newEntries.entrySet()) {
            String newKey = entry.getKey();
            String newValue = entry.getValue();
            deletedKeys.remove(newKey);
            if (oldEntries.containsKey(newKey) && oldEntries.get(newKey).equals(newValue)) continue;
            addedOrChangedEntries.add((Object)newKey, (Object)newValue);
        }
        return new IndexDelta((PairList<String, String>)addedOrChangedEntries, deletedKeys);
    }

    private record IndexDelta(PairList<String, String> addedOrChangedEntries, Set<String> deletedKeys) {
        private static IndexDelta empty() {
            return new IndexDelta((PairList<String, String>)new PairList(), new HashSet<String>());
        }

        private void addFrom(IndexDelta other) {
            this.addedOrChangedEntries.addAll(other.addedOrChangedEntries);
            this.deletedKeys.addAll(other.deletedKeys);
        }
    }
}

