/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.javascript;

import com.teamscale.index.dependencies.javascript.TsConfig;
import com.teamscale.index.dependencies.javascript.TypescriptPathMappings;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="tsconfig-paths", options={EStorageOption.BRANCHED})
public class TsConfigPathsIndex
implements IProjectIndex {
    private final ValueIndex<TsConfig> delegate;

    public TsConfigPathsIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public TypescriptPathMappings getKnownPathMappings(String uniformPath) throws StorageException {
        TypescriptPathMappings result = new TypescriptPathMappings();
        PairList allEntries = this.delegate.getAllEntries();
        allEntries.sort(Comparator.comparingInt(pathAndConfig -> ((String)pathAndConfig.getFirst()).length()).reversed());
        for (Pair entry : allEntries) {
            String path = (String)entry.getFirst();
            TsConfig tsConfig = (TsConfig)entry.getSecond();
            if (!uniformPath.startsWith(path)) continue;
            tsConfig.appendResolvedPathMappings(path, result::addMapping);
        }
        return result;
    }

    public void setConfig(String tsConfigUniformPath, TsConfig config) throws StorageException {
        this.delegate.setValue(TsConfigPathsIndex.makeKey(tsConfigUniformPath), (Object)config);
    }

    public void setConfigs(PairList<String, TsConfig> values) throws StorageException {
        PairList strippedKeyValues = new PairList();
        for (Pair value : values) {
            strippedKeyValues.add((Object)TsConfigPathsIndex.makeKey((String)value.getFirst()), (Object)((TsConfig)value.getSecond()));
        }
        this.delegate.setValues(strippedKeyValues);
    }

    private static String makeKey(String tsConfigUniformPath) {
        String tsConfigBasePath = StringUtils.stripSuffix((String)tsConfigUniformPath, (String)"tsconfig.json");
        tsConfigBasePath = StringUtils.stripSuffix((String)tsConfigBasePath, (String)"jsconfig.json");
        return tsConfigBasePath;
    }

    public void removeConfigs(List<String> tsConfigUniformPaths) throws StorageException {
        this.delegate.removeValues(tsConfigUniformPaths);
    }
}

