/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.teamscale.index.external.ExternalProcessConstants;
import com.teamscale.index.external.input.ImportInfoPath;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.TestArtifactUtils;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;

class PathCorrector {
    private final IMatchingPathsLookup matchingPathsLookup;
    private final Set<String> knownUniformPaths;
    private final CaseInsensitiveStringSet caseInsensitiveUniformPaths = new CaseInsensitiveStringSet();

    public PathCorrector(IMatchingPathsLookup matchingPathsLookup, List<String> knownUniformPaths) {
        this.matchingPathsLookup = matchingPathsLookup;
        this.knownUniformPaths = new HashSet<String>(knownUniformPaths);
        this.caseInsensitiveUniformPaths.addAll(knownUniformPaths);
    }

    public Set<ImportInfoPath> correctPaths(Collection<String> uniformPaths) {
        HashSet<ImportInfoPath> correctedPaths = new HashSet<ImportInfoPath>();
        for (String path : CollectionUtils.map(uniformPaths, this::correctCasing)) {
            if (TestArtifactUtils.isTestExecutionArtifact((String)path) || path.startsWith(ExternalProcessConstants.PROCESS_PATH_NAME) || ExternalAnalysisImportInfoReport.isRawReportPath(path)) {
                correctedPaths.add(new ImportInfoPath(path, path));
                continue;
            }
            Optional<String> lookedUpPath = this.matchingPathsLookup.lookupBestPath(path);
            correctedPaths.add(new ImportInfoPath(path, lookedUpPath.orElse(path)));
        }
        return correctedPaths;
    }

    private String correctCasing(String uniformPath) {
        if (TestArtifactUtils.isTestExecutionArtifact((String)uniformPath) || this.knownUniformPaths.contains(uniformPath) || !this.caseInsensitiveUniformPaths.contains((Object)uniformPath)) {
            return uniformPath;
        }
        return this.caseInsensitiveUniformPaths.get(uniformPath);
    }
}

