/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage;

import com.teamscale.commons.StreamUtils;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.IOutgoingExternalAnalysisArchive;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.filesystem.ZipFileUtils;
import org.conqat.lib.commons.string.StringUtils;

public class OutgoingExternalAnalysisArchive
implements IOutgoingExternalAnalysisArchive {
    private final String targetPath;
    private final byte[] content;
    private final long dataSize;

    public OutgoingExternalAnalysisArchive(ExternalAnalysisSessionInfo session, ProjectConfiguration projectConfiguration, ExternalStorageBackend externalStorageBackend, Collection<ExternalAnalysisImportInfoReport> reports) throws IOException {
        this.targetPath = OutgoingExternalAnalysisArchive.buildTargetPath(session, projectConfiguration, externalStorageBackend);
        try (ByteArrayOutputStream contentStream = new ByteArrayOutputStream();){
            this.dataSize = StreamUtils.writeWithByteCounter((OutputStream)contentStream, stream -> OutgoingExternalAnalysisArchive.writeArchive(reports, stream));
            this.content = contentStream.toByteArray();
        }
    }

    @Override
    public InputStream getDataStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public String getTargetPath() {
        return this.targetPath;
    }

    private static String buildTargetPath(ExternalAnalysisSessionInfo session, ProjectConfiguration projectConfiguration, ExternalStorageBackend externalStorageBackend) {
        String path = externalStorageBackend.useRevisionBasedBackend() ? OutgoingExternalAnalysisArchive.buildRevisionBasedTargetPath(session, projectConfiguration, externalStorageBackend) : OutgoingExternalAnalysisArchive.buildTimestampAndBranchBasedTargetPath(session, projectConfiguration, externalStorageBackend);
        return StringUtils.stripPrefix((String)path, (String)"/");
    }

    private static String buildTimestampAndBranchBasedTargetPath(ExternalAnalysisSessionInfo session, ProjectConfiguration projectConfiguration, ExternalStorageBackend externalStorageBackend) {
        return String.join((CharSequence)"/", StringUtils.strip((String)externalStorageBackend.uploadPathPrefix(), (String)"/"), projectConfiguration.getExternalStorageProjectMappingId().toString(), "__branches__", session.getCommit().getBranchName(), "__timestamps__", Long.toString(session.getCommit().getTimestamp()), "__partitions__", session.getPartition(), "__reports__", session.getSessionId() + ".zip");
    }

    private static String buildRevisionBasedTargetPath(ExternalAnalysisSessionInfo session, ProjectConfiguration projectConfiguration, ExternalStorageBackend externalStorageBackend) {
        return String.join((CharSequence)"/", StringUtils.strip((String)externalStorageBackend.uploadPathPrefix(), (String)"/"), projectConfiguration.getExternalStorageProjectMappingId().toString(), "__revisions__", session.getRevision(), "__partitions__", session.getPartition(), "__reports__", session.getSessionId() + ".zip");
    }

    private static void writeArchive(Collection<ExternalAnalysisImportInfoReport> reports, OutputStream stream) throws IOException {
        try (ZipArchiveOutputStream archive = new ZipArchiveOutputStream(stream);){
            for (ExternalAnalysisImportInfoReport report : reports) {
                Pair pathSplitByFileEnding = StringUtils.splitAtLast((String)report.getReportUniformPath(), (char)'.');
                long hash = XXHashUtils.xxhash64((String)report.getData());
                String uniqueReportUniformPath = (String)pathSplitByFileEnding.getFirst() + "_" + hash + "." + (String)pathSplitByFileEnding.getSecond();
                ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)archive, (String)String.join((CharSequence)"/", report.getReportFormat(), uniqueReportUniformPath), (CharSequence)report.getData());
            }
        }
    }
}

