/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.SessionBasedExternalAnalysisResultsTriggerBase;
import com.teamscale.index.external.input.external_storage.EExternalStorageBackendProtocol;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.OutgoingExternalAnalysisArchive;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.external.status.EExternalAnalysisResultType;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.repository.artifact_store.ArtifactStoreUtils;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import com.teamscale.index.repository.artifact_store.s3.S3ArchiveIndex;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.collections.DurableSet;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.lang.ObjectUtils;
import org.jetbrains.annotations.TestOnly;

public class StoreAnalysisResultsInExternalStorageTrigger
extends SessionBasedExternalAnalysisResultsTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static UnmodifiableList<Duration> retryDelays = CollectionUtils.asUnmodifiable(List.of(Duration.ofMinutes(1L), Duration.ofMinutes(8L), Duration.ofMinutes(32L)));

    @TestOnly
    public static AutoCloseable setRetryDelaysForTesting(List<Duration> delays) {
        UnmodifiableList<Duration> oldRetryDelays = retryDelays;
        retryDelays = CollectionUtils.asUnmodifiable(new ArrayList<Duration>(delays));
        return () -> {
            retryDelays = oldRetryDelays;
        };
    }

    public static synchronized void schedule(InternalProjectId projectId, IndexLayer indexLayer, String schedulingReason) throws StorageException {
        if (StoreAnalysisResultsInExternalStorageTrigger.isAlreadyScheduled(projectId, indexLayer)) {
            LOGGER.debug("Skipped scheduling {} since it was already scheduled.", (Object)StoreAnalysisResultsInExternalStorageTrigger.class.getSimpleName());
            return;
        }
        JobDescriptor integrationJob = new JobDescriptor(projectId, StoreAnalysisResultsInExternalStorageTrigger.class, null, (Object)new JobParameter(projectId), schedulingReason);
        ISchedulerCommunicator.getInstance().scheduleExternalJob(indexLayer, integrationJob);
    }

    private static boolean isAlreadyScheduled(InternalProjectId internalProjectId, IndexLayer indexLayer) throws StorageException {
        ProjectAnalysisProgressIndex projectProgressIndex = (ProjectAnalysisProgressIndex)indexLayer.openNonHistorizedProjectIndex(ProjectAnalysisProgressIndex.class, indexLayer.resolveProject((IProjectId)internalProjectId));
        DurableSet scheduledJobs = projectProgressIndex.createJobQueueSet();
        return scheduledJobs.stream().anyMatch(job -> StoreAnalysisResultsInExternalStorageTrigger.class.getName().equals(job.getTriggerName()));
    }

    public void execute() throws Exception {
        JobParameter parameter = (JobParameter)this.jobDescriptor.getParameterObject(JobParameter.class);
        GlobalStorageSystem globalStorage = this.indexLayer.openGlobalStorageSystem();
        CommitResolvingStorageSystem projectStorage = this.indexLayer.openProjectStorageSystem((IProjectId)parameter.projectId());
        this.processSessions((ExternalAnalysisImportSessionIndex)projectStorage.openProjectIndex(ExternalAnalysisImportSessionIndex.class, null), (ExternalAnalysisStatusIndex)projectStorage.openProjectIndex(ExternalAnalysisStatusIndex.class, null), StoreAnalysisResultsInExternalStorageTrigger.getProjectConfiguration((ProjectStorageSystem)projectStorage), (IExternalCredentialsProvider)StoreAnalysisResultsInExternalStorageTrigger.getCredentialsProvider(globalStorage));
    }

    private void processSessions(ExternalAnalysisImportSessionIndex sessionIndex, ExternalAnalysisStatusIndex statusIndex, ProjectConfiguration projectConfiguration, IExternalCredentialsProvider externalCredentialsProvider) throws RescheduleRequestedException, RepositoryException, StorageException {
        HashSet<ExternalStorageBackend> externalStoragesWithChanges = new HashSet<ExternalStorageBackend>();
        PairList errorsBySessionId = new PairList();
        for (ExternalAnalysisSessionInfo session : sessionIndex.getAllSessionInfos().getSecondList()) {
            this.tryProcessSession(session, sessionIndex, statusIndex, projectConfiguration, externalCredentialsProvider).consumeChangedExternalStorageOrError(externalStoragesWithChanges::add, error -> errorsBySessionId.add((Object)session.getSessionId(), error));
        }
        StoreAnalysisResultsInExternalStorageTrigger.throwAggregatedErrorsIfNotEmpty((PairList<String, Exception>)errorsBySessionId);
        this.scheduleChangeRetrievers(externalStoragesWithChanges, projectConfiguration);
    }

    private SessionProcessingResult tryProcessSession(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionIndex sessionIndex, ExternalAnalysisStatusIndex statusIndex, ProjectConfiguration projectConfiguration, IExternalCredentialsProvider externalCredentialsProvider) throws RescheduleRequestedException {
        try {
            ExternalStorageBackend externalStorage = session.getTargetStorage();
            if (externalStorage == null) {
                return SessionProcessingResult.ofSuccessWithoutChanges();
            }
            boolean shouldRetrieveChanges = this.processSession(session, sessionIndex, projectConfiguration, externalCredentialsProvider, statusIndex, externalStorage);
            if (!shouldRetrieveChanges) {
                LOGGER.warn("Upload from session '{}' will only be available after next reanalysis.", (Object)session.getSessionId());
                return SessionProcessingResult.ofSuccessWithoutChanges();
            }
            return SessionProcessingResult.ofSuccessWithChanges(externalStorage);
        }
        catch (RescheduleRequestedException rescheduleRequest) {
            throw rescheduleRequest;
        }
        catch (Exception e) {
            return SessionProcessingResult.ofFailure(e);
        }
    }

    private void scheduleChangeRetrievers(Set<ExternalStorageBackend> externalStoragesWithChanges, ProjectConfiguration projectConfiguration) throws StorageException {
        for (ExternalStorageBackend externalStorage : externalStoragesWithChanges) {
            this.scheduleChangeRetriever(projectConfiguration, externalStorage);
        }
    }

    private static void throwAggregatedErrorsIfNotEmpty(PairList<String, Exception> errorsBySessionId) throws RepositoryException {
        if (errorsBySessionId.isEmpty()) {
            return;
        }
        RepositoryException aggregatedException = new RepositoryException("Failed to upload session(s) [%s].".formatted(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)errorsBySessionId.getFirstList())));
        errorsBySessionId.getSecondList().forEach(arg_0 -> aggregatedException.addSuppressed(arg_0));
        throw aggregatedException;
    }

    private boolean processSession(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionIndex sessionIndex, ProjectConfiguration projectConfiguration, IExternalCredentialsProvider externalCredentialsProvider, ExternalAnalysisStatusIndex statusIndex, ExternalStorageBackend externalStorage) throws StorageException, RescheduleRequestedException, RepositoryException, ProjectConfigurationException, IOException {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = session::getCommit;
        LOGGER.info("Using write commit: {}", supplierArray);
        try {
            StoreAnalysisResultsInExternalStorageTrigger.validateSessionParameters(session, externalStorage);
            String newUploadedPath = this.uploadSession(session, sessionIndex, projectConfiguration, externalStorage, StoreAnalysisResultsInExternalStorageTrigger.getCredentials(externalCredentialsProvider, externalStorage));
            this.storeProcessingStatus(true, session, session.getCommit(), statusIndex, EnumSet.noneOf(EExternalAnalysisResultType.class));
            sessionIndex.deleteSession(session.getSessionId());
            return this.storeChangeForIncrementalScan(projectConfiguration, externalStorage, newUploadedPath);
        }
        catch (Throwable t) {
            this.addStatusMessage("Error: " + t.getMessage());
            this.storeProcessingStatus(false, session, session.getCommit(), statusIndex, EnumSet.noneOf(EExternalAnalysisResultType.class));
            throw t;
        }
    }

    private boolean storeChangeForIncrementalScan(ProjectConfiguration projectConfiguration, ExternalStorageBackend externalStorage, String newUploadedPath) throws StorageException {
        return externalStorage.backendProtocol() != EExternalStorageBackendProtocol.S3 || this.storeChangedPathInIncrementalScanIndex(projectConfiguration, newUploadedPath);
    }

    private static ExternalCredentialsIndex getCredentialsProvider(GlobalStorageSystem globalStorageSystem) throws StorageException {
        return (ExternalCredentialsIndex)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class);
    }

    private static ProjectConfiguration getProjectConfiguration(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return (ProjectConfiguration)((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).getValue(ProjectConfiguration.class);
    }

    private static @NonNull ExternalCredentials getCredentials(IExternalCredentialsProvider credentialsProvider, ExternalStorageBackend externalStorageBackend) throws StorageException, ProjectConfigurationException {
        return (ExternalCredentials)ObjectUtils.requireNonNullElseThrow((Object)credentialsProvider.getExternalCredentials(externalStorageBackend.credentialsName()), () -> new ProjectConfigurationException("No credentials with name '" + externalStorageBackend.credentialsName() + "' found."));
    }

    private String uploadSession(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionIndex sessionIndex, ProjectConfiguration projectConfiguration, ExternalStorageBackend externalStorageBackend, ExternalCredentials credentials) throws StorageException, RepositoryException, ProjectConfigurationException, IOException, RescheduleRequestedException {
        SimpleArtifactStoreClientBase<?> client = ArtifactStoreUtils.getClientForProtocol(externalStorageBackend, credentials, this.indexLayer);
        try {
            OutgoingExternalAnalysisArchive archive = new OutgoingExternalAnalysisArchive(session, projectConfiguration, externalStorageBackend, StoreAnalysisResultsInExternalStorageTrigger.getRawReports(sessionIndex, session));
            client.putArchive(externalStorageBackend.repositoryOrBucketName(), archive);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = session::getSessionId;
            supplierArray[1] = archive::getTargetPath;
            LOGGER.info("Stored archive for session {} successfully at '{}'.", supplierArray);
            return archive.getTargetPath();
        }
        catch (RepositoryException e) {
            int retryCount = this.getRetryCount();
            if (retryCount >= retryDelays.size()) {
                LOGGER.atError().withThrowable((Throwable)e).log("Storing archive for session {} failed.", (Object)session.getSessionId());
                throw e;
            }
            Duration delay = (Duration)retryDelays.get(retryCount);
            LOGGER.atWarn().withThrowable((Throwable)e).log("Storing archive for session {} failed; Retrying in {} seconds.", (Object)session.getSessionId(), (Object)delay.toSeconds());
            throw new RescheduleRequestedException((Throwable)e, Instant.now().plus(delay));
        }
    }

    private static void validateSessionParameters(ExternalAnalysisSessionInfo session, ExternalStorageBackend externalStorageBackend) throws ProjectConfigurationException {
        if (!externalStorageBackend.useRevisionBasedBackend() && session.getCommit() == null) {
            throw new ProjectConfigurationException("No commit was provided for the timestamp-based upload.");
        }
        if (externalStorageBackend.useRevisionBasedBackend() && session.getRevision() == null) {
            throw new ProjectConfigurationException("No revision was provided for the revision-based upload.");
        }
    }

    private void scheduleChangeRetriever(ProjectConfiguration projectConfiguration, ExternalStorageBackend externalStorageBackend) throws StorageException {
        ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(this.indexLayer, this.indexLayer.resolveToInternalProjectId((IProjectId)ObjectUtils.requireNonNull((Object)projectConfiguration.getInternalId(), (String)"internal project ID")), externalStorageBackend.backendProtocol().getChangeRetrieverTriggerName());
    }

    private static Collection<ExternalAnalysisImportInfoReport> getRawReports(ExternalAnalysisImportSessionIndex sessionIndex, ExternalAnalysisSessionInfo session) throws StorageException {
        return sessionIndex.getImportInfos(session).values().stream().flatMap(importInfos -> importInfos.getInfos().stream().filter(StoreAnalysisResultsInExternalStorageTrigger::isRawReportPath)).map(report -> (ExternalAnalysisImportInfoReport)report).toList();
    }

    private static boolean isRawReportPath(ExternalAnalysisImportInfo<?> info) {
        String uniformPath = info.getUniformPath();
        if (ExternalAnalysisImportInfoReport.isRawReportPath(uniformPath)) {
            return true;
        }
        LOGGER.error("External uploads contained a pre-parsed report for the uniform path '{}'. This trigger can only handle raw reports, hence this upload will be ignored. This probably happened because a service implementation pre-parsed the report. Please report this to the Teamscale support if possible.", (Object)uniformPath);
        return false;
    }

    public Set<String> getCrossCommitBlockingWriteStores() {
        return CollectionUtils.asHashSet((Object[])new String[]{"external-analysis-results"});
    }

    public Set<String> getWriteStores() {
        return CollectionUtils.unionSet((Collection)super.getWriteStores(), (Collection[])new Collection[]{Set.of("external-analysis-results", "external-analysis-session", "_meta")});
    }

    private boolean storeChangedPathInIncrementalScanIndex(ProjectConfiguration projectConfiguration, String newPathToScan) throws StorageException {
        try {
            S3ArchiveIndex.open((ProjectStorageSystem)this.indexLayer.openProjectStorageSystem((IProjectId)projectConfiguration.getInternalId()), "external-analysis-data").runWithIncrementalScanLock(lockedIndex -> lockedIndex.addKeysForIncrementalScan(Collections.singleton(newPathToScan)));
        }
        catch (StorageException e) {
            if (e.getMessage().contains("No schema entry for store")) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.MAINTENANCE;
    }

    private record JobParameter(InternalProjectId projectId) {
    }

    private record SessionProcessingResult(@Nullable Exception exception, @Nullable ExternalStorageBackend changedExternalStorage) {
        public static SessionProcessingResult ofSuccessWithChanges(@NonNull ExternalStorageBackend changedExternalStorage) {
            return new SessionProcessingResult(null, changedExternalStorage);
        }

        public static SessionProcessingResult ofSuccessWithoutChanges() {
            return new SessionProcessingResult(null, null);
        }

        public static SessionProcessingResult ofFailure(@NonNull Exception exception) {
            return new SessionProcessingResult(exception, null);
        }

        public void consumeChangedExternalStorageOrError(Consumer<@NonNull ExternalStorageBackend> changedExternalStorageConsumer, Consumer<@NonNull Exception> errorConsumer) {
            if (this.exception != null) {
                errorConsumer.accept(this.exception);
                return;
            }
            if (this.changedExternalStorage != null) {
                changedExternalStorageConsumer.accept(this.changedExternalStorage);
            }
        }
    }
}

