/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings;

import com.teamscale.index.resource.TokenElementInfo;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class PythonLintingUtils {
    public static @NonNull Map<String, TokenElementInfo> prepareFilesForAnalysis(@NonNull List<TokenElementInfo> tokenElements, @NonNull CanonicalFile tempDirectory) throws IOException {
        HashMap<String, TokenElementInfo> pathToElement = new HashMap<String, TokenElementInfo>();
        int fileId = 0;
        for (TokenElementInfo tokenElement : tokenElements) {
            String fileName = "file" + fileId++ + ".py";
            Path file = tempDirectory.toPath().resolve(fileName);
            FileSystemUtils.writeFileUTF8((Path)file, (String)tokenElement.getText());
            pathToElement.put(fileName, tokenElement);
        }
        return pathToElement;
    }
}

