/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.ResourceServiceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class AffectedFileDeltaCalculator {
    private static final Logger LOGGER = LogManager.getLogger();

    public static @NonNull List<TokenElementChurnWithOriginInfo> calculateTokenElementChurnWithOriginInfo(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end, EChangeEntryOrigin modifiedChangeOrigin, ProjectStorageSystem projectStorageSystem) throws StorageException {
        Map<String, String> startPathToContentHash = AffectedFileDeltaCalculator.getUniformPathToHashMapping(projectStorageSystem, uniformPath, start);
        Map<String, String> endPathToContentHash = AffectedFileDeltaCalculator.getUniformPathToHashMapping(projectStorageSystem, uniformPath, end);
        return AffectedFileDeltaCalculator.calculateTokenElementChurnWithOriginInfo(projectStorageSystem, startPathToContentHash, endPathToContentHash, start, end, modifiedChangeOrigin);
    }

    public static @NonNull List<TokenElementChurnWithOriginInfo> calculateTokenElementChurnWithOriginInfo(ProjectStorageSystem projectStorageSystem, Map<String, String> startPathToContentHash, Map<String, String> endPathToContentHash, CommitDescriptor startCommit, CommitDescriptor endCommit, EChangeEntryOrigin modifiedChangeOrigin) throws StorageException {
        CommitDescriptorIndex commitIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        Optional actualEnd = commitIndex.getFirstActualCommitBeforeOrAt(endCommit, startCommit.getTimestamp());
        if (actualEnd.isEmpty()) {
            return new ArrayList<TokenElementChurnWithOriginInfo>();
        }
        List commitsInTimeRange = commitIndex.getCommitHistoryWithFirstParentCommits((CommitDescriptor)actualEnd.get(), startCommit.getTimestamp());
        return AffectedFileDeltaCalculator.calculateTokenElementChurnWithOriginInfo(projectStorageSystem, startPathToContentHash, endPathToContentHash, startCommit, endCommit, commitsInTimeRange, modifiedChangeOrigin);
    }

    public static @NonNull List<TokenElementChurnWithOriginInfo> calculateTokenElementChurnWithOriginInfo(ProjectStorageSystem projectStorageSystem, Map<String, String> startPathToContentHash, Map<String, String> endPathToContentHash, CommitDescriptor startCommit, CommitDescriptor endCommit, List<ParentedCommitDescriptor> commitsInTimeRange, EChangeEntryOrigin modifiedChangeOrigin) throws StorageException {
        Set<String> startPaths = startPathToContentHash.keySet();
        Set<String> endPaths = endPathToContentHash.keySet();
        HashSet addedPaths = CollectionUtils.differenceSet(endPaths, (Collection[])new Collection[]{startPaths});
        HashSet removedPaths = CollectionUtils.differenceSet(startPaths, (Collection[])new Collection[]{endPaths});
        PairList movedPathsWithElementHistory = new PairList();
        PairList copiedPathsWithElementHistory = new PairList();
        AffectedFileDeltaCalculator.setMovedAndCopiedPaths(projectStorageSystem, startPaths, addedPaths, removedPaths, (PairList<String, ElementHistoryEntry>)movedPathsWithElementHistory, (PairList<String, ElementHistoryEntry>)copiedPathsWithElementHistory, commitsInTimeRange);
        CollectionUtils.removeAll((Set)addedPaths, (List)CollectionUtils.unionList((Collection)movedPathsWithElementHistory.extractFirstList(), (Collection[])new Collection[]{copiedPathsWithElementHistory.extractFirstList()}));
        ArrayList<TokenElementChurnWithOriginInfo> result = new ArrayList<TokenElementChurnWithOriginInfo>();
        PairList addedPathsWithElementHistory = PairList.fromMap(AffectedFileDeltaCalculator.buildAddedPathToFirstEntryMapping(projectStorageSystem, addedPaths, commitsInTimeRange));
        PairList removedPathsWithElementHistory = PairList.fromMap(AffectedFileDeltaCalculator.buildAddedPathToFirstEntryMapping(projectStorageSystem, removedPaths, commitsInTimeRange));
        AffectedFileDeltaCalculator.addAddedOrDeletedPaths(result, startCommit, endCommit, (PairList<String, ElementHistoryEntry>)addedPathsWithElementHistory, EElementHistoryChangeType.ADD);
        AffectedFileDeltaCalculator.addAddedOrDeletedPaths(result, startCommit, endCommit, (PairList<String, ElementHistoryEntry>)removedPathsWithElementHistory, EElementHistoryChangeType.DELETE);
        AffectedFileDeltaCalculator.addMovedOrCopiedPaths(result, startCommit, endCommit, (PairList<String, ElementHistoryEntry>)movedPathsWithElementHistory, EElementHistoryChangeType.MOVE);
        AffectedFileDeltaCalculator.addMovedOrCopiedPaths(result, startCommit, endCommit, (PairList<String, ElementHistoryEntry>)copiedPathsWithElementHistory, EElementHistoryChangeType.COPY);
        AffectedFileDeltaCalculator.addEditedPaths(result, startPathToContentHash, endPathToContentHash, startCommit, endCommit, startPaths, endPaths, modifiedChangeOrigin);
        Collections.sort(result);
        return result;
    }

    public static @Nullable String getHashFromParentContainer(String uniformPath, ContainerIndex containerIndex, CommitDescriptor commit) throws StorageException {
        String parentPath = UniformPathUtils.getParentPath((String)uniformPath);
        ContainerInfo parentContainer = containerIndex.getContainer(parentPath);
        if (parentContainer == null) {
            LOGGER.debug("Could not find parent container for path '{}' (commit '{}')", (Object)uniformPath, (Object)commit);
            return null;
        }
        return AffectedFileDeltaCalculator.getHash(uniformPath, parentContainer, containerIndex);
    }

    public static @Nullable String getHash(String uniformPath, ContainerInfo container, ContainerIndex containerIndex) throws StorageException {
        @Nullable String hash = container.getHash(uniformPath);
        if (hash != null && hash.startsWith("redirect:")) {
            uniformPath = StringUtils.stripPrefix((String)hash, (String)"redirect:");
            String parentPath = UniformPathUtils.getParentPath((String)uniformPath);
            if (StringUtils.isEmpty((String)parentPath)) {
                return null;
            }
            return containerIndex.getContainer(parentPath).getHash(uniformPath);
        }
        return hash;
    }

    private static void addAddedOrDeletedPaths(Collection<TokenElementChurnWithOriginInfo> churnInfos, CommitDescriptor startCommit, CommitDescriptor endCommit, PairList<String, ElementHistoryEntry> paths, EElementHistoryChangeType changeType) {
        for (Pair path : paths) {
            CommitDescriptor latestExistingCommit = changeType == EElementHistoryChangeType.DELETE ? startCommit : endCommit;
            churnInfos.add(new TokenElementChurnWithOriginInfo(endCommit, latestExistingCommit, startCommit, (String)path.getFirst(), changeType, ((ElementHistoryEntry)((Object)path.getSecond())).getChangeEntryOrigin(), null, null));
        }
    }

    private static void addMovedOrCopiedPaths(Collection<TokenElementChurnWithOriginInfo> churnInfos, CommitDescriptor startCommit, CommitDescriptor endCommit, PairList<String, ElementHistoryEntry> paths, EElementHistoryChangeType moveOrCopy) {
        for (Pair path : paths) {
            ElementHistoryEntry entry = (ElementHistoryEntry)((Object)path.getSecond());
            churnInfos.add(new TokenElementChurnWithOriginInfo(endCommit, endCommit, startCommit, (String)path.getFirst(), moveOrCopy, entry.getChangeEntryOrigin(), entry.getOriginPath(), entry.getOriginCommit()));
        }
    }

    private static void addEditedPaths(List<TokenElementChurnWithOriginInfo> result, Map<String, String> startPathToContentHash, Map<String, String> endPathToContentHash, CommitDescriptor startCommit, CommitDescriptor endCommit, Set<String> startPaths, Set<String> endPaths, EChangeEntryOrigin modifiedChangeOrigin) {
        HashSet commonPaths = CollectionUtils.intersectionSet(startPaths, (Collection[])new Collection[]{endPaths});
        for (String path : commonPaths) {
            if (Objects.equals(startPathToContentHash.get(path), endPathToContentHash.get(path))) continue;
            result.add(new TokenElementChurnWithOriginInfo(endCommit, endCommit, startCommit, path, EElementHistoryChangeType.EDIT, modifiedChangeOrigin, null, null));
        }
    }

    private static void setMovedAndCopiedPaths(ProjectStorageSystem projectStorageSystem, Set<String> startPaths, Set<String> addedPaths, Set<String> removedPaths, PairList<String, ElementHistoryEntry> movedPaths, PairList<String, ElementHistoryEntry> copiedPaths, List<ParentedCommitDescriptor> commits) throws StorageException {
        Map<String, ElementHistoryEntry> pathToFirstHistoryEntry = AffectedFileDeltaCalculator.buildAddedPathToFirstEntryMapping(projectStorageSystem, addedPaths, commits);
        HashSet<String> toBeRemoved = new HashSet<String>();
        for (Map.Entry<String, ElementHistoryEntry> entry : pathToFirstHistoryEntry.entrySet()) {
            ElementHistoryEntry historyEntry = entry.getValue();
            if (!EElementHistoryChangeType.ORIGIN_CHANGE.contains((Object)historyEntry.getChangeType())) continue;
            String originPath = historyEntry.getOriginPath();
            if (removedPaths.contains(originPath)) {
                toBeRemoved.add(originPath);
                movedPaths.add((Object)entry.getKey(), (Object)historyEntry);
                continue;
            }
            if (!startPaths.contains(originPath)) continue;
            copiedPaths.add((Object)entry.getKey(), (Object)historyEntry);
        }
        removedPaths.removeAll(toBeRemoved);
    }

    private static Map<String, ElementHistoryEntry> buildAddedPathToFirstEntryMapping(ProjectStorageSystem projectStorageSystem, Set<String> addedPaths, List<ParentedCommitDescriptor> commits) throws StorageException {
        HashMap<String, ElementHistoryEntry> pathToFirstHistoryEntry = new HashMap<String, ElementHistoryEntry>();
        ArrayList<String> addedPathsList = new ArrayList<String>(addedPaths);
        for (CommitDescriptor commitDescriptor : commits) {
            ElementHistoryIndex historyIndex = (ElementHistoryIndex)projectStorageSystem.openProjectIndex(ElementHistoryIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commitDescriptor));
            List<ElementHistoryEntry> values = historyIndex.getHistoryEntries(addedPathsList);
            ArrayList<String> addedPathsCopy = new ArrayList<String>(addedPathsList);
            for (int i = 0; i < addedPathsCopy.size(); ++i) {
                String path = (String)addedPathsCopy.get(i);
                ElementHistoryEntry historyEntry = values.get(i);
                if (historyEntry == null) continue;
                pathToFirstHistoryEntry.put(path, historyEntry);
                addedPathsList.remove(path);
            }
            if (!addedPathsList.isEmpty()) continue;
            break;
        }
        return pathToFirstHistoryEntry;
    }

    private static Map<String, String> getUniformPathToHashMapping(ProjectStorageSystem projectStorageSystem, UniformPath path, CommitDescriptor commit) throws StorageException {
        String uniformPath = path.toString();
        ContainerIndex containerIndex = (ContainerIndex)projectStorageSystem.openProjectIndex(ContainerIndex.class, "dir", HistoryAccessOption.readCommit((CommitDescriptor)commit));
        if (containerIndex.isFile(uniformPath)) {
            return Collections.singletonMap(UniformPathCompatibilityUtil.resolveToCodePath((String)uniformPath), AffectedFileDeltaCalculator.getHashFromParentContainer(uniformPath, containerIndex, commit));
        }
        return AffectedFileDeltaCalculator.getUniformPathToHashMappingForDirectory(uniformPath, containerIndex);
    }

    private static Map<String, String> getUniformPathToHashMappingForDirectory(String uniformPath, ContainerIndex containerIndex) throws StorageException {
        HashMap<String, String> pathToHash = new HashMap<String, String>();
        ArrayList<ContainerInfo> containers = new ArrayList<ContainerInfo>();
        ContainerInfo directoryContainer = containerIndex.getContainer(uniformPath);
        if (directoryContainer != null) {
            containers.add(directoryContainer);
        }
        String prefix = ResourceServiceUtils.getUniformPathPrefixContainerAware(containerIndex, uniformPath);
        containers.addAll((Collection<ContainerInfo>)containerIndex.getContainersByPathPrefix(prefix).getSecondList());
        for (ContainerInfo container : containers) {
            for (String child : container.getChildren()) {
                String hash;
                if (container.childIsAContainer(child) || AffectedFileDeltaCalculator.shouldBeIgnored(uniformPath, child) || (hash = AffectedFileDeltaCalculator.getHash(child, container, containerIndex)) == null) continue;
                pathToHash.put(UniformPathCompatibilityUtil.resolveToCodePath((String)child), hash);
            }
        }
        return pathToHash;
    }

    private static boolean shouldBeIgnored(String uniformPath, String child) {
        return !uniformPath.startsWith(UniformPath.EType.ARCHITECTURE.getPrefix()) && child.startsWith(UniformPath.EType.ARCHITECTURE.getPrefix());
    }
}

