/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.code_change.CodeChangeIndex;
import com.teamscale.index.findings.calculation.FindingsServiceUtils;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.wia.WiaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class CodeFindingsRetriever
implements IFindingsRetriever {
    private static final int RETRIEVE_ALL_THRESHOLD = 10000;
    protected final ProjectStorageSystem projectStorageSystem;

    public CodeFindingsRetriever(ProjectStorageSystem projectStorageSystem) {
        this.projectStorageSystem = projectStorageSystem;
    }

    @Override
    public List<TrackedFinding> getFindings(@NonNull String uniformPath, @NonNull CommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commit);
        Map<UniformPath, List<TrackedFinding>> findings = FindingsServiceUtils.getFindingsVirtualPathAware(this.projectStorageSystem, historyAccessOption, UniformPathCompatibilityUtil.convert((String)uniformPath));
        ArrayList<TrackedFinding> result = new ArrayList<TrackedFinding>();
        for (List<TrackedFinding> findingList : findings.values()) {
            for (TrackedFinding finding : findingList) {
                if (WiaUtils.isWorkItemPath((String)finding.getLocation().getUniformPath())) continue;
                result.add(finding);
            }
        }
        return result;
    }

    @Override
    public List<@Nullable TrackedFinding> getFindings(List<String> findingIds, @NonNull CommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commit);
        TrackedFindingsByIdIndex findingsIndex = (TrackedFindingsByIdIndex)this.projectStorageSystem.openProjectIndex(TrackedFindingsByIdIndex.class, historyAccessOption);
        return findingsIndex.getFindings(findingIds);
    }

    @Override
    public <T extends TrackedFinding> List<T> getFindingsInChangedCode(long startTimestamp, @NonNull CommitDescriptor end, List<T> commonFindings) throws StorageException {
        CodeChangeIndex codeChangeIndex = (CodeChangeIndex)this.projectStorageSystem.openProjectIndex(CodeChangeIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)end));
        return codeChangeIndex.reduceToFindingsInChangedCode(commonFindings, startTimestamp);
    }

    @Override
    public Map<String, FindingBlacklistInfo> getFlaggedFindings(Collection<TrackedFinding> findings, @NonNull CommitDescriptor commit) throws StorageException {
        List<String> findingIds;
        FindingBlacklistIndex blacklistIndex = (FindingBlacklistIndex)this.projectStorageSystem.openProjectIndex(FindingBlacklistIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
        if (findings.size() > 10000) {
            HashSet<String> allFindingIds = new HashSet<String>(blacklistIndex.getAllFindingIds());
            findingIds = findings.stream().map(TrackedFinding::getId).filter(allFindingIds::contains).toList();
        } else {
            findingIds = CollectionUtils.map(findings, TrackedFinding::getId);
        }
        return blacklistIndex.getBlacklistInfos(findingIds).stream().filter(Objects::nonNull).collect(Collectors.toMap(FindingBlacklistInfo::getFindingId, Function.identity()));
    }
}

