/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.index.findings.calculation.BasicFindingsFilterSettings;
import com.teamscale.index.findings.calculation.ExtendedTrackedFindingUtils;
import com.teamscale.index.findings.calculation.FilteredFindingDelta;
import com.teamscale.index.findings.calculation.FindingDeltaCalculator;
import com.teamscale.index.findings.calculation.FindingDeltaCount;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.FindingDelta;
import org.conqat.engine.persistence.store.StorageException;

public class FindingDeltaFilterUtils {
    public static FindingDeltaCount calculateFindingDeltaCountForPath(CommitDescriptor startCommit, CommitDescriptor endCommit, BasicFindingsFilterSettings filterSettings, String uniformPath, FindingsCalculationInfo calculationInfo) throws StorageException {
        return FindingDeltaCount.create(FindingDeltaFilterUtils.calculateFindingDeltaForPath(startCommit, endCommit, filterSettings, true, uniformPath, calculationInfo));
    }

    public static FilteredFindingDelta calculateFindingDeltaForPath(CommitDescriptor startCommit, CommitDescriptor endCommit, BasicFindingsFilterSettings filterSettings, boolean numericDeltaOnly, String uniformPath, FindingsCalculationInfo calculationInfo) throws StorageException {
        IFindingsRetriever findingsRetriever = IFindingsRetriever.getFindingsRetriever(filterSettings.isOnlySpecItemFindings(), false, endCommit.getBranchName(), calculationInfo);
        FindingDelta findingDelta = FindingDeltaCalculator.computeUnfilteredDelta(uniformPath, startCommit, endCommit, numericDeltaOnly, findingsRetriever, calculationInfo);
        return ExtendedTrackedFindingUtils.fromFindingDelta(findingDelta, calculationInfo, findingsRetriever, endCommit).applyFilter(filterSettings, calculationInfo);
    }
}

