/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.findings.calculation.CodeFindingsRetriever;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class NonCodeBinarySizeElementFindingsRetriever
extends CodeFindingsRetriever {
    private static final Logger LOGGER = LogManager.getLogger();

    public static NonCodeBinarySizeElementFindingsRetriever create(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return new NonCodeBinarySizeElementFindingsRetriever(projectStorageSystem);
    }

    private NonCodeBinarySizeElementFindingsRetriever(ProjectStorageSystem projectStorageSystem) {
        super(projectStorageSystem);
    }

    @Override
    public List<TrackedFinding> getFindings(@NonNull String uniformPath, @NonNull CommitDescriptor commit) throws StorageException {
        PathLookupIndex pathLookupIndex;
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commit);
        TokenElementIndex tokenElementIndex = ResourceServiceUtils.openContentIndex(uniformPath, historyAccessOption, this.projectStorageSystem);
        Set<UniformPath> paths = NonCodeBinarySizeElementFindingsRetriever.lookupRelevantPathsFromElements(uniformPath, tokenElementIndex, pathLookupIndex = (PathLookupIndex)this.projectStorageSystem.openProjectIndex(PathLookupIndex.class, historyAccessOption));
        if (paths.isEmpty()) {
            return new ArrayList<TrackedFinding>();
        }
        TrackedFindingsIndex trackedFindingIndex = (TrackedFindingsIndex)this.projectStorageSystem.openProjectIndex(TrackedFindingsIndex.class, historyAccessOption);
        return trackedFindingIndex.getFindings(new ArrayList<UniformPath>(paths)).stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(finding -> finding.getSiblingLocations().isEmpty() || finding.getSiblingLocations().stream().anyMatch(element -> paths.contains(UniformPathCompatibilityUtil.convert((String)element.getUniformPath())))).toList();
    }

    private static @NonNull Set<UniformPath> lookupRelevantPathsFromElements(String uniformPath, TokenElementIndex tokenElementIndex, PathLookupIndex pathLookupIndex) throws StorageException {
        HashSet<UniformPath> paths = new HashSet<UniformPath>();
        HashMap<String, UniformPath> lookupCache = new HashMap<String, UniformPath>();
        PairList<String, TokenElementInfo> allElements = tokenElementIndex.getEntriesByPathPrefix(uniformPath);
        for (TokenElementInfo info : allElements.getSecondList()) {
            try {
                NonCodeLinkContent link = (NonCodeLinkContent)JsonUtils.deserializeFromJson((String)info.getText(), NonCodeLinkContent.class);
                if (lookupCache.containsKey(link.file())) continue;
                Optional<String> lookupResultOptional = pathLookupIndex.lookupBestPath(link.file());
                UniformPath lookupResult = lookupResultOptional.map(UniformPathCompatibilityUtil::convert).orElse(null);
                lookupCache.put(link.file(), lookupResult);
                if (lookupResult == null) continue;
                paths.add(lookupResult);
            }
            catch (JsonSerializationException e) {
                LOGGER.debug("Failed to parse content of {}", (Object)uniformPath, (Object)e);
            }
        }
        return paths;
    }

    public record NonCodeLinkContent(@JsonProperty String file, @JsonProperty int line) {
    }
}

