/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.outsourced_analysis;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.teamscale.core.findings.IndexFindingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.util.ParseLogMessage;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public record ClangTidyResultsTransport(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="findings") List<ClangTidyFindingTransport> findings, @JsonProperty(value="parseLogEntries") List<ParseLogMessage> parseLogEntries) implements Serializable
{
    public static ClangTidyResultsTransport emptyResult(String uniformPath) {
        return new ClangTidyResultsTransport(uniformPath, Collections.emptyList(), Collections.emptyList());
    }

    @IndexValueClass
    public record ClangTidyFindingTransport(@JsonProperty(value="groupName") @JsonPropertyDescription(value="The finding-group name") String groupName, @JsonProperty(value="categoryName") @JsonPropertyDescription(value="The finding-category name") String categoryName, @JsonProperty(value="message") @JsonPropertyDescription(value="The finding message (the title line in the findings detail page).\n\nThis text is in markdown format (e.g., <code>__bold__</code> will be\ndisplayed in bold font). To avoid that markdown symbols are interpreted, use\n{@link org.conqat.lib.commons.markup.MarkupUtils#escapeMarkdownRelevantSymbols(String)}\nbefore creating the {@link DetachedFinding}.\n") String message, @JsonProperty(value="location") TextRegionLocation location, @JsonProperty(value="language") ELanguage language, @JsonProperty(value="codeScopeName") String codeScopeName) implements Serializable
    {
        public IndexFinding asIndexFinding() {
            IndexFinding finding = new IndexFinding(this.groupName, this.categoryName, this.message, (ElementLocation)this.location);
            IndexFindingUtils.setGuidelineMapping((IndexFinding)finding, (String)this.groupName, (ELanguage)this.language);
            finding.setCodeScopeName(new CodeScopeName(this.codeScopeName));
            return finding;
        }
    }
}

