/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.cppcheck;

import com.google.common.collect.ImmutableMap;
import com.teamscale.index.findings.clangtidy.ShallowCodeFileRepresentation;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class LineOffsetConverterCache {
    private final ImmutableMap<String, ShallowCodeFileRepresentation> sourceFiles;
    private final Map<String, LineOffsetConverter> cache = new ConcurrentHashMap<String, LineOffsetConverter>();

    public LineOffsetConverterCache(Map<String, ShallowCodeFileRepresentation> sourceFiles) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, ShallowCodeFileRepresentation> entry : sourceFiles.entrySet()) {
            if (entry.getValue().isHidden()) continue;
            builder.put(entry);
        }
        this.sourceFiles = builder.build();
    }

    public Optional<LineOffsetConverter> getLineOffsetConverter(String uniformPath) {
        LineOffsetConverter cachedConverter = this.cache.get(uniformPath);
        if (cachedConverter != null) {
            return Optional.of(cachedConverter);
        }
        ShallowCodeFileRepresentation code = (ShallowCodeFileRepresentation)this.sourceFiles.get((Object)uniformPath);
        if (code == null) {
            return Optional.empty();
        }
        LineOffsetConverter converter = new LineOffsetConverter(code.textContent());
        this.cache.put(uniformPath, converter);
        return Optional.of(converter);
    }
}

