/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.eslint;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.teamscale.index.findings.UpdaterUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.options.CommandLineBase;
import org.conqat.lib.commons.string.StringUtils;

public class EsLintRulesExtractor
extends CommandLineBase<Exception> {
    private static final String MD_FILE_ENDING = ".md";
    private static final Pattern DEFAULT_ENABLEMENT_PATTERN = Pattern.compile("(?m).+ This rule .+ in the .+config.+");
    private static final Pattern VERSION_WARNING_PATTERN = Pattern.compile("(?s)> \ud83d\uded1 This file is source code, not the primary documentation location!.*?(\\R.*?){3}");
    private static final Pattern DO_NOT_EDIT_COMMENT_PATTERN = Pattern.compile("(?s)<!--.*?DO NOT EDIT.*?-->");
    private static final File ES_LINT_ROOT_DIRECTORY = new File("server/com.teamscale.index/src/main/resources/com/teamscale/index/configuration/tools/eslint/");
    private static final File ES_LINT_CHECK_MAPPINGS_FILE = new File(ES_LINT_ROOT_DIRECTORY, "check-mappings.tsv");
    private static final File ES_LINT_DESCRIPTIONS_DIRECTORY = new File("server/com.teamscale.index/check-descriptions/eslint");
    private static final File ES_LINT_TOOLS_DIRECTORY = new File("server/com.teamscale.index/tools/eslint");
    private static final File ES_LINT_PACKAGE_JSON = new File(ES_LINT_TOOLS_DIRECTORY, "package.json");
    private static final Pattern MD_LINK_PATTERN = Pattern.compile("\\[([^\\\\\\]]+)]\\(([^,)]+)\\)(?!;)");
    private static final Pattern YAML_HEADER_PATTERN = Pattern.compile("---(?<yamlHeader>.*?)---(?<markdown>.*)", 32);
    private static final Pattern DEFAULT_CONFIG_PATTERN = Pattern.compile("\n#+? (?:Default|Custom) Config\n.+?```json.*?\n.+?```\n\\s*<br>\n", 32);
    private static final Pattern AUTO_FIX_PATTERN = Pattern.compile("\ud83d\udd27 This rule is automatically fixable by the [`--fix` CLI option](https://eslint.org/docs/latest/user-guide/command-line-interface#--fix).", 16);
    private static final Pattern FIRST_LINE_SECTION_HEADER = Pattern.compile("^# (.+?)\n");
    private static final Pattern CONTAINER_PATTERN = Pattern.compile("(:::.*\\n\\n?)");

    public static void main(String[] args) throws Exception {
        EsLintRulesExtractor.execute(EsLintRulesExtractor::new, (String[])args);
    }

    public void run() throws Exception {
        ParsedPackageJson parsedVersions = EsLintRulesExtractor.parseVersions();
        this.extractEsLintSecurityRules(parsedVersions.esLintSecurityVersion());
        this.extractEsLintRules(parsedVersions.esLintVersion());
        this.extractEsLintTypescriptRules(parsedVersions.esLintTypescriptVersion());
        this.extractEsLintReactRules(parsedVersions.esLintReactVersion());
        this.extractEsLintJsxA11yRules(parsedVersions.esLintJsxA11yVersion());
        this.extractEsLintAngularRules(parsedVersions.esLintAngularVersion());
        this.extractEsLintAngularTemplateRules(parsedVersions.esLintAngularTemplateVersion());
    }

    private static ParsedPackageJson parseVersions() throws IOException {
        JsonNode packageJson = JsonUtils.getObjectMapper().readTree(ES_LINT_PACKAGE_JSON);
        JsonNode dependencies = packageJson.get("dependencies");
        String esLintVersion = EsLintRulesExtractor.patchDependencyVersion(dependencies.get("eslint").asText());
        String esLintTypescriptVersion = EsLintRulesExtractor.patchDependencyVersion(dependencies.get("@typescript-eslint/eslint-plugin").asText());
        String esLintReactVersion = EsLintRulesExtractor.patchDependencyVersion(dependencies.get("eslint-plugin-react").asText());
        String esLintJsxA11yVersion = EsLintRulesExtractor.patchDependencyVersion(dependencies.get("eslint-plugin-jsx-a11y").asText());
        String esLintAngularVersion = EsLintRulesExtractor.patchDependencyVersion(dependencies.get("@angular-eslint/eslint-plugin").asText());
        String esLintAngularTemplateVersion = EsLintRulesExtractor.patchDependencyVersion(dependencies.get("@angular-eslint/eslint-plugin-template").asText());
        String esLintSecurityVersion = EsLintRulesExtractor.patchDependencyVersion(dependencies.get("eslint-plugin-security").asText());
        return new ParsedPackageJson(esLintVersion, esLintTypescriptVersion, esLintReactVersion, esLintJsxA11yVersion, esLintAngularVersion, esLintAngularTemplateVersion, esLintSecurityVersion);
    }

    private static String patchDependencyVersion(String version) {
        return StringUtils.stripPrefix((String)version, (String)"^");
    }

    private void extractEsLintRules(String version) throws IOException {
        EsLintRulesExtractor.printInfo((String)("Extracting ESLint rules for: " + version));
        this.extractEsLintLikeRules(version, "https://github.com/eslint/eslint.git", "docs/src/rules/", "", "eslint", EsLintRulesExtractor.resolvePagesLink("https://eslint.org/docs/rules/"));
    }

    private void extractEsLintTypescriptRules(String esLintTypescriptVersion) throws IOException {
        EsLintRulesExtractor.printInfo((String)("Extracting ESLint Typescript rules for: " + esLintTypescriptVersion));
        this.extractEsLintLikeRules(esLintTypescriptVersion, "https://github.com/typescript-eslint/typescript-eslint.git", "packages/eslint-plugin/docs/rules", "@typescript-eslint/", "@typescript-eslint", EsLintRulesExtractor.resolvePagesLink("https://typescript-eslint.io/rules/"));
    }

    private void extractEsLintReactRules(String esLintReactVersion) throws IOException {
        EsLintRulesExtractor.printInfo((String)("Extracting ESLint React rules for: " + esLintReactVersion));
        this.extractEsLintLikeRules(esLintReactVersion, "https://github.com/yannickcr/eslint-plugin-react.git", "docs/rules", "react/", "eslint-plugin-react", EsLintRulesExtractor.resolveGithubSourceLink("https://github.com/jsx-eslint/eslint-plugin-react/blob/master/docs/rules/"));
    }

    private void extractEsLintJsxA11yRules(String esLintJsxA11yVersion) throws IOException {
        EsLintRulesExtractor.printInfo((String)("Extracting ESLint JSX A11y rules for: " + esLintJsxA11yVersion));
        this.extractEsLintLikeRules(esLintJsxA11yVersion, "https://github.com/jsx-eslint/eslint-plugin-jsx-a11y.git", "docs/rules", "jsx-a11y/", "eslint-plugin-jsx-a11y", EsLintRulesExtractor.resolveGithubSourceLink("https://github.com/jsx-eslint/eslint-plugin-jsx-a11y/blob/main/docs/rules/"));
    }

    private void extractEsLintAngularRules(String esLintAngularVersion) throws IOException {
        EsLintRulesExtractor.printInfo((String)("Extracting ESLint Angular rules for: " + esLintAngularVersion));
        this.extractEsLintLikeRules(esLintAngularVersion, "https://github.com/angular-eslint/angular-eslint.git", "packages/eslint-plugin/docs/rules", "@angular-eslint/", "@angular-eslint", EsLintRulesExtractor.resolveGithubSourceLink("https://github.com/angular-eslint/angular-eslint/blob/main/packages/eslint-plugin/docs/rules/"));
    }

    private void extractEsLintAngularTemplateRules(String esLintAngularTemplateVersion) throws IOException {
        EsLintRulesExtractor.printInfo((String)("Extracting ESLint Angular rules for: " + esLintAngularTemplateVersion));
        this.extractEsLintLikeRules(esLintAngularTemplateVersion, "https://github.com/angular-eslint/angular-eslint.git", "packages/eslint-plugin-template/docs/rules", "@angular-eslint/template/", "@angular-eslint/template", EsLintRulesExtractor.resolveGithubSourceLink("https://github.com/angular-eslint/angular-eslint/tree/main/packages/eslint-plugin-template/docs/rules/"));
    }

    private void extractEsLintSecurityRules(String version) throws IOException {
        EsLintRulesExtractor.printInfo((String)("Extracting eslint-plugin-security rules for: " + version));
        this.extractEsLintLikeRules(version, "https://github.com/eslint-community/eslint-plugin-security.git", "docs/rules", "security/", "eslint-plugin-security", EsLintRulesExtractor.resolveGithubSourceLink("https://github.com/eslint-community/eslint-plugin-security/blob/main/docs/rules/"));
    }

    private void extractEsLintLikeRules(String version, String repoUrl, String rulesDir, String ruleNamePrefix, String targetDir, MarkdownLinkResolver markdownLinkResolver) throws IOException {
        List checkMappings = FileSystemUtils.readLinesUTF8((File)ES_LINT_CHECK_MAPPINGS_FILE);
        Path targetDirPath = Paths.get(FileSystemUtils.TEMP_DIR_PATH, ((Object)((Object)this)).getClass().getSimpleName(), targetDir);
        File esLintGitDirectory = UpdaterUtils.cloneOrUpdateRepository(repoUrl, targetDirPath, "v" + version);
        File rulesDirectory = new File(esLintGitDirectory, rulesDir);
        for (File ruleFile : Objects.requireNonNull(rulesDirectory.listFiles((ignored, name) -> name.endsWith(MD_FILE_ENDING) && !name.equalsIgnoreCase("readme.md")))) {
            EsLintRulesExtractor.processEsLintLikeRule(ruleFile, checkMappings, ruleNamePrefix, targetDir, markdownLinkResolver);
        }
        checkMappings.subList(1, checkMappings.size()).sort(Comparator.naturalOrder());
        FileSystemUtils.writeLines((File)ES_LINT_CHECK_MAPPINGS_FILE, (Collection)checkMappings, (Charset)StandardCharsets.UTF_8);
    }

    private static void processEsLintLikeRule(File ruleFile, List<String> checkMappings, String ruleNamePrefix, String targetDir, MarkdownLinkResolver markdownLinkResolver) throws IOException {
        String ruleName = ruleNamePrefix + StringUtils.stripSuffix((String)ruleFile.getName(), (String)MD_FILE_ENDING);
        EsLintRulesExtractor.printInfo((String)("Processing rule: " + ruleName));
        String patchedRule = EsLintRulesExtractor.patchEsLintRuleDescription(ruleName, FileSystemUtils.readFileUTF8((File)ruleFile), markdownLinkResolver);
        FileSystemUtils.writeFileUTF8((File)new File(new File(ES_LINT_DESCRIPTIONS_DIRECTORY, targetDir), ruleFile.getName()), (String)patchedRule);
        if (checkMappings.stream().noneMatch(mapping -> mapping.startsWith(ruleName + "\t"))) {
            checkMappings.add(ruleName + "\t\tTODO\tTODO\tIGNORED");
        }
    }

    private static String patchEsLintRuleDescription(String ruleName, String rule, MarkdownLinkResolver markdownLinkResolver) {
        ESLintYamlHeader yamlHeader;
        Matcher yamlHeaderMatcher = YAML_HEADER_PATTERN.matcher((CharSequence)rule);
        if (yamlHeaderMatcher.matches()) {
            yamlHeader = ESLintYamlHeader.extractYamlHeader(yamlHeaderMatcher.group("yamlHeader"));
            rule = yamlHeaderMatcher.group("markdown");
        } else {
            yamlHeader = new ESLintYamlHeader();
        }
        if (yamlHeader.description != null) {
            rule = yamlHeader.description + (String)rule;
        }
        rule = ((String)rule).replace("<!-- end auto-generated rule header -->", "");
        rule = DO_NOT_EDIT_COMMENT_PATTERN.matcher((CharSequence)rule).replaceAll("");
        rule = VERSION_WARNING_PATTERN.matcher((CharSequence)rule).replaceAll("");
        rule = DEFAULT_ENABLEMENT_PATTERN.matcher((CharSequence)rule).replaceAll("");
        rule = AUTO_FIX_PATTERN.matcher((CharSequence)rule).replaceAll("");
        rule = DEFAULT_CONFIG_PATTERN.matcher((CharSequence)rule).replaceAll("");
        rule = CONTAINER_PATTERN.matcher((CharSequence)rule).replaceAll("");
        for (String marker : List.of("## Rule Options", "### Options", "## Options", "## How to Use")) {
            rule = EsLintRulesExtractor.removeMarkdownSection((String)rule, marker);
        }
        rule = EsLintRulesExtractor.replaceLinksToFiles(markdownLinkResolver, (String)rule);
        rule = ((String)rule).trim();
        rule = StringUtils.strip((String)rule, (String)"<br>").trim();
        rule = EsLintRulesExtractor.removeToplevelHeader(ruleName, (String)rule);
        rule = (String)rule + yamlHeader.furtherReading.stream().map(furtherReadingEntry -> "\n- " + furtherReadingEntry).collect(Collectors.joining("", "\n\n## References\n", ""));
        return (String)rule + "\n";
    }

    private static @NonNull String removeToplevelHeader(@NonNull String ruleName, @NonNull String rule) {
        Matcher matcher = FIRST_LINE_SECTION_HEADER.matcher(rule);
        if (!matcher.find()) {
            return rule;
        }
        String content = matcher.group(1);
        String tmpRule = matcher.replaceFirst("").trim();
        if (content.equalsIgnoreCase("`" + ruleName + "`") || content.equalsIgnoreCase(ruleName)) {
            return tmpRule;
        }
        return matcher.replaceFirst(content.replace(" (`" + ruleName + "`)", ".")).trim();
    }

    private static String replaceLinksToFiles(MarkdownLinkResolver markdownLinkResolver, String rule) {
        Matcher matcher = MD_LINK_PATTERN.matcher(rule);
        return matcher.replaceAll(match -> EsLintRulesExtractor.replaceMatchingMarkdownLinks(markdownLinkResolver, match));
    }

    private static MarkdownLinkResolver resolvePagesLink(String baseUri) {
        return (ruleName, fileName) -> {
            if ((fileName = fileName.replace(MD_FILE_ENDING, "")).startsWith("#") || fileName.startsWith("/README")) {
                return "\"" + ruleName + "\"";
            }
            return "[" + ruleName + "](" + String.valueOf(URI.create(baseUri).resolve(fileName)) + ")";
        };
    }

    private static MarkdownLinkResolver resolveGithubSourceLink(String baseUri) {
        return (ruleName, fileName) -> {
            if (fileName.startsWith("#") || fileName.startsWith("/README")) {
                return "\"" + ruleName + "\"";
            }
            return "[" + ruleName + "](" + String.valueOf(URI.create(baseUri).resolve(fileName)) + ")";
        };
    }

    private static String replaceMatchingMarkdownLinks(MarkdownLinkResolver markdownLinkResolver, MatchResult match) {
        if (match.group(2).contains("http")) {
            return match.group();
        }
        String ruleName = match.group(1);
        String fileName = match.group(2);
        return markdownLinkResolver.resolveLink(ruleName, fileName);
    }

    private static String removeMarkdownSection(String rule, String marker) {
        int headingLevel = (int)marker.chars().takeWhile(c -> c == 35).count();
        int index = ((String)rule).indexOf("\n" + marker);
        if (index >= 0) {
            int endIndex = ((String)rule).indexOf("\n" + StringUtils.repeat((String)"#", (int)headingLevel) + " ", index + 1);
            rule = endIndex >= 0 ? ((String)rule).substring(0, index) + ((String)rule).substring(endIndex) : ((String)rule).substring(0, index);
        }
        return rule;
    }

    private record ParsedPackageJson(String esLintVersion, String esLintTypescriptVersion, String esLintReactVersion, String esLintJsxA11yVersion, String esLintAngularVersion, String esLintAngularTemplateVersion, String esLintSecurityVersion) {
    }

    @FunctionalInterface
    private static interface MarkdownLinkResolver {
        public String resolveLink(String var1, String var2);
    }

    private static class ESLintYamlHeader {
        @JsonProperty(value="further_reading")
        private List<String> furtherReading = CollectionUtils.emptyList();
        @JsonProperty(value="description")
        private String description;

        private ESLintYamlHeader() {
        }

        private static ESLintYamlHeader extractYamlHeader(String input) {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                return (ESLintYamlHeader)mapper.readValue(input, ESLintYamlHeader.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to parse yaml:\n%s".formatted(input), e);
            }
        }
    }
}

