/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import com.teamscale.index.gitbridge.GitBridgeException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFile;
import org.conqat.lib.commons.filesystem.ZipFileUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class AbapGitImporterUtils {
    public static final String ABAP_SOURCES_PREFIX = "sources/";
    public static final String DELETED_ELEMENTS_XML_FILE = "deleted.xml";
    public static final String MOVED_ELEMENTS_XML_FILE = "moved.xml";
    public static final String CHANGED_PACKAGE_PATHS_XML_FILE = "changed_packages.xml";
    public static final String EXPORT_META_DATA_XML_FILE = "export_meta_data.xml";
    public static final String EXPORT_LOG_FILE = "export_log.txt";
    private static final String EXPORT_LOG_DATE_TIME_FORMAT = "MM/dd/yyyy HH:mm:ss";
    private static final DateTimeFormatter EXPORT_LOG_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss");
    public static final int DEFAULT_MAX_COMMIT_GAP_SECONDS = 180;
    private static final Pattern ZIP_TIMESTAMP_PATTERN = Pattern.compile(".*(\\d{8}-\\d{6})(\\d{3})?.*\\.zip");
    private static final Pattern ZIP_SYSID_PATTERN = Pattern.compile(".*_([A-Z][A-Z0-9]{2})_.*\\.zip");
    public static final String ZIP_TIMESTAMP_FORMAT = "yyyyMMdd-HHmmssSSS";
    public static final DateTimeFormatter ZIP_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmssSSS");

    static Instant getZipFileDate(File zipFile) {
        Matcher matcher = ZIP_TIMESTAMP_PATTERN.matcher(zipFile.getName());
        if (!matcher.matches()) {
            return null;
        }
        String timestamp = matcher.group(1) + StringUtils.defaultIfNull((String)matcher.group(2), (String)"000");
        try {
            return ZonedDateTime.of(LocalDateTime.parse(timestamp, ZIP_TIMESTAMP_FORMATTER), ZoneId.systemDefault()).toInstant();
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    static Optional<String> getZipFileSystemId(File zipFile) {
        Matcher matcher = ZIP_SYSID_PATTERN.matcher(zipFile.getName());
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(matcher.group(1));
    }

    public static List<CanonicalFile> getSortedExportZips(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException(directory.getAbsolutePath() + " is not a directory.");
        }
        File[] zipFiles = directory.listFiles(file -> file.getName().toLowerCase().endsWith(".zip") && AbapGitImporterUtils.getZipFileDate(file) != null);
        if (zipFiles == null) {
            throw new IOException("Unable to read from collection location " + directory.getAbsolutePath());
        }
        Arrays.sort(zipFiles, Comparator.comparing(AbapGitImporterUtils::getZipFileDate));
        return CollectionUtils.mapWithException(Arrays.asList(zipFiles), CanonicalFile::new);
    }

    public static String readContent(ZipFile zipFile, String entryName, Charset encoding) throws GitBridgeException {
        try {
            return new String(ZipFileUtils.readZipEntryContent((ZipFile)zipFile, (String)entryName), encoding);
        }
        catch (IOException e) {
            throw new GitBridgeException("Can't read entry " + entryName + " of zip file " + zipFile.getName(), e);
        }
    }

    public static String readTextContent(ZipFile zipFile, String entryName) throws GitBridgeException {
        return AbapGitImporterUtils.readContent(zipFile, entryName, AbapUtils.ABAP_ENCODING);
    }

    public static String readXmlContent(ZipFile zipFile, String entryName) throws GitBridgeException {
        return AbapGitImporterUtils.readContent(zipFile, entryName, StandardCharsets.UTF_8);
    }

    public static ParsedAbapElementPath buildParsedAbapElementPath(String path) throws GitBridgeException {
        try {
            return new ParsedAbapElementPath(path);
        }
        catch (ConQATException e) {
            throw new GitBridgeException("Can not parse work tree path " + path + " - Work tree may be inconsistent.", e);
        }
    }

    public static ZoneOffset buildTimeZone(String syTzone) {
        if (StringUtils.isEmpty((String)syTzone)) {
            return ZonedDateTime.now().getOffset();
        }
        try {
            int sapOffset = Integer.parseInt(syTzone);
            return ZoneOffset.ofTotalSeconds(sapOffset);
        }
        catch (NumberFormatException | DateTimeException e) {
            return ZonedDateTime.now().getOffset();
        }
    }

    public static void archiveAbapZip(File file, File archiveDirectory) throws GitBridgeException {
        if (archiveDirectory == null) {
            return;
        }
        File destinationPath = new File(archiveDirectory, file.getName());
        try {
            FileSystemUtils.ensureDirectoryExists((File)archiveDirectory);
            FileSystemUtils.renameFileTo((File)file, (File)destinationPath);
        }
        catch (IOException e) {
            throw new GitBridgeException("Can't archive " + String.valueOf(file) + " to " + String.valueOf(archiveDirectory) + ". ", e);
        }
    }

    public static OffsetDateTime buildExportLogDate(String logTime, ZoneOffset zoneOffset) {
        return OffsetDateTime.of(LocalDateTime.parse(logTime, EXPORT_LOG_DATE_TIME_FORMATTER), zoneOffset);
    }

    public static boolean isZipFileContainingAbapSources(ZipFile zipFile) {
        Enumeration entries = zipFile.getEntries();
        while (entries.hasMoreElements()) {
            if (!((ZipArchiveEntry)entries.nextElement()).getName().startsWith(ABAP_SOURCES_PREFIX)) continue;
            return true;
        }
        return false;
    }
}

