/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.helper;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class ImageUtil {
    public static BufferedImage createBufferedImage(byte[] imageBytes) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
        return ImageIO.read(inputStream);
    }

    public static BufferedImage convertToRGB(BufferedImage image) {
        BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        rgbImage.getGraphics().drawImage(image, 0, 0, null);
        return rgbImage;
    }

    public static byte[] createJpegBytes(BufferedImage image) throws IOException {
        if (image.getColorModel().hasAlpha()) {
            image = ImageUtil.convertToRGB(image);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam param = writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionQuality(0.95f);
        MemoryCacheImageOutputStream imageOutputStream = new MemoryCacheImageOutputStream(outputStream);
        writer.setOutput(imageOutputStream);
        writer.write(null, new IIOImage(image, null, null), param);
        writer.dispose();
        imageOutputStream.close();
        return outputStream.toByteArray();
    }
}

