/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.gitlab;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.utils.MarkdownUtils;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.AlwaysEnabledCleanupStrategy;
import com.teamscale.index.issues.cleanup.OnceEveryDayCleanupStrategy;
import com.teamscale.index.issues.cleanup.WorkItemCleaner;
import com.teamscale.index.issues.gitlab.client.GitLabIssueClient;
import com.teamscale.index.issues.gitlab.client.model.EGitLabIssueState;
import com.teamscale.index.issues.gitlab.client.model.GitLabIssue;
import com.teamscale.index.issues.gitlab.client.model.GitLabUser;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;

public abstract class GitLabSynchronizerBase<T extends TeamscaleIssue>
extends IssueTrackerSynchronizerBase<T> {
    public static final String LABELS_PARAMETER = "labels";
    @TestOnly
    public static final String CLEANUP_ALWAYS_ENABLED_PARAMETER = "cleanup-always-enabled";
    @StepParameter(value="labels", optional=true)
    private Set<String> labels = new HashSet<String>();
    @StepParameter(value="cleanup-always-enabled", optional=true)
    private boolean cleanupAlwaysEnabled = false;
    @StepParameterObject
    private final OnceEveryDayCleanupStrategy cleanupStrategy = new OnceEveryDayCleanupStrategy();
    private GitLabIssueClient client;
    private URI baseUrl;

    @Override
    protected void init() throws BugTrackerException {
        this.client = new GitLabIssueClient(this.getUrl(), this.getPassword(), LogManager.getLogger(((Object)((Object)this)).getClass()));
        this.baseUrl = URI.create(StringUtils.ensureEndsWith((String)this.getUrl(), (String)"/"));
        Preconditions.checkState((this.projects.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly one project, but got %s: %s", (int)this.projects.size(), (Object)this.projects);
    }

    @Override
    protected IssueTrackerSynchronizerBase.WorkItemUpdateResult retrieveUpdatedItems(long lastScanTimestamp, long startTimestamp, long onlyItemsChangedAfterTimestamp) throws BugTrackerException, StorageException {
        IssueTrackerSynchronizerBase.WorkItemUpdateResult.Builder resultBuilder = this.resultBuilder();
        Instant updateAfter = Instant.ofEpochMilli(Math.max(lastScanTimestamp, onlyItemsChangedAfterTimestamp));
        Instant lastScan = Instant.ofEpochMilli(lastScanTimestamp);
        Instant historyStart = Instant.ofEpochMilli(startTimestamp);
        try {
            IStreamWithException.of(Exception.class, (Object)((String)Iterables.getOnlyElement((Iterable)this.projects)), (Object[])new String[0]).flatMap(project -> this.client.getIssues((String)project, (Collection<String>)this.labels, updateAfter)).flatMap(gitlabIssue -> this.getHistoryEntries((GitLabIssue)gitlabIssue, lastScan, historyStart)).map(issue -> this.createIssue((GitLabIssue)issue, startTimestamp)).forEach(resultBuilder::addItem);
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException("Failed to load issues", e);
        }
        catch (RuntimeException | StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError("Unexpected Exception", e);
        }
        return resultBuilder.addDeletions(this.performCleanupIfNecessary()).build();
    }

    private IStreamWithException<GitLabIssue, ServiceCallException> getHistoryEntries(GitLabIssue gitlabIssue, Instant lastScan, Instant historyStart) throws ServiceCallException {
        return (IStreamWithException)IStreamWithException.concat(this.withStateChanges(gitlabIssue), (IStreamWithException[])new IStreamWithException[]{GitLabSynchronizerBase.atCurrentState(gitlabIssue)}).filter(issue -> issue.updatedAt().isAfter(lastScan)).distinctBy(GitLabIssue::updatedAt).collect(GitLabSynchronizerBase.toHistoryStream(historyStart));
    }

    private static Collector<GitLabIssue, ?, IStreamWithException<GitLabIssue, ServiceCallException>> toHistoryStream(Instant historyStart) {
        Predicate<GitLabIssue> isBeforeHistoryStart = issue -> issue.updatedAt().isBefore(historyStart);
        return Collectors.teeing(Collectors.filtering(isBeforeHistoryStart, Collectors.maxBy(Comparator.comparing(GitLabIssue::updatedAt))), Collectors.filtering(Predicate.not(isBeforeHistoryStart), Collectors.toList()), (min, list) -> IStreamWithException.wrap(Stream.concat(min.stream(), list.stream()), ServiceCallException.class));
    }

    private IStreamWithException<GitLabIssue, ServiceCallException> withStateChanges(GitLabIssue gitlabIssue) {
        return IStreamWithException.concat(GitLabSynchronizerBase.atInitialState(gitlabIssue), (IStreamWithException[])new IStreamWithException[]{this.atIntermediateStates(gitlabIssue)});
    }

    private static IStreamWithException<GitLabIssue, ServiceCallException> atInitialState(GitLabIssue gitlabIssue) {
        return IStreamWithException.wrap(Stream.of(gitlabIssue.atCreation()), ServiceCallException.class);
    }

    private IStreamWithException<GitLabIssue, ServiceCallException> atIntermediateStates(GitLabIssue gitlabIssue) {
        return this.client.getStateChangeEvents(gitlabIssue).map(gitlabIssue::withStateChange);
    }

    private static IStreamWithException<GitLabIssue, ServiceCallException> atCurrentState(GitLabIssue gitlabIssue) {
        return IStreamWithException.of(ServiceCallException.class, (Object)gitlabIssue, (Object[])new GitLabIssue[0]);
    }

    protected abstract T createIssue(GitLabIssue var1, long var2);

    private Map<TeamscaleIssueId, Long> performCleanupIfNecessary() throws StorageException, BugTrackerException {
        try {
            WorkItemCleaner workItemCleaner = this.cleanupAlwaysEnabled ? new WorkItemCleaner(this.getWorkItemIndex(), this.getIssueHistoryIndex(), this.getConnectorId(), new AlwaysEnabledCleanupStrategy()) : new WorkItemCleaner(this.getWorkItemIndex(), this.getIssueHistoryIndex(), this.getConnectorId(), this.cleanupStrategy);
            return workItemCleaner.performCleanupIfNecessary(this.getCurrentImportStart(), () -> this.client.retrieveAllIssueIds((String)Iterables.getOnlyElement((Iterable)this.projects)));
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException("Failed to perform issue index cleanup. Failed to load issues.", e);
        }
    }

    protected final TeamscaleIssue createTeamscaleIssue(GitLabIssue gitlabIssue, long startTimestamp) {
        Map<String, Pair<EKeyedObjectType, String>> additionalFields = GitLabSynchronizerBase.getAdditionalFields(gitlabIssue);
        ArrayList<String> additionalFieldNames = new ArrayList<String>(additionalFields.size());
        ArrayList<String> additionalFieldValues = new ArrayList<String>(additionalFields.size());
        for (Map.Entry<String, Pair<EKeyedObjectType, String>> additionalFieldEntry : additionalFields.entrySet()) {
            additionalFieldNames.add(additionalFieldEntry.getKey());
            additionalFieldValues.add((String)additionalFieldEntry.getValue().getSecond());
        }
        URI projectUrl = this.baseUrl.resolve("-/project/" + gitlabIssue.projectId() + "/");
        return new TeamscaleIssue(new TeamscaleIssueId(this.getConnectorId(), String.valueOf(gitlabIssue.issueId())), gitlabIssue.title(), (String)gitlabIssue.assignees().stream().map(GitLabUser::username).findFirst().orElse(null), gitlabIssue.author().username(), MarkdownUtils.translateMarkdownToHtml((String)gitlabIssue.description(), (URI)projectUrl), gitlabIssue.createdAt().toEpochMilli(), Math.max(gitlabIssue.updatedAt().toEpochMilli(), startTimestamp), gitlabIssue.state().getHumanReadable(), gitlabIssue.state() == EGitLabIssueState.CLOSED, gitlabIssue.webUrl().toString(), additionalFieldNames, additionalFieldValues, null);
    }

    private static Map<String, Pair<EKeyedObjectType, String>> getAdditionalFields(GitLabIssue gitlabIssue) {
        LinkedHashMap<String, Pair<EKeyedObjectType, String>> result = new LinkedHashMap<String, Pair<EKeyedObjectType, String>>();
        result.put("Type", new Pair((Object)EKeyedObjectType.STRING, (Object)gitlabIssue.issueType().getHumanReadable()));
        if (!gitlabIssue.labels().isEmpty()) {
            result.put("Labels", (Pair<EKeyedObjectType, String>)new Pair((Object)EKeyedObjectType.STRING_LIST, (Object)gitlabIssue.labels().stream().sorted().collect(Collectors.joining(", "))));
        }
        if (gitlabIssue.closedAt() != null) {
            result.put("Closed At", (Pair<EKeyedObjectType, String>)new Pair((Object)EKeyedObjectType.STRING, (Object)gitlabIssue.closedAt().toString()));
        }
        if (gitlabIssue.closedBy() != null) {
            result.put("Closed By", (Pair<EKeyedObjectType, String>)new Pair((Object)EKeyedObjectType.STRING, (Object)gitlabIssue.closedBy().name()));
        }
        return result;
    }
}

