/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.jira.model.JiraJsonIssue;
import com.teamscale.index.issues.jira.parser.JiraCustomSprintFieldParser;
import com.teamscale.wia.ExternalToolIssueCustomField;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.ListMapCollector;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class JiraIssueParser<T extends TeamscaleIssue> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ISSUES_KEY = "issues";
    private static final String NAME_KEY = "name";
    private static final String DISPLAY_NAME_KEY = "displayName";
    private static final String VALUE_KEY = "value";
    private static final String DEV_STATUS_PREFIX = "{summaryBean=com.atlassian.jira.plugin.devstatus";
    private static final String NOT_SUPPORTED_VALUE = "Unsupported value";
    private static final String FIELDS_KEY = "fields";
    private static final String CUSTOM_FIELD_SPRINT_NAME = "Sprint";
    public static final List<String> FIELDS = Arrays.asList("summary", "assignee", "reporter", "description", "created", "updated", "status", "resolution", "priority", "issuetype", "issuelinks", "components", "fixVersions", "labels");
    private final String detailsUrl;
    private final String connectorId;
    private final List<ExternalToolIssueCustomField> customFields;
    private final Map<String, ExternalToolIssueCustomField> customJiraFieldsById;
    private final long startTimestamp;
    private final long lastScanTimestamp;
    private final long onlyItemsChangedAfterTimestamp;
    private final Map<String, String> issueTypeToAbbreviation;
    private final IJiraIssueCreator<T> issueCreator;
    private final FunctionWithException<List<TeamscaleIssueId>, Set<TeamscaleIssueId>, StorageException> filterToUnknownIssues;

    public JiraIssueParser(String url, String connectorId, List<ExternalToolIssueCustomField> customFields, long startTimestamp, long lastScanTimestamp, long onlyItemsChangedAfterTimestamp, Map<String, String> issueTypeToAbbreviation, IJiraIssueCreator<T> issueCreator, FunctionWithException<List<TeamscaleIssueId>, Set<TeamscaleIssueId>, StorageException> filterToUnknownIssues) {
        this.detailsUrl = url;
        this.connectorId = connectorId;
        this.customFields = customFields;
        this.startTimestamp = startTimestamp;
        this.lastScanTimestamp = lastScanTimestamp;
        this.onlyItemsChangedAfterTimestamp = onlyItemsChangedAfterTimestamp;
        this.issueTypeToAbbreviation = issueTypeToAbbreviation;
        this.issueCreator = issueCreator;
        this.filterToUnknownIssues = filterToUnknownIssues;
        this.customJiraFieldsById = customFields.stream().collect(Collectors.toMap(ExternalToolIssueCustomField::getId, x -> x));
    }

    public PairList<Long, T> parseIssues(List<String> issueJsons) throws BugTrackerException, StorageException {
        try {
            PairList result = new PairList();
            List parsedIssueJsons = CollectionUtils.mapWithException(issueJsons, JiraIssueParser::parseJson);
            List jiraJsonIssues = CollectionUtils.mapWithException(issueJsons, json -> (JiraJsonIssue)JsonUtils.deserializeFromJson((String)json, JiraJsonIssue.class));
            List includedIssueIds = CollectionUtils.map((Collection)jiraJsonIssues, issue -> new TeamscaleIssueId(this.connectorId, issue.key));
            Set newIssues = (Set)this.filterToUnknownIssues.apply((Object)includedIssueIds);
            for (int i = 0; i < parsedIssueJsons.size(); ++i) {
                result.addAll(this.parseIssueWithHistory((JsonNode)parsedIssueJsons.get(i), (JiraJsonIssue)jiraJsonIssues.get(i), newIssues));
            }
            return result;
        }
        catch (JsonSerializationException e) {
            throw new BugTrackerException("Failed to parse JSON: " + e.getMessage(), e);
        }
    }

    private PairList<Long, T> parseIssueWithHistory(JsonNode jsonNode, JiraJsonIssue jiraIssue, Set<TeamscaleIssueId> newIssues) {
        String key = jiraIssue.key;
        PairList<String, String> customFields = this.parseCustomFields(JiraIssueParser.getObject(jsonNode, FIELDS_KEY), key);
        T teamscaleIssue = this.issueCreator.createIssue(jiraIssue, this.detailsUrl + key, (List<String>)customFields.getFirstList(), (List<String>)customFields.getSecondList(), this.issueTypeToAbbreviation);
        if (teamscaleIssue.getUpdated() < this.onlyItemsChangedAfterTimestamp) {
            return PairList.emptyPairList();
        }
        if (jiraIssue.changeLog == null) {
            return PairList.from((Object)teamscaleIssue.getUpdated(), teamscaleIssue);
        }
        boolean isNew = newIssues.contains(teamscaleIssue.getId());
        long notBeforeTimestamp = this.lastScanTimestamp;
        if (isNew) {
            notBeforeTimestamp = this.startTimestamp;
        }
        return this.processIssueHistory(teamscaleIssue, jiraIssue.changeLog, ++notBeforeTimestamp, isNew);
    }

    private PairList<Long, T> processIssueHistory(T issue, JiraJsonIssue.ChangeLog changeLog, long notBeforeTimestamp, boolean addEntryAtBoundaryTimestamp) {
        PairList result = new PairList();
        T issueCopy = issue;
        Object previous = null;
        Optional<Object> boundaryEntry = Optional.empty();
        if (changeLog.histories != null) {
            List<JiraJsonIssue.HistoryEntry> histories = JiraIssueParser.sortAndMergeChangeLog(changeLog);
            for (JiraJsonIssue.HistoryEntry historyEntry : histories) {
                if (historyEntry.created.getTime() < notBeforeTimestamp) {
                    boundaryEntry = Optional.of(historyEntry);
                    break;
                }
                issueCopy.setUpdated(historyEntry.created.getTime());
                result.add((Object)issueCopy.getUpdated(), issueCopy);
                previous = issueCopy;
                issueCopy = this.applyHistoryEntry(issueCopy, historyEntry);
            }
        }
        if (addEntryAtBoundaryTimestamp && boundaryEntry.isPresent()) {
            if (previous != null) {
                issueCopy = this.applyHistoryEntry(issueCopy, (JiraJsonIssue.HistoryEntry)boundaryEntry.get());
            }
            result.add((Object)notBeforeTimestamp, issueCopy);
        } else if (issueCopy.getCreated() >= notBeforeTimestamp && (previous == null || previous.getUpdated() > issueCopy.getCreated())) {
            issueCopy.setUpdated(issueCopy.getCreated());
            result.add((Object)issueCopy.getUpdated(), issueCopy);
        }
        return result;
    }

    private static List<JiraJsonIssue.HistoryEntry> sortAndMergeChangeLog(JiraJsonIssue.ChangeLog changeLog) {
        List histories = CollectionUtils.sort(Arrays.asList(changeLog.histories), Comparator.comparing(entry -> entry.created).reversed());
        ArrayList<JiraJsonIssue.HistoryEntry> result = new ArrayList<JiraJsonIssue.HistoryEntry>();
        for (JiraJsonIssue.HistoryEntry history : histories) {
            JiraJsonIssue.HistoryEntry lastEntry = (JiraJsonIssue.HistoryEntry)CollectionUtils.getLast(result);
            if (lastEntry == null || lastEntry.created.after(history.created)) {
                result.add(history);
                continue;
            }
            lastEntry.mergeIn(history);
        }
        return result;
    }

    private T applyHistoryEntry(T issue, JiraJsonIssue.HistoryEntry historyEntry) {
        TeamscaleIssue result = Objects.requireNonNull((TeamscaleIssue)SerializationUtils.cloneBySerialization(issue));
        block14: for (JiraJsonIssue.HistoryChangeItem item : historyEntry.items) {
            String value = item.fromString;
            switch (item.field) {
                case "summary": {
                    result.setSubject(value);
                    continue block14;
                }
                case "assignee": {
                    result.setAssignee(value);
                    continue block14;
                }
                case "reporter": {
                    result.setAuthor(value);
                    continue block14;
                }
                case "status": {
                    result.setStatus(value);
                    continue block14;
                }
                case "resolution": {
                    result.setClosed(value != null);
                    continue block14;
                }
                default: {
                    if (!"custom".equals(item.fieldType)) continue block14;
                    this.applyCustomFieldEntry(result, item);
                }
            }
        }
        return (T)result;
    }

    private void applyCustomFieldEntry(TeamscaleIssue result, JiraJsonIssue.HistoryChangeItem item) {
        ExternalToolIssueCustomField customJiraField = this.customJiraFieldsById.get(item.field);
        if (customJiraField != null) {
            result.setCustomField(customJiraField.getName(), item.fromString);
        }
    }

    private PairList<String, String> parseCustomFields(JsonNode jsonNode, String key) {
        PairList customFieldValues = new PairList();
        ListMap namesToCustomFields = (ListMap)this.customFields.stream().collect(ListMapCollector.groupingBy(ExternalToolIssueCustomField::getName));
        for (Map.Entry customField : namesToCustomFields) {
            String fieldName = (String)customField.getKey();
            String fieldValue = JiraIssueParser.getValueForCustomField(jsonNode, (String)customField.getKey(), (List)customField.getValue(), key);
            customFieldValues.add((Object)fieldName, (Object)fieldValue);
        }
        return customFieldValues;
    }

    private static String getValueForCustomField(JsonNode jsonNode, String fieldName, List<ExternalToolIssueCustomField> customFields, String issueKey) {
        LOGGER.traceEntry("Parsing value of custom field. Issue ID: '{}', field name: '{}', field IDs: '{}', issue JSON: {}", new Object[]{issueKey, fieldName, CollectionUtils.map(customFields, ExternalToolIssueCustomField::getId), jsonNode});
        String value = null;
        String usedId = null;
        for (ExternalToolIssueCustomField field : customFields) {
            String fieldId = field.getId();
            if (!jsonNode.has(fieldId)) {
                LOGGER.debug("No custom field with id '{}' in issue '{}'. This is expected if the field does not exist for the project or the type of the issue. Continuing with other custom fields with the name '{}' but different ids.", (Object)fieldId, (Object)issueKey, (Object)fieldName);
                continue;
            }
            String newValue = JiraIssueParser.parseExistingCustomFieldValue(jsonNode, fieldId, fieldName, field.isUserName());
            if (value == null) {
                value = newValue;
                usedId = fieldId;
                continue;
            }
            LOGGER.info("Found multiple custom fields with name '{}' in issue '{}'. Using the first non-empty one.", (Object)fieldName, (Object)issueKey);
            if (!value.isEmpty() || newValue.isEmpty()) continue;
            value = newValue;
            usedId = fieldId;
        }
        if (value == null) {
            LOGGER.debug("No custom field with name '{}' in issue '{}'. Leaving field empty.", (Object)fieldName, (Object)issueKey);
            value = "";
        } else if (customFields.size() > 1) {
            LOGGER.debug("Multiple custom fields with name '{}' in Jira instance. Selected custom field with id '{}' for issue '{}'.", (Object)fieldName, usedId, (Object)issueKey);
        }
        return (String)LOGGER.traceExit("Value of custom field with name '" + fieldName + "' for issue '" + issueKey + "': '{}'", (Object)value);
    }

    private static String parseExistingCustomFieldValue(JsonNode jsonNode, String fieldId, String fieldName, boolean isUserName) {
        String result = isUserName ? JiraIssueParser.getName(jsonNode, fieldId) : JiraIssueParser.getStringOrEmpty(jsonNode, fieldId);
        if (fieldName.equals(CUSTOM_FIELD_SPRINT_NAME)) {
            result = JiraCustomSprintFieldParser.getSprintNamesOrEmpty(result);
        }
        return result;
    }

    private static String getStringOrEmpty(JsonNode jsonNode, String element) {
        if (jsonNode == null || jsonNode.isNull()) {
            return "";
        }
        return JiraIssueParser.getStringOrEmpty(jsonNode.get(element));
    }

    @VisibleForTesting
    static String getStringOrEmpty(JsonNode jsonElement) {
        if (jsonElement == null || jsonElement.isNull()) {
            return "";
        }
        if (jsonElement.isArray()) {
            return String.join((CharSequence)", ", JiraIssueParser.listNonEmptyValues(jsonElement));
        }
        if (jsonElement.isObject()) {
            if (jsonElement.has(NAME_KEY)) {
                return JiraIssueParser.getStringOrEmpty(jsonElement, NAME_KEY);
            }
            if (jsonElement.has(VALUE_KEY)) {
                return JiraIssueParser.getStringOrEmpty(jsonElement, VALUE_KEY);
            }
            return jsonElement.toString();
        }
        String result = StringUtils.removeDoubleQuotes((String)jsonElement.toString());
        if (result.startsWith(DEV_STATUS_PREFIX)) {
            return NOT_SUPPORTED_VALUE;
        }
        return result;
    }

    private static List<String> listNonEmptyValues(JsonNode jsonElement) {
        ArrayList<String> nonEmptyValues = new ArrayList<String>();
        for (JsonNode child : jsonElement) {
            String childString = JiraIssueParser.getStringOrEmpty(child);
            if (StringUtils.isEmpty((String)childString)) continue;
            nonEmptyValues.add(childString);
        }
        return nonEmptyValues;
    }

    private static JsonNode getObject(JsonNode jsonNode, String element) {
        JsonNode jsonElement = jsonNode.get(element);
        if (jsonElement.isNull()) {
            return null;
        }
        return jsonNode.get(element);
    }

    private static String getName(JsonNode jsonNode, String element) {
        String name = JiraIssueParser.getStringOrEmpty(JiraIssueParser.getObject(jsonNode, element), NAME_KEY);
        if (name.isEmpty()) {
            name = JiraIssueParser.getStringOrEmpty(JiraIssueParser.getObject(jsonNode, element), DISPLAY_NAME_KEY);
        }
        return name;
    }

    public static JsonNode parseJson(String json) throws BugTrackerException {
        try {
            return Optional.ofNullable(JsonUtils.deserializeFromJson((String)json)).orElseThrow(() -> new BugTrackerException("Could not deserialize json (truncated): " + StringUtils.truncateWithThreeDots((String)json, (int)50)));
        }
        catch (JsonSerializationException e) {
            throw new BugTrackerException("Could not deserialize json (truncated): " + StringUtils.truncateWithThreeDots((String)json, (int)50), e);
        }
    }

    public static PairList<String, String> splitJsonToIssues(String json) throws BugTrackerException {
        JsonNode jsonNode = JiraIssueParser.parseJson(json);
        ArrayNode issuesArray = (ArrayNode)jsonNode.get(ISSUES_KEY);
        if (issuesArray == null) {
            LOGGER.warn("Encountered unexpected null value in {}: {}", (Object)ISSUES_KEY, (Object)StringUtils.truncateWithThreeDots((String)json, (int)50));
            return PairList.emptyPairList();
        }
        List<JsonNode> issuesJsonNodes = JiraIssueParser.convertToJsonNodes(issuesArray);
        PairList issueKeyToJson = new PairList();
        for (JsonNode issueNode : issuesJsonNodes) {
            JsonNode key = issueNode.get("key");
            if (key == null) {
                LOGGER.warn("Ignoring malformed Jira ticket JSON without key field: " + StringUtils.truncateWithThreeDots((String)json, (int)50));
                continue;
            }
            String id = key.asText();
            issueKeyToJson.add((Object)id, (Object)issueNode.toString());
        }
        LOGGER.debug("Found {} issues in issue JSON.", (Object)issueKeyToJson.size());
        return issueKeyToJson;
    }

    private static List<JsonNode> convertToJsonNodes(ArrayNode issuesArray) {
        ArrayList<JsonNode> issuesJsonNodes = new ArrayList<JsonNode>();
        for (int i = 0; i < issuesArray.size(); ++i) {
            JsonNode jiraIssue = issuesArray.get(i);
            if (!jiraIssue.isObject()) {
                LOGGER.warn("Expected json object but found " + String.valueOf(jiraIssue) + ". Ignoring this issue.");
                continue;
            }
            issuesJsonNodes.add(jiraIssue);
        }
        return issuesJsonNodes;
    }

    @FunctionalInterface
    public static interface IJiraIssueCreator<T extends TeamscaleIssue> {
        public T createIssue(JiraJsonIssue var1, String var2, List<String> var3, List<String> var4, Map<String, String> var5);
    }
}

