/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments;

import com.teamscale.index.configuration.StructuringConfiguration;
import java.util.function.Function;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.region.OffsetBasedRegion;

public class FindingUtils {
    private static int applyTextRegionLocationFunctionOrDefault(TrackedFinding finding, Function<TextRegionLocation, Integer> fun, Integer defaultValue) {
        ElementLocation location = finding.getLocation();
        if (location instanceof TextRegionLocation) {
            return fun.apply((TextRegionLocation)location);
        }
        return defaultValue;
    }

    public static int getStartLine(TrackedFinding finding) {
        return FindingUtils.applyTextRegionLocationFunctionOrDefault(finding, TextRegionLocation::getRawStartLine, 1);
    }

    public static int getEndLine(TrackedFinding finding) {
        return FindingUtils.applyTextRegionLocationFunctionOrDefault(finding, TextRegionLocation::getRawEndLine, 1);
    }

    public static int getStartOffset(TrackedFinding finding) {
        return FindingUtils.applyTextRegionLocationFunctionOrDefault(finding, TextRegionLocation::getRawStartOffset, 1);
    }

    public static int getEndOffset(TrackedFinding finding) {
        return FindingUtils.applyTextRegionLocationFunctionOrDefault(finding, TextRegionLocation::getRawEndOffset, 1);
    }

    public static OffsetBasedRegion getFindingRegion(TrackedFinding finding) {
        return new OffsetBasedRegion(FindingUtils.getStartOffset(finding), FindingUtils.getEndOffset(finding));
    }

    public static boolean findingWasAddedInCommit(TrackedFinding finding, CommitDescriptor commit) {
        return finding.getBirthCommit().equals((Object)commit);
    }

    public static boolean isStructureFinding(TrackedFinding finding) {
        return FindingUtils.isDeepNestingFinding(finding) || FindingUtils.isLongMethodFinding(finding) || FindingUtils.isCyclomaticComplexityFinding(finding);
    }

    public static boolean isDeepNestingFinding(TrackedFinding finding) {
        return finding.getTypeId().equals(StructuringConfiguration.NESTING_DEPTH_TYPE_ID);
    }

    public static boolean isLongMethodFinding(TrackedFinding finding) {
        return finding.getTypeId().equals(StructuringConfiguration.METHOD_LENGTH_TYPE_ID);
    }

    public static boolean isCyclomaticComplexityFinding(TrackedFinding finding) {
        return finding.getTypeId().equals(StructuringConfiguration.COMPLEXITY_TYPE_ID);
    }
}

