/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments;

import com.teamscale.index.commit_alert.CommitAlert;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.repository.RepositoryOriginalPathIndex;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class RepositoryPathMapper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, String> uniformPathsToRepositoryPaths;

    public RepositoryPathMapper(RepositoryOriginalPathIndex.RepositoryOriginalPathView originalPathView, Set<String> uniformPaths) throws StorageException {
        this.uniformPathsToRepositoryPaths = originalPathView.getRepositoryPaths(List.copyOf(uniformPaths));
    }

    public RepositoryPathMapper(RepositoryOriginalPathIndex.RepositoryOriginalPathView originalPathView, List<TrackedFinding> findings) throws StorageException {
        Set uniformPaths = CollectionUtils.mapToSet(findings, finding -> finding.getLocation().getUniformPath());
        Set secondaryLocationUniformPaths = findings.stream().flatMap(finding -> finding.getSecondaryLocations().stream()).map(ElementLocation::getUniformPath).collect(Collectors.toSet());
        uniformPaths.addAll(secondaryLocationUniformPaths);
        this.uniformPathsToRepositoryPaths = originalPathView.getRepositoryPaths(List.copyOf(uniformPaths));
    }

    public RepositoryPathMapper(RepositoryOriginalPathIndex.RepositoryOriginalPathView mainOriginalPathView, RepositoryOriginalPathIndex.RepositoryOriginalPathView secondaryOriginalPathView, Set<String> uniformPaths) throws StorageException {
        List<String> uniformPathsAsList = List.copyOf(uniformPaths);
        this.uniformPathsToRepositoryPaths = mainOriginalPathView.getRepositoryPaths(uniformPathsAsList);
        Map<String, String> secondaryRepositoryPaths = secondaryOriginalPathView.getRepositoryPaths(uniformPathsAsList);
        this.uniformPathsToRepositoryPaths.forEach((key, value) -> {
            if (value == null && secondaryRepositoryPaths.containsKey(key)) {
                this.uniformPathsToRepositoryPaths.put((String)key, (String)secondaryRepositoryPaths.get(key));
            }
        });
    }

    public List<TrackedFinding> removeFindingsWithUnknownPaths(List<TrackedFinding> findings) {
        return findings.stream().filter(finding -> this.isKnownPath(finding.getLocation().getUniformPath())).collect(Collectors.toList());
    }

    public List<AssessedTgaData.AssessedMethodData> removeMethodsWithUnknownPaths(List<AssessedTgaData.AssessedMethodData> methods) {
        return methods.stream().filter(method -> this.isKnownPath(method.getLocation().getUniformPath())).collect(Collectors.toList());
    }

    public List<CommitAlert> removeAlertsWithUnknownPaths(List<CommitAlert> alerts) {
        return alerts.stream().filter(alert -> this.isKnownPath(alert.getContext().getExpectedCloneLocation().getUniformPath())).collect(Collectors.toList());
    }

    public boolean isKnownPath(String uniformPath) {
        return !StringUtils.isEmpty((String)this.uniformPathsToRepositoryPaths.get(uniformPath));
    }

    public List<RepositoryReviewComment> mapCommentsToRepositoryPaths(List<IReviewComment> reviewComments) {
        Stream<IReviewComment> reviewCommentsWithKnownLocations = reviewComments.stream().filter(comment -> {
            String uniformPath = comment.getLocation().getUniformPath();
            if (this.uniformPathsToRepositoryPaths.get(uniformPath) != null) {
                return true;
            }
            LOGGER.error("Cannot map uniform path: {}", (Object)uniformPath);
            return false;
        });
        ArrayList<RepositoryReviewComment> repositoryReviewComments = new ArrayList<RepositoryReviewComment>();
        reviewCommentsWithKnownLocations.forEach(reviewComment -> this.addToRepositoryReviewComments((IReviewComment)reviewComment, (List<RepositoryReviewComment>)repositoryReviewComments));
        return repositoryReviewComments;
    }

    private void addToRepositoryReviewComments(IReviewComment reviewComment, List<RepositoryReviewComment> repositoryReviewComments) {
        if (reviewComment.hasSecondaryLocations() && (reviewComment.isArchitectureReviewComment() || reviewComment.isKubernetesReviewComment())) {
            ElementLocation secondaryLocation = reviewComment.getSecondaryLocations().getFirst();
            String secondaryLocationPath = this.uniformPathsToRepositoryPaths.get(secondaryLocation.getUniformPath());
            repositoryReviewComments.add(new RepositoryReviewComment(reviewComment, secondaryLocationPath, secondaryLocation));
        } else {
            String primaryLocationPath = this.uniformPathsToRepositoryPaths.get(reviewComment.getLocation().getUniformPath());
            repositoryReviewComments.add(new RepositoryReviewComment(reviewComment, primaryLocationPath));
        }
    }

    public static class RepositoryReviewComment
    implements IReviewComment {
        private final IReviewComment comment;
        private final ElementLocation location;

        @VisibleForTesting
        public RepositoryReviewComment(IReviewComment comment) {
            this(comment, null);
        }

        private RepositoryReviewComment(IReviewComment comment, String repositoryPath) {
            this(comment, repositoryPath, comment.getLocation());
        }

        private RepositoryReviewComment(IReviewComment comment, String repositoryPath, ElementLocation commentLocation) {
            this.comment = comment;
            this.location = RepositoryReviewComment.createLocation(commentLocation, repositoryPath);
        }

        private static ElementLocation createLocation(ElementLocation commentLocation, String repositoryPath) {
            if (commentLocation instanceof TextRegionLocation) {
                TextRegionLocation textRegionLocation = (TextRegionLocation)commentLocation;
                return new TextRegionLocation(repositoryPath, textRegionLocation.getRawStartOffset(), textRegionLocation.getRawEndOffset(), textRegionLocation.getRawStartLine(), textRegionLocation.getRawEndLine());
            }
            return new ElementLocation(repositoryPath);
        }

        @Override
        public ETrafficLightColor getAssessment() {
            return this.comment.getAssessment();
        }

        @Override
        public String getCategory() {
            return this.comment.getCategory();
        }

        @Override
        public String getGroup() {
            return this.comment.getGroup();
        }

        @Override
        public ElementLocation getLocation() {
            return this.location;
        }

        @Override
        public List<ElementLocation> getSecondaryLocations() {
            return this.comment.getSecondaryLocations();
        }

        @Override
        public String getText() {
            return this.comment.getText();
        }

        @Override
        public String getMarkdownText() {
            return this.comment.getMarkdownText();
        }

        @Override
        public String getTeamscaleCommitDetailUrl() {
            return this.comment.getTeamscaleCommitDetailUrl();
        }

        public IReviewComment getComment() {
            return this.comment;
        }
    }
}

