/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments.comments;

import com.google.common.base.Preconditions;
import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.merge_request.comments.FindingUtils;
import com.teamscale.index.merge_request.comments.comments.FindingsForReviewComment;
import com.teamscale.index.merge_request.comments.comments.MultiFindingReviewCommentBase;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class MethodStructureFindingsReviewComment
extends MultiFindingReviewCommentBase {
    private static final String LONG_METHOD_SUGGESTION = "Consider shortening it, e.g. by extracting code blocks into separate methods.";
    private static final String DEEP_NESTING_SUGGESTION = "Consider extracting helper methods or reducing the nesting by using early breaks or returns.";
    private static final String HIGH_COMPLEXITY_SUGGESTION = "Consider refactoring it to keep it comprehensible and improve the testability.";
    private final StructureFindingsByType findingsByType;
    private StringBuilder sb;

    public MethodStructureFindingsReviewComment(FindingsForReviewComment findingsForReviewComment, CommitDescriptor commentedCommit, TeamscaleCommitLinkProvider linkProvider) {
        super(findingsForReviewComment, commentedCommit, linkProvider);
        this.findingsByType = new StructureFindingsByType(findingsForReviewComment);
    }

    @Override
    public String getText() {
        return this.buildComment(false);
    }

    @Override
    public String getMarkdownText() {
        return this.buildComment(true);
    }

    private String buildComment(boolean isMarkdown) {
        this.sb = new StringBuilder();
        if (this.isNewFinding()) {
            if (isMarkdown) {
                this.sb.append("**[New]** ");
            } else {
                this.sb.append("[New] ");
            }
        }
        this.appendProblemDescription(isMarkdown);
        this.appendSuggestion();
        if (!isMarkdown) {
            this.sb.append("\n").append(this.generateFootnoteLinks());
        }
        return this.sb.toString();
    }

    private void appendProblemDescription(boolean isMarkdown) {
        if (this.findingsByType.containsOnlyHighCyclomaticComplexity()) {
            this.sb.append(String.format("There are %s through this method. ", this.generateLink("many paths", this.findingsByType.cycloFinding.getId(), isMarkdown)));
            return;
        }
        this.sb.append("This method is ");
        if (this.findingsByType.containsLongMethod()) {
            this.sb.append(this.generateLink(MethodStructureFindingsReviewComment.getFindingText(this.findingsByType.longMethodFinding), this.findingsByType.longMethodFinding.getId(), isMarkdown));
        } else {
            this.sb.append(this.buildNestingText(isMarkdown));
        }
        if (this.findingsByType.containsLongMethod() && this.findingsByType.containsDeepNesting()) {
            this.sb.append(String.format(" and %s", this.buildNestingText(isMarkdown)));
            if (!this.findingsByType.containsHighCyclomaticComplexity()) {
                this.sb.append(" which can make it hard to understand and maintain");
            }
        }
        if (this.findingsByType.containsHighCyclomaticComplexity()) {
            this.sb.append(String.format(" making it hard to test due to the %s in the control flow", this.generateLink("many paths", this.findingsByType.cycloFinding.getId(), isMarkdown)));
        }
        this.sb.append(". ");
    }

    private String buildNestingText(boolean isMarkdown) {
        if (this.findingsByType.containsMultipleDeepNesting()) {
            if (isMarkdown) {
                return String.format("%s in %s", this.generateLink("deeply nested", this.findingsByType.nestingFinding.getId(), true), this.generateLink("multiple places", this.findingsByType.secondNestingFinding.getId(), true));
            }
            List<Integer> footnoteIds = this.addFindingsToFootnoteLinks(this.findingsByType.getNestingFindings());
            return String.format("deeply nested in multiple places %s", footnoteIds.toString());
        }
        return this.generateLink(MethodStructureFindingsReviewComment.getFindingText(this.findingsByType.nestingFinding), this.findingsByType.nestingFinding.getId(), isMarkdown);
    }

    private static String getFindingText(TrackedFinding finding) {
        Preconditions.checkArgument((FindingUtils.isLongMethodFinding(finding) || FindingUtils.isDeepNestingFinding(finding) ? 1 : 0) != 0, (Object)"Expected long method or deep nesting finding.");
        if (FindingUtils.isLongMethodFinding(finding)) {
            if (finding.getAssessment() == ETrafficLightColor.YELLOW) {
                return "a bit lengthy";
            }
            return "quite long";
        }
        if (FindingUtils.isDeepNestingFinding(finding)) {
            if (finding.getAssessment() == ETrafficLightColor.YELLOW) {
                return "slightly nested";
            }
            return "deeply nested";
        }
        return "";
    }

    private void appendSuggestion() {
        if (this.findingsByType.containsDeepNesting()) {
            this.sb.append(DEEP_NESTING_SUGGESTION);
        } else if (this.findingsByType.containsLongMethod()) {
            this.sb.append(LONG_METHOD_SUGGESTION);
        } else if (this.findingsByType.containsHighCyclomaticComplexity()) {
            this.sb.append(HIGH_COMPLEXITY_SUGGESTION);
        }
    }

    private static class StructureFindingsByType {
        private TrackedFinding nestingFinding;
        private TrackedFinding secondNestingFinding;
        private TrackedFinding thirdNestingFinding;
        private TrackedFinding longMethodFinding;
        private TrackedFinding cycloFinding;

        StructureFindingsByType(FindingsForReviewComment findingsForReviewComment) {
            this.distributeFindings((List<TrackedFinding>)findingsForReviewComment.getFindings());
            this.distributeFindings((List<TrackedFinding>)findingsForReviewComment.getRelatedFindings());
        }

        private void distributeFindings(List<TrackedFinding> findings) {
            for (TrackedFinding finding : findings) {
                if (FindingUtils.isDeepNestingFinding(finding) && this.nestingFinding == null) {
                    this.nestingFinding = finding;
                    continue;
                }
                if (FindingUtils.isDeepNestingFinding(finding) && this.secondNestingFinding == null) {
                    this.secondNestingFinding = finding;
                    continue;
                }
                if (FindingUtils.isDeepNestingFinding(finding) && this.thirdNestingFinding == null) {
                    this.thirdNestingFinding = finding;
                    continue;
                }
                if (FindingUtils.isLongMethodFinding(finding) && this.longMethodFinding == null) {
                    this.longMethodFinding = finding;
                    continue;
                }
                if (!FindingUtils.isCyclomaticComplexityFinding(finding) || this.cycloFinding != null) continue;
                this.cycloFinding = finding;
            }
        }

        boolean containsDeepNesting() {
            return this.nestingFinding != null;
        }

        boolean containsLongMethod() {
            return this.longMethodFinding != null;
        }

        boolean containsHighCyclomaticComplexity() {
            return this.cycloFinding != null;
        }

        boolean containsMultipleDeepNesting() {
            return this.secondNestingFinding != null;
        }

        boolean containsOnlyHighCyclomaticComplexity() {
            return this.containsHighCyclomaticComplexity() && !this.containsDeepNesting() && !this.containsLongMethod();
        }

        List<TrackedFinding> getNestingFindings() {
            ArrayList<TrackedFinding> findings = new ArrayList<TrackedFinding>();
            findings.add(this.nestingFinding);
            if (this.secondNestingFinding != null) {
                findings.add(this.secondNestingFinding);
            }
            if (this.thirdNestingFinding != null) {
                findings.add(this.thirdNestingFinding);
            }
            return findings;
        }
    }
}

