/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics;

import com.teamscale.core.findings.metrics.EFindingsMetricCategory;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class FindingsCountMetricUtils {
    public static SetMap<UniformPath, TrackedFinding> createPathToFindingsMap(TrackedFindingsIndex trackedFindingsIndex, List<UniformPath> affectedPaths) throws StorageException {
        SetMap uniformPathToTrackedFindings = new SetMap(SetMap.ESetFactory.IDENTITY_HASHSET);
        List<List<TrackedFinding>> trackedFindings = trackedFindingsIndex.getFindings(affectedPaths);
        for (int i = 0; i < affectedPaths.size(); ++i) {
            if (trackedFindings.get(i) == null) continue;
            uniformPathToTrackedFindings.addAll((Object)affectedPaths.get(i), (Collection)trackedFindings.get(i));
        }
        return uniformPathToTrackedFindings;
    }

    public static void persistMetrics(MetricsIndex metricsIndex, FindingBlacklistIndex blacklistIndex, Set<UniformPath> deletedKeys, SetMap<UniformPath, TrackedFinding> findingsToPersistForUniformPath) throws StorageException {
        metricsIndex.removeEntriesForUniformPaths(deletedKeys, (String[])EFindingsMetricCategory.ALL_IDS.toArray(String[]::new));
        FindingsData findingsData = FindingsCountMetricUtils.collectFindingsData(deletedKeys, blacklistIndex, findingsToPersistForUniformPath);
        for (EFindingsMetricCategory metricsCategory : EFindingsMetricCategory.values()) {
            metricsIndex.setValuesForUniformPaths(findingsData.getFindingsCount(metricsCategory), metricsCategory.getFindingsCountMetric().getId());
            metricsIndex.setValuesForUniformPaths(findingsData.getFindingSummary(metricsCategory), metricsCategory.getFindingsSummaryMetric().getId());
            metricsIndex.setValuesForUniformPaths(findingsData.getBlacklistCount(metricsCategory, EFindingBlacklistType.TOLERATION), metricsCategory.getToleratedBlacklistCountMetric().getId());
            metricsIndex.setValuesForUniformPaths(findingsData.getBlacklistCount(metricsCategory, EFindingBlacklistType.FALSE_POSITIVE), metricsCategory.getFalsePositiveBlacklistCountMetric().getId());
            metricsIndex.setValuesForUniformPaths(findingsData.getCompleteBlacklistCount(metricsCategory), metricsCategory.getCompleteBlacklistCountMetric().getId());
        }
    }

    private static FindingsData collectFindingsData(Set<UniformPath> deletedKeys, FindingBlacklistIndex blacklistIndex, SetMap<UniformPath, TrackedFinding> findingsToPersistForUniformPath) throws StorageException {
        HashSet<String> blacklistedFindingIds = new HashSet<String>(blacklistIndex.getAllFindingIds());
        FindingsData findingsData = new FindingsData();
        for (UniformPath key : findingsToPersistForUniformPath.getKeys()) {
            if (deletedKeys.contains(key)) continue;
            HashSet<TrackedFinding> findings = new HashSet<TrackedFinding>();
            HashMap<TrackedFinding, FindingBlacklistInfo> blacklistedFindings = new HashMap<TrackedFinding, FindingBlacklistInfo>();
            for (TrackedFinding finding : (Set)findingsToPersistForUniformPath.getCollection((Object)key)) {
                if (blacklistedFindingIds.contains(finding.getId())) {
                    blacklistedFindings.put(finding, blacklistIndex.getBlacklistInfo(finding.getId()));
                    continue;
                }
                findings.add(finding);
            }
            for (EFindingsMetricCategory metricsCategory : EFindingsMetricCategory.values()) {
                List findingsForCategory = CollectionUtils.filter(findings, FindingsCountMetricUtils.hasCategory(metricsCategory));
                findingsData.addFindingCount(metricsCategory, key, findingsForCategory.size());
                findingsData.addFindingSummary(metricsCategory, key, FindingsCountMetricUtils.createFindingsSummary(findingsForCategory));
                Map<EFindingBlacklistType, Long> blacklistCount = blacklistedFindings.entrySet().stream().filter(CollectionUtils.onKey(FindingsCountMetricUtils.hasCategory(metricsCategory))).collect(Collectors.groupingBy(pair -> ((FindingBlacklistInfo)pair.getValue()).getType(), Collectors.counting()));
                for (EFindingBlacklistType blacklistType : EFindingBlacklistType.values()) {
                    findingsData.addBlacklistCount(metricsCategory, blacklistType, key, blacklistCount.getOrDefault((Object)blacklistType, 0L).longValue());
                }
            }
        }
        return findingsData;
    }

    private static Predicate<TrackedFinding> hasCategory(EFindingsMetricCategory metricCategory) {
        if (metricCategory == EFindingsMetricCategory.ALL) {
            return ignored -> true;
        }
        return FindingsCountMetricUtils.hasColor(metricCategory.getTrafficLightColor());
    }

    private static Predicate<TrackedFinding> hasColor(ETrafficLightColor trafficLightColor) {
        return finding -> finding.getAssessment() == trafficLightColor;
    }

    private static CounterSet<String> createFindingsSummary(List<TrackedFinding> findings) {
        CounterSet summary = new CounterSet();
        findings.forEach(finding -> summary.inc((Object)finding.getCategoryName()));
        return summary;
    }

    private static final class FindingsData {
        private final Map<EFindingsMetricCategory, Map<UniformPath, Double>> findingsCounts = new HashMap<EFindingsMetricCategory, Map<UniformPath, Double>>();
        private final Map<EFindingsMetricCategory, Map<UniformPath, CounterSet<String>>> findingsSummaries = new HashMap<EFindingsMetricCategory, Map<UniformPath, CounterSet<String>>>();
        private final Map<EFindingsMetricCategory, Map<EFindingBlacklistType, Map<UniformPath, Double>>> blacklistCounts = new HashMap<EFindingsMetricCategory, Map<EFindingBlacklistType, Map<UniformPath, Double>>>();

        private FindingsData() {
        }

        void addFindingCount(EFindingsMetricCategory metricCategory, UniformPath uniformPath, double count) {
            this.findingsCounts.computeIfAbsent(metricCategory, ignored -> new HashMap()).merge(uniformPath, count, Double::sum);
        }

        PairList<UniformPath, Double> getFindingsCount(EFindingsMetricCategory metricCategory) {
            return Optional.ofNullable(this.findingsCounts.get(metricCategory)).map(PairList::new).orElseGet(PairList::emptyPairList);
        }

        void addFindingSummary(EFindingsMetricCategory metricCategory, UniformPath uniformPath, CounterSet counterSet) {
            this.findingsSummaries.computeIfAbsent(metricCategory, ignored -> new HashMap()).merge(uniformPath, counterSet, (c1, c2) -> {
                c1.add(c2);
                return c1;
            });
        }

        PairList<UniformPath, CounterSet<String>> getFindingSummary(EFindingsMetricCategory metricCategory) {
            return Optional.ofNullable(this.findingsSummaries.get(metricCategory)).map(PairList::new).orElseGet(PairList::emptyPairList);
        }

        void addBlacklistCount(EFindingsMetricCategory metricCategory, EFindingBlacklistType blacklistType, UniformPath uniformPath, double count) {
            this.blacklistCounts.computeIfAbsent(metricCategory, ignored -> new EnumMap(EFindingBlacklistType.class)).computeIfAbsent(blacklistType, ignored -> new HashMap()).merge(uniformPath, count, Double::sum);
        }

        PairList<UniformPath, Double> getBlacklistCount(EFindingsMetricCategory metricCategory, EFindingBlacklistType blacklistType) {
            return Optional.ofNullable(this.blacklistCounts.get(metricCategory)).map(m -> (Map)m.get((Object)blacklistType)).map(PairList::new).orElseGet(PairList::emptyPairList);
        }

        PairList<UniformPath, Double> getCompleteBlacklistCount(EFindingsMetricCategory metricCategory) {
            return this.blacklistCounts.getOrDefault(metricCategory, Collections.emptyMap()).values().stream().reduce(FindingsData.combineMaps(Double::sum)).map(PairList::new).orElseGet(PairList::emptyPairList);
        }

        private static <K, V> BinaryOperator<Map<K, V>> combineMaps(BiFunction<? super V, ? super V, ? extends V> valueCombiner) {
            return (m1, m2) -> {
                HashMap result = new HashMap(m1);
                for (Map.Entry kvEntry : m2.entrySet()) {
                    result.merge(kvEntry.getKey(), kvEntry.getValue(), valueCombiner);
                }
                return result;
            };
        }
    }
}

